/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.common;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFile;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsScriptFileVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsCommonService;
import com.jxdinfo.hussar.formdesign.extend.util.FileComparatorUtil;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.extend.util.PathComparatorUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotDataBaseStorage.class})
public class ExtendJsCommonImpl
extends BaseFileServiceImpl<ExtendJsFileInfo>
implements ExtendJsCommonService {
    @Override
    public List<ExtendJsPathVO> listJs(String metaPath, String projectPath, String pageType) throws LcdpException, IOException {
        ArrayList<ExtendJsPathVO> pathVOList = new ArrayList<ExtendJsPathVO>();
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        List<String> metaList = ParsingUtil.getFilePath(metaPath, (String)paths.get("JS_META_TYPE"));
        String sourcePath = projectPath + (String)paths.get("EXTEND_JS_PATH_AB");
        Map<String, String> jsList = ParsingUtil.getJsdPath(metaList);
        List<String> sourceList = ParsingUtil.getFilePath(sourcePath, ".js");
        Map<String, List<ExtendJsFile>> mapList = ParsingUtil.groupByFile(sourceList, sourcePath);
        for (Map.Entry<String, List<ExtendJsFile>> entry : mapList.entrySet()) {
            ExtendJsPathVO pathVO = new ExtendJsPathVO();
            String[] keys = entry.getKey().split(",");
            pathVO.setLabel(keys[0]);
            pathVO.setPath(keys[1]);
            pathVO.setParentPath(keys[2]);
            ArrayList<ExtendJsFileVO> jsFileList = new ArrayList<ExtendJsFileVO>();
            for (ExtendJsFile jsFile : entry.getValue()) {
                ExtendJsFileVO fileVO = ParsingUtil.getJsFileInformation(sourcePath + jsFile.getFilePath());
                fileVO.setSize(jsFile.getSize());
                fileVO.setFileName(jsFile.getFileName());
                fileVO.setFilePath(jsFile.getFilePath().replaceAll("\\\\", "/"));
                if (jsList.containsKey(jsFile.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""))) {
                    fileVO.setState(1);
                } else {
                    fileVO.setState(0);
                }
                jsFileList.add(fileVO);
            }
            jsFileList.sort(new FileComparatorUtil());
            pathVO.setListFile(jsFileList);
            pathVOList.add(pathVO);
        }
        ParsingUtil.createBlankDirectory(pathVOList);
        pathVOList.sort(new PathComparatorUtil());
        ParsingUtil.addBlankRootDirectory(pathVOList);
        return ParsingUtil.recursiveFilePath("0", pathVOList);
    }

    @Override
    public ExtendJsCheckVO getErrorForJs(String projectPath, String filePath, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        filePath = this.getPath(projectPath, pageType) + filePath;
        return ParsingUtil.checkMethod(filePath);
    }

    @Override
    public String getJsContentByPath(String projectPath, String filePath, String pageType) throws LcdpException {
        String content;
        filePath = filePath.replaceAll("%", "/");
        String sourcePath = this.getPath(projectPath, pageType);
        filePath = sourcePath + filePath;
        try {
            content = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return content;
    }

    @Override
    public boolean checkExists(String filePath, String pageType) throws LcdpException, IOException {
        String fileType;
        String metaSuffix;
        switch (pageType) {
            case "WebPage": {
                metaSuffix = ".jsd.meta";
                fileType = "FrontScript";
                break;
            }
            case "UniPage": {
                metaSuffix = ".ujsd.meta";
                fileType = "UniFrontScript";
                break;
            }
            case "MobilePage": {
                metaSuffix = ".mjsd.meta";
                fileType = "MobileFrontScript";
                break;
            }
            default: {
                throw new HussarException("\u6682\u4e0d\u652f\u6301 " + pageType + " \u7c7b\u578b\u7684\u9875\u9762");
            }
        }
        String metaPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        List<String> metaList = ParsingUtil.getFilePath(metaPath, metaSuffix);
        try {
            for (String path : metaList) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendJsFileInfo fileInfo = (ExtendJsFileInfo)((Object)JSON.parseObject((String)content, ExtendJsFileInfo.class));
                if (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals(fileType)) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return false;
    }

    @Override
    public RegisterJsScriptFileVO listMethodByStorage(String projectPath, ExtendJsFileInfo fileInfo, String pageType) {
        RegisterJsScriptFileVO fileVO = this.getJsFileByInfo(fileInfo);
        if (StringUtil.isNotBlank((CharSequence)fileVO.getFilePath())) {
            String sourcePath = this.getPath(projectPath, pageType);
            String filePath = sourcePath + fileVO.getFilePath();
            fileVO.setExists(ParsingUtil.fileExistsByPath(filePath));
        }
        return fileVO;
    }

    @Override
    public RegisterJsScriptFileVO listMethodByPath(String projectPath, String filePath, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        String absolutePath = this.getPath(projectPath, pageType) + filePath;
        return ParsingUtil.getJsFileDetail(absolutePath, filePath);
    }

    @Override
    public RegisterJsScriptFileVO listMethodByPathAndStorage(String projectPath, String filePath, ExtendJsFileInfo fileInfo, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        String absolutePath = this.getPath(projectPath, pageType) + filePath;
        RegisterJsScriptFileVO sourceFileVO = ParsingUtil.getJsFileDetail(absolutePath, filePath);
        RegisterJsScriptFileVO registeredFileVO = this.getJsFileByInfo(fileInfo);
        return ParsingUtil.compareFile(sourceFileVO, registeredFileVO);
    }

    private String getPath(String projectPath, String pageType) {
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        return projectPath + (String)paths.get("EXTEND_JS_PATH_AB");
    }

    private RegisterJsScriptFileVO getJsFileByInfo(ExtendJsFileInfo fileInfo) {
        RegisterJsScriptFileVO fileVO = (RegisterJsScriptFileVO)((Object)BeanUtil.copyProperties((Object)((Object)fileInfo), RegisterJsScriptFileVO.class));
        fileVO = fileVO == null ? new RegisterJsScriptFileVO() : fileVO;
        String data = fileVO.getData();
        if (StringUtil.isNotBlank((CharSequence)data)) {
            RegisterJsScriptFileVO fileDTO = (RegisterJsScriptFileVO)((Object)JsonUtil.parse((String)data, RegisterJsScriptFileVO.class));
            fileVO.setMethods(fileDTO != null ? fileDTO.getMethods() : new ArrayList<RegisterJsMethodVO>());
        }
        fileVO.setData(null);
        return fileVO;
    }
}

