/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.printTemplate.controller;

import com.jxdinfo.hussar.formdesign.printTemplate.service.PrintTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/formdesign/printTemplate"})
public class PrintTemplateController {
    @Autowired
    private PrintTemplateService printTemplateService;

    @GetMapping(value={"/download/defaultTemplate"})
    public void downloadDefault(HttpServletResponse response) throws Exception {
        this.printTemplateService.printTemplateDownload(response, null, null);
    }

    @RequestMapping(value={"/uploadPrintTemplate"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> uploadPrintTemplate(MultipartFile file) throws IOException {
        return ApiResponse.success(this.printTemplateService.uploadPrintTemplate(file), (String)"");
    }

    @GetMapping(value={"/printTemplateDownload"})
    public void printTemplateDownload(HttpServletResponse response, String templatePath, String fileName) {
        try {
            this.printTemplateService.printTemplateDownload(response, templatePath, fileName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

