/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pageTemplate.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.DefaultPageTemplate;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.formdesign.pageTemplate.service.PageTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/pageTemplate"})
public class PageTemplateController {
    @Autowired
    private PageTemplateService pageTemplateService;

    @PostMapping(value={"/check"})
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> check(@RequestBody MultipartFile file) throws Exception {
        return this.pageTemplateService.check(file);
    }

    @PostMapping(value={"/inducts"})
    public ApiResponse<PageTemplateInfo> inducts(@RequestBody PageTemplateInductsInfo pageTemplateInductsInfo) throws Exception {
        return this.pageTemplateService.inducts(pageTemplateInductsInfo);
    }

    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, @RequestBody PageTemplateInductsInfo pageTemplateInductsInfo) throws Exception {
        this.pageTemplateService.export(response, pageTemplateInductsInfo);
    }

    @PostMapping(value={"/cancel"})
    public ApiResponse<Boolean> delAwaitComponent(@RequestBody String id) throws IOException {
        return this.pageTemplateService.delAwaitPageTemplate(id) ? ApiResponse.success() : ApiResponse.fail((String)"");
    }

    @GetMapping(value={"/get"})
    public ApiResponse<DefaultPageTemplate> getPageTemplate() throws IOException, LcdpException {
        return this.pageTemplateService.getPageTemplate();
    }
}

