/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.modeltoexcel.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CharacterConversService;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelData;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelDataPreview;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelHeaderData;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelSheetData;
import com.jxdinfo.hussar.formdesign.modeltoexcel.service.ExcelReaderPlusService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelReaderPlusServiceImpl
implements ExcelReaderPlusService {
    private final String TYPE_STRING = "\u5b57\u7b26\u4e32";
    private final String TYPE_DATE = "\u65e5\u671f";
    private final String TYPE_NUMBER = "\u957f\u6574\u6570";
    private final String PUBLISHCACHENAME = "PublishCacheName";
    private final String PUBLISHCACHEKEY = "PublishCacheKey";
    @Autowired
    private CharacterConversService characterConversService;

    /*
     * Exception decompiling
     */
    @Override
    public ExcelData readExcel(InputStream is, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ByteArrayOutputStream byteArrayOutputStream(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream;
    }

    private static boolean isUTF8(InputStream inputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            bufferedInputStream.mark(3);
            int firstByte = bufferedInputStream.read();
            if (firstByte == -1) {
                boolean bl = true;
                return bl;
            }
            if ((firstByte & 0xFF) == 239) {
                int secondByte = bufferedInputStream.read();
                int thirdByte = bufferedInputStream.read();
                boolean bl = (secondByte & 0xFF) == 187 && (thirdByte & 0xFF) == 191;
                return bl;
            }
            bufferedInputStream.reset();
            boolean bl = ExcelReaderPlusServiceImpl.checkUTF8Encoding(bufferedInputStream);
            return bl;
        }
    }

    private static boolean checkUTF8Encoding(InputStream inputStream) throws IOException {
        int b;
        while ((b = inputStream.read()) != -1) {
            int b3;
            int b2;
            if ((b & 0x80) == 0) continue;
            if ((b & 0xE0) == 192) {
                b2 = inputStream.read();
                if ((b2 & 0xC0) == 128) continue;
                return false;
            }
            if ((b & 0xF0) == 224) {
                b2 = inputStream.read();
                b3 = inputStream.read();
                if ((b2 & 0xC0) == 128 && (b3 & 0xC0) == 128) continue;
                return false;
            }
            if ((b & 0xF8) == 240) {
                b2 = inputStream.read();
                b3 = inputStream.read();
                int b4 = inputStream.read();
                if ((b2 & 0xC0) == 128 && (b3 & 0xC0) == 128 && (b4 & 0xC0) == 128) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String readHeaderTypeByData(HSSFSheet sheet, int colNum, int rowNum) {
        rowNum = rowNum >= 20 ? 20 : rowNum;
        String type = "";
        for (int i = 1; i <= rowNum; ++i) {
            HSSFRow rowx = sheet.getRow(i);
            if (Objects.isNull(rowx) || Objects.isNull(rowx.getCell(colNum))) continue;
            if (rowx.getCell(colNum).getCellType() == CellType.NUMERIC) {
                if (DateUtil.isCellDateFormatted((Cell)rowx.getCell(colNum))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                if (rowx.getCell(colNum).getNumericCellValue() % 1.0 == 0.0) {
                    type = "".equals(type) || "\u957f\u6574\u6570".equals(type) ? "\u957f\u6574\u6570" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            if (rowx.getCell(colNum).getCellType() == CellType.STRING) {
                if (ExcelReaderPlusServiceImpl.isNumeric(String.valueOf(rowx.getCell(colNum))) && String.valueOf(rowx.getCell(colNum)).length() < 19) {
                    type = "".equals(type) || "\u957f\u6574\u6570".equals(type) ? "\u957f\u6574\u6570" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                if (ExcelReaderPlusServiceImpl.isDate(String.valueOf(rowx.getCell(colNum)))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            if (rowx.getCell(colNum).getCellType() == CellType.FORMULA) {
                if (DateUtil.isCellDateFormatted((Cell)rowx.getCell(colNum))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            return "\u5b57\u7b26\u4e32";
        }
        return "".equals(type) ? "\u5b57\u7b26\u4e32" : type;
    }

    private static String getCellValue(HSSFCell cell) {
        if (Objects.isNull(cell)) {
            return "";
        }
        String value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    short format = cell.getCellStyle().getDataFormat();
                    SimpleDateFormat sdf = null;
                    if (format == 14 || format == 31 || format == 57 || format == 58 || format == 176) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                    } else if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    }
                    double valuex = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)valuex);
                    value = sdf != null ? sdf.format(date).toString() : "";
                    break;
                }
                value = ExcelReaderPlusServiceImpl.realStringValueOfDouble(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getStringCellValue() + "";
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue() + "";
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                value = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return value;
    }

    private ExcelData readExcelx(XSSFWorkbook wbx, String fileName) {
        ExcelData excelData = new ExcelData();
        Integer sheetNum = wbx.getNumberOfSheets();
        excelData.setFileName(fileName);
        ArrayList<ExcelSheetData> sheetDatas = new ArrayList<ExcelSheetData>();
        for (int i = 0; i < sheetNum; ++i) {
            ExcelSheetData sheetData = new ExcelSheetData();
            XSSFSheet sheet = wbx.getSheetAt(i);
            int sheetMergedCount = sheet.getNumMergedRegions();
            if (sheetMergedCount > 0) {
                excelData.setSheetMessage(sheet.getSheetName() + "\u4e2d\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\u60c5\u51b5");
                return excelData;
            }
            int rowNum = sheet.getLastRowNum();
            if (rowNum > 50000) {
                excelData.setSheetMessage(sheet.getSheetName() + "\u4e2d\u6570\u636e\u5927\u4e8e50000\u6761");
                return excelData;
            }
            XSSFRow row = sheet.getRow(0);
            if (Objects.isNull(row) || row.getPhysicalNumberOfCells() == 0) {
                if (sheetNum != 1) continue;
                excelData.setSheetMessage("\u7b2c\u4e00\u884c\u4e0d\u80fd\u4e3a\u7a7a\u884c");
                return excelData;
            }
            XSSFCell cell = row.getCell(0);
            if (Objects.isNull(cell) || cell.getCellType() == CellType.STRING && cell.getStringCellValue().trim().isEmpty()) {
                excelData.setSheetMessage(sheet.getSheetName() + "\u4e2d\u7b2c\u4e00\u884c\u7b2c\u4e00\u5217\u6570\u636e\u4e3a\u7a7a");
                return excelData;
            }
            int colNum = row.getLastCellNum();
            if (colNum > 200) {
                excelData.setSheetMessage(sheet.getSheetName() + "\u4e2d\u5217\u6570\u5927\u4e8e200\u5217");
                return excelData;
            }
            sheetData.setSheetName(sheet.getSheetName());
            sheetData.setSheetNameEn(this.characterConversService.changeToPinyinFirstLow(sheet.getSheetName(), HanyuPinyinCaseType.UPPERCASE));
            sheetData.setSheetNum(i);
            ArrayList<ExcelHeaderData> headerData = new ArrayList<ExcelHeaderData>();
            ArrayList datas = new ArrayList();
            for (int j = 0; j < colNum; ++j) {
                ExcelHeaderData excelHeaderData = new ExcelHeaderData();
                excelHeaderData.setColNum(j);
                if (Objects.isNull(row.getCell(j))) {
                    excelHeaderData.setColName("field" + j);
                    excelHeaderData.setColNameEn("field" + j);
                } else {
                    excelHeaderData.setColName("".equals(ExcelReaderPlusServiceImpl.getCellValuex(row.getCell(j)).trim()) ? "field" + j : ExcelReaderPlusServiceImpl.getCellValuex(row.getCell(j)).trim());
                    excelHeaderData.setColNameEn("".equals(ExcelReaderPlusServiceImpl.getCellValuex(row.getCell(j)).trim()) ? "field" + j : this.characterConversService.changeToPinyinFirstLow(ExcelReaderPlusServiceImpl.getCellValuex(row.getCell(j)).trim(), HanyuPinyinCaseType.UPPERCASE).toLowerCase());
                }
                excelHeaderData.setColType(this.readHeaderTypeByDatax(sheet, j, rowNum));
                headerData.add(excelHeaderData);
            }
            HashMap count = new HashMap();
            headerData.stream().forEach(excelHeaderDatas -> {
                String en = excelHeaderDatas.getColNameEn();
                int c = count.getOrDefault(en, 0);
                count.put(en, c + 1);
                if (c > 0) {
                    excelHeaderDatas.setColNameEn(en + c);
                }
            });
            sheetData.setHeaderData(headerData);
            for (int k = 1; k <= rowNum; ++k) {
                row = sheet.getRow(k);
                if (Objects.isNull(row)) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                for (int j = 0; j < colNum; ++j) {
                    String value = ExcelReaderPlusServiceImpl.getCellValuex(row.getCell(j)).trim();
                    data.put(String.valueOf(j), value);
                }
                datas.add(data);
            }
            String cacheName = fileName + sheet.getSheetName() + "PublishCacheName";
            String cacheKey = this.characterConversService.changeToPinyinFirstLow(fileName + sheet.getSheetName(), HanyuPinyinCaseType.UPPERCASE) + "PublishCacheKey";
            HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
            HussarCacheUtil.put((String)cacheName, (Object)cacheKey, datas);
            sheetDatas.add(sheetData);
        }
        excelData.setSheetData(sheetDatas);
        return excelData;
    }

    private String readHeaderTypeByDatax(XSSFSheet sheet, int colNum, int rowNum) {
        rowNum = rowNum >= 20 ? 20 : rowNum;
        String type = "";
        for (int i = 1; i <= rowNum; ++i) {
            XSSFRow rowx = sheet.getRow(i);
            if (Objects.isNull(rowx) || Objects.isNull(rowx.getCell(colNum))) continue;
            if (rowx.getCell(colNum).getCellType() == CellType.NUMERIC) {
                if (DateUtil.isCellDateFormatted((Cell)rowx.getCell(colNum))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                if (rowx.getCell(colNum).getNumericCellValue() % 1.0 == 0.0) {
                    type = "".equals(type) || "\u957f\u6574\u6570".equals(type) ? "\u957f\u6574\u6570" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            if (rowx.getCell(colNum).getCellType() == CellType.STRING) {
                if (ExcelReaderPlusServiceImpl.isNumeric(String.valueOf(rowx.getCell(colNum))) && String.valueOf(rowx.getCell(colNum)).length() < 19) {
                    type = "".equals(type) || "\u957f\u6574\u6570".equals(type) ? "\u957f\u6574\u6570" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                if (ExcelReaderPlusServiceImpl.isDate(String.valueOf(rowx.getCell(colNum)))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            if (rowx.getCell(colNum).getCellType() == CellType.FORMULA) {
                if (DateUtil.isCellDateFormatted((Cell)rowx.getCell(colNum))) {
                    type = "".equals(type) || "\u65e5\u671f".equals(type) ? "\u65e5\u671f" : "\u5b57\u7b26\u4e32";
                    continue;
                }
                return "\u5b57\u7b26\u4e32";
            }
            return "\u5b57\u7b26\u4e32";
        }
        return "".equals(type) ? "\u5b57\u7b26\u4e32" : type;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDate(String str) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(str);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static String getCellValuex(XSSFCell cellx) {
        if (Objects.isNull(cellx)) {
            return "";
        }
        String value = "";
        switch (cellx.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cellx)) {
                    short format = cellx.getCellStyle().getDataFormat();
                    SimpleDateFormat sdf = null;
                    if (format == 14 || format == 31 || format == 57 || format == 58 || format == 176) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                    } else if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    }
                    double valuex = cellx.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)valuex);
                    value = sdf != null ? sdf.format(date).toString() : "";
                    break;
                }
                value = ExcelReaderPlusServiceImpl.realStringValueOfDouble(cellx.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cellx.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                value = cellx.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                value = cellx.getCellFormula() + "";
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                value = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return value;
    }

    public static String realStringValueOfDouble(Double d) {
        String doubleStr = d.toString();
        boolean b = doubleStr.contains("E");
        int indexOfPoint = doubleStr.indexOf(46);
        if (b) {
            int indexOfE = doubleStr.indexOf(69);
            BigInteger xs = new BigInteger(doubleStr.substring(indexOfPoint + BigInteger.ONE.intValue(), indexOfE));
            int pow = Integer.parseInt(doubleStr.substring(indexOfE + BigInteger.ONE.intValue()));
            int xsLen = xs.toByteArray().length;
            int scale = xsLen - pow > 0 ? xsLen - pow : 0;
            String format = "%." + scale + "f";
            doubleStr = String.format(format, d);
        } else {
            Pattern p = Pattern.compile(".0$");
            Matcher m = p.matcher(doubleStr);
            if (m.find()) {
                doubleStr = doubleStr.replace(".0", "");
            }
        }
        return doubleStr;
    }

    @Override
    public IPage<List<Map>> dataPreview(ExcelDataPreview excelDataPreview) {
        String fileName = excelDataPreview.getFileName();
        String sheetName = excelDataPreview.getSheetName();
        List<ExcelHeaderData> excelHeaderDataList = excelDataPreview.getExcelHeaderDataList();
        String cacheName = fileName + sheetName + "PublishCacheName";
        String cacheKey = this.characterConversService.changeToPinyinFirstLow(fileName + sheetName, HanyuPinyinCaseType.UPPERCASE) + "PublishCacheKey";
        List mapList = (List)HussarCacheUtil.get((String)cacheName, (Object)cacheKey);
        ArrayList rsList = new ArrayList();
        int num = -1;
        String key = "";
        int l = (int)((excelDataPreview.getCurrent() - 1L) * excelDataPreview.getSize());
        int s = (int)(excelDataPreview.getCurrent() * excelDataPreview.getSize()) > mapList.size() ? mapList.size() : (int)(excelDataPreview.getCurrent() * excelDataPreview.getSize());
        for (int i = l; i < s; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < excelHeaderDataList.size(); ++j) {
                num = excelHeaderDataList.get(j).getColNum();
                if (num < 0) continue;
                key = excelHeaderDataList.get(j).getColNameEn();
                map.put(key, Objects.isNull(((Map)mapList.get(i)).get(String.valueOf(num))) ? "" : ((Map)mapList.get(i)).get(String.valueOf(num)));
            }
            rsList.add(map);
        }
        Page iPage = new Page();
        iPage.setRecords(Collections.singletonList(rsList));
        iPage.setTotal((long)mapList.size());
        iPage.setCurrent(excelDataPreview.getCurrent());
        iPage.setSize(excelDataPreview.getSize());
        return iPage;
    }

    @Override
    public List<Map> getDatas(ExcelDataPreview excelDataPreview) {
        String fileName = excelDataPreview.getFileName();
        String sheetName = excelDataPreview.getSheetName();
        List<ExcelHeaderData> excelHeaderDataList = excelDataPreview.getExcelHeaderDataList();
        String cacheName = fileName + sheetName + "PublishCacheName";
        String cacheKey = this.characterConversService.changeToPinyinFirstLow(fileName + sheetName, HanyuPinyinCaseType.UPPERCASE) + "PublishCacheKey";
        List mapList = (List)HussarCacheUtil.get((String)cacheName, (Object)cacheKey);
        ArrayList<Map> rsList = new ArrayList<Map>();
        String num = "";
        String key = "";
        for (int i = 0; i < mapList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < excelHeaderDataList.size(); ++j) {
                num = String.valueOf(excelHeaderDataList.get(j).getColNum());
                if (num.equals("-1")) continue;
                key = excelHeaderDataList.get(j).getColNameEn();
                map.put(key, Objects.isNull(((Map)mapList.get(i)).get(num)) ? "" : ((Map)mapList.get(i)).get(num));
            }
            rsList.add(map);
        }
        return rsList;
    }

    private static /* synthetic */ void lambda$readExcel$0(Map count, ExcelHeaderData excelHeaderDatas) {
        String en = excelHeaderDatas.getColNameEn();
        int c = count.getOrDefault(en, 0);
        count.put(en, c + 1);
        if (c > 0) {
            excelHeaderDatas.setColNameEn(en + c);
        }
    }
}

