/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.util;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.MethodParam;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamPaserUtil {
    private static final Pattern PARAM_NAME_PATTERN = Pattern.compile("(\\((.*?)\\))");
    private static final Pattern PARAM_NOTE_SPATTERN = Pattern.compile("(\\@param)(.*?)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_PATTERN = Pattern.compile("(@param)(.*?)(\\*\\/)");
    private static final Pattern PATTERN_EXTEND = Pattern.compile("(\"extendKey\"\\s*:\\s*\")(Ext|form)(\\w{8})(_[^\"]*)(\")", 40);

    public static List<MethodParam> getParams(String methodBody, String methodName) {
        String[] methodParamNotes;
        String[] oneMethodParam;
        String jsContent = methodBody.replaceAll("[\r\n]", "").replaceAll("\\u00A0", "");
        Pattern pattern = Pattern.compile(methodName + "(\\s*)" + PARAM_NAME_PATTERN);
        Matcher paramNameMatcher = pattern.matcher(jsContent);
        String paramName = "";
        while (paramNameMatcher.find()) {
            paramName = paramNameMatcher.group();
        }
        paramName = paramName.substring(paramName.indexOf("(") + 1, paramName.indexOf(")"));
        Matcher paramNotesMatcher = PARAM_NOTE_SPATTERN.matcher(jsContent);
        StringBuilder paramNotesGroup = new StringBuilder();
        while (paramNotesMatcher.find()) {
            paramNotesGroup.append(paramNotesMatcher.group());
        }
        Matcher paramMatcher = PARAM_PATTERN.matcher(paramNotesGroup.toString());
        StringBuilder paramGroup = new StringBuilder();
        while (paramMatcher.find()) {
            paramGroup.append(paramMatcher.group());
        }
        String paramDescription = paramGroup.toString().replaceAll("(\\*\\s@)", "&&,&&,&&").replaceAll("&&,&&,&&param", "&&,&&,&&").replaceAll("@param", "").replaceAll("\\*\\/", "");
        ArrayList<MethodParam> paramList = new ArrayList<MethodParam>();
        for (String s : oneMethodParam = paramName.split(",")) {
            MethodParam methodParam = new MethodParam();
            if (!ToolUtil.isNotEmpty((Object)s)) continue;
            methodParam.setName(s.trim());
            paramList.add(methodParam);
        }
        for (String methodParamNote : methodParamNotes = paramDescription.split("&&,&&,&&")) {
            String[] oneMethodParamNotes = methodParamNote.trim().replaceAll("\\s{1,}", " ").split(" ");
            for (MethodParam methodParam : paramList) {
                if (!methodParam.getName().equals(oneMethodParamNotes[0]) || oneMethodParamNotes.length < 2) continue;
                StringBuilder content = new StringBuilder(oneMethodParamNotes[1]);
                for (int k = 2; k < oneMethodParamNotes.length; ++k) {
                    content.append(" ").append(oneMethodParamNotes[k]);
                }
                methodParam.setDescription(content.toString());
            }
        }
        return paramList;
    }

    private static String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static String replaceExtendKeys(String json) {
        Matcher matcher = PATTERN_EXTEND.matcher(json);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String prefix = matcher.group(2);
            String suffix = matcher.group(4);
            String newRandom = ParamPaserUtil.generateRandomString(8);
            String replacement = matcher.group(1) + prefix + newRandom + suffix + matcher.group(5);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

