/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.CustomComponentCategoryInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CustomComponentCategoryInfoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="CustomComponentCategoryInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class CustomComponentCategoryInfoServiceImpl
implements CustomComponentCategoryInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void createDirectory(CustomComponentCategoryInfo customComponentCategoryInfo) throws LcdpException {
        File file;
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        String path = "";
        if (!ToolUtil.isEmpty((Object)customComponentCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)customComponentCategoryInfo.getName())) {
            path = customComponentCategoryInfo.getLibName() + File.separator + customComponentCategoryInfo.getName();
        }
        if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(path, rootPath))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        try {
            FileUtils.forceMkdir((File)file);
            File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
            FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentCategoryInfo), (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.DIRECTORY_CREATE_FAIL, file.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateDirectory(CustomComponentCategoryInfo customComponentCategoryInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        String path = customComponentCategoryInfo.getLibName() + File.separator + customComponentCategoryInfo.getName();
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        try {
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentCategoryInfo), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaFile.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void deleteDirectory(String name) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        this.iterator(file, jsonObjects, name);
        String libName = "";
        if (jsonObjects.size() != 0) {
            libName = this.getCurrFileInfo(jsonObjects).getString("libName");
        }
        String path = libName + File.separator + name;
        File f = new File(this.relativeToAbsolute(path, rootPath));
        try {
            FileUtils.forceDelete((File)f);
            FileUtils.forceDelete((File)new File(this.addMeta(f.getAbsolutePath())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    public void iterator(File file, List<JSONObject> currFileInfo, String name) {
        File[] files;
        if (FileUtils.isDirectory((File)file) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)file)))) {
            for (File file1 : files) {
                String filepath = file1.getPath();
                if (this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath().equals(filepath)) continue;
                if (FileUtils.isDirectory((File)file1)) {
                    this.iterator(file1, currFileInfo, name);
                    continue;
                }
                File mataFile = new File(file1.getAbsolutePath());
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"));
                    if (!name.equals(jsonObject.getString("name"))) continue;
                    currFileInfo.add(jsonObject);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JSONObject getCurrFileInfo(List<JSONObject> jsonObjects) {
        JSONObject jsonObject = null;
        Iterator<JSONObject> iterator = jsonObjects.iterator();
        while (iterator.hasNext()) {
            JSONObject currFileInfo;
            jsonObject = currFileInfo = iterator.next();
        }
        return jsonObject;
    }
}

