/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateFileTreeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageTemplateFileTreeServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class PageTemplateFileTreeServiceDBImpl
implements PageTemplateFileTreeService {
    private final FormDesignProperties formDesignProperties;
    private final PathStrategyService pathStrategy;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;

    @Autowired
    public PageTemplateFileTreeServiceDBImpl(FormDesignProperties formDesignProperties, PathStrategyService pathStrategy) {
        this.formDesignProperties = formDesignProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTree(String libName) throws IOException {
        FormDesignResponse response = new FormDesignResponse();
        List<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        ArrayList<String> errorFiles = new ArrayList<String>();
        List sysMidFileInfos = this.sysMidFileInfoService.listByPageType(libName);
        if (HussarUtils.isEmpty((Object)sysMidFileInfos)) {
            return response;
        }
        this.iteratorByDB(jsonObjects, sysMidFileInfos, errorFiles);
        String errStr = String.valueOf(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        System.out.println(errStr);
        jsonObjects = this.treeSort(jsonObjects);
        response.setData(jsonObjects);
        return response;
    }

    private void iteratorByDB(List<JSONObject> jsonObjects, List<SysMidFileInfo> sysMidFileInfos, List<String> errorFiles) throws IOException {
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            String fileContent = sysMidFileInfo.getMidFileInfoData();
            if (!HussarUtils.isNotEmpty((Object)fileContent)) continue;
            JSONObject jsonObject = JSON.parseObject((String)fileContent);
            if (jsonObject == null) {
                errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + sysMidFileInfo.getMidFileInfoPath());
                continue;
            }
            if (jsonObject.get((Object)"data") != null) {
                jsonObject.put("data", (Object)jsonObject.get((Object)"data").toString());
            }
            jsonObjects.add(jsonObject);
            String type = jsonObject.getString("type");
            if (!ToolUtil.isNotEmpty((Object)type) || !"DataModel".equals(type)) continue;
            JSONObject dataJsonObject = JSON.parseObject((String)fileContent);
            jsonObject.put("data", (Object)dataJsonObject);
        }
    }

    private List<JSONObject> treeSort(List<JSONObject> jsonObjects) {
        final Collator collator = Collator.getInstance();
        jsonObjects.sort(new Comparator<JSONObject>(){
            private static final String ORDER_FIELD = "label";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                String labelA = "";
                String labelB = "";
                try {
                    if ("category".equals(a.getString("fileType"))) {
                        labelA = a.getString(ORDER_FIELD);
                    }
                    if ("category".equals(b.getString("fileType"))) {
                        labelB = b.getString(ORDER_FIELD);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return collator.compare(labelA, labelB);
            }
        });
        for (JSONObject jsonObject : jsonObjects) {
            if (!"category".equals(jsonObject.getString("fileType")) || !"defaultCategory".equals(jsonObject.getString("name"))) continue;
            jsonObjects.remove(jsonObject);
            jsonObjects.add(0, jsonObject);
            break;
        }
        return jsonObjects;
    }
}

