/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateCategoryInfo;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateCategoryInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageTemplateCategoryInfoServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class PageTemplateCategoryInfoServiceDBImpl
implements PageTemplateCategoryInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void createDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        File file;
        File fileOfMeta;
        String absolutePath;
        String path = "";
        if (!ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getName())) {
            path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        }
        if (this.sysMidFileInfoService.checkExist(absolutePath = (fileOfMeta = new File(this.addMeta((file = new File(this.relativeToAbsolute(path, ""))).getPath()))).getPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, fileOfMeta.getPath());
        }
        SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
        sysMidFileInfo.setMidFileInfoPath(absolutePath);
        sysMidFileInfo.setMidFileInfoData(JSONObject.toJSONString((Object)pageTemplateCategoryInfo));
        sysMidFileInfo.setPageType(pageTemplateCategoryInfo.getLibName());
        sysMidFileInfo.setMidFileInfoType(pageTemplateCategoryInfo.getFileType());
        this.sysMidFileInfoService.saveMore(sysMidFileInfo);
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        String path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        File file = new File(this.relativeToAbsolute(path, ""));
        File metaFile = new File(file.getPath() + ".meta");
        String absolutePath = metaFile.getPath();
        if (!this.sysMidFileInfoService.checkExist(absolutePath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, file.getPath());
        }
        this.sysMidFileInfoService.update(absolutePath, JSON.toJSONString((Object)pageTemplateCategoryInfo));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void deleteDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException, IOException {
        String path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        File cateFile = new File(this.relativeToAbsolute(path, ""));
        String absolutePath = cateFile.getPath();
        List sysMidFileInfos = this.sysMidFileInfoService.listLikePath(pageTemplateCategoryInfo.getName());
        ArrayList<String> coverPathList = new ArrayList<String>();
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            String fileContent = sysMidFileInfo.getMidFileInfoData();
            JSONObject content = JSON.parseObject((String)fileContent);
            Object coverObj = content.get((Object)"cover");
            if (!HussarUtils.isNotEmpty((Object)coverObj)) continue;
            String coverName = String.valueOf(coverObj);
            String coverPath = File.separator + "cover" + File.separator + coverName;
            coverPathList.add(coverPath);
        }
        this.sysMidFileInfoService.removeInPaths(coverPathList);
        this.sysMidFileInfoService.removeBatchByIds((Collection)sysMidFileInfos);
        this.fileMappingService.fileMappingCacheEvict();
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }
}

