/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.ResourceCascadeCommonService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class ResourceCascadeDbServiceImpl
extends ResourceCascadeCommonService
implements ResourceCascadeService {
    private static final String RESOURCE_DEL_FLAG = "1";
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;

    public void deleteModelPublishFile(String id) {
        this.deletePublishFile(id);
    }

    public void deleteVuePublishFile(String id) {
        this.deletePublishFile(id);
    }

    public JSONObject getJSONObject(String id) throws IOException, LcdpException {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            JSONObject jsonObject = JSONObject.parseObject((String)metaFile.getData());
            return jsonObject;
        }
        return null;
    }

    public void deleteWorkFlowPublishFile(String id) throws IOException {
        String publishPath = FileUtil.posixPath((String[])new String[]{"/publish/version/ancestor", id.replace("_", "/") + "hussar"});
        this.deletePublishFile(publishPath.replace("/", "\\\\"));
    }

    public void deleteModulePublishFile(String id) throws IOException {
        ArrayList<SysMidFileCode> subResourceList = new ArrayList<SysMidFileCode>();
        this.getSubResourceList(id, subResourceList);
        ArrayList<SysMidFileInfo> delMidFileInfos = new ArrayList<SysMidFileInfo>();
        for (SysMidFileCode midFileCode : subResourceList) {
            if ("WebPage".equals(midFileCode.getType()) || "DataModel".equals(midFileCode.getType())) {
                this.getDelMidFileInfos(midFileCode.getFileId(), delMidFileInfos);
                continue;
            }
            if (!"Workflow".equals(midFileCode.getType())) continue;
            String publishPath = FileUtil.posixPath((String[])new String[]{"/publish/version/ancestor", midFileCode.getName().replace("_", "/") + "hussar"}).replace("/", "\\\\");
            this.getDelMidFileInfos(publishPath, delMidFileInfos);
        }
        this.sysMidFileInfoService.updateBatchById(delMidFileInfos);
    }

    private void getSubResourceList(String id, List<SysMidFileCode> results) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMidFileCode::getParentId, (Object)id);
        queryWrapper.eq(SysMidFileCode::getMetaFlag, (Object)RESOURCE_DEL_FLAG);
        List sysMidFileCodes = this.sysMidFileCodeService.list((Wrapper)queryWrapper);
        for (SysMidFileCode sysMidFileCode : sysMidFileCodes) {
            results.add(sysMidFileCode);
            this.getSubResourceList(sysMidFileCode.getFileId(), results);
        }
    }

    private void getDelMidFileInfos(String id, List<SysMidFileInfo> results) {
        List midFileInfos = this.sysMidFileInfoService.list((Wrapper)new LambdaQueryWrapper().like(SysMidFileInfo::getMidFileInfoPath, (Object)id));
        for (SysMidFileInfo midFileInfo : midFileInfos) {
            SysMidFileInfo delMidFileInfo = new SysMidFileInfo();
            delMidFileInfo.setMidFileInfoId(midFileInfo.getMidFileInfoId());
            delMidFileInfo.setDelFlag(RESOURCE_DEL_FLAG);
            results.add(delMidFileInfo);
        }
    }
}

