/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.BaseFileDataBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class ModuleInfoDataBaseServiceImpl
extends BaseFileDataBaseServiceImpl<ModuleInfo>
implements ModuleInfoService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    @Resource
    private FileDataBaseHelper fileDataBaseHelper;

    @Override
    public FormDesignResponse<String> createDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        FormDesignResponse response = new FormDesignResponse();
        this.sysMidFileCodeService.saveFile((BaseFile)moduleInfo);
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public FormDesignResponse<String> createDirectoryBatch(List<ModuleInfo> moduleInfoList) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        for (ModuleInfo moduleInfo : moduleInfoList) {
            FormDesignResponse<String> formDesignResponse = this.createDirectory(moduleInfo);
            if (formDesignResponse.getErrorCode() == HttpStatus.OK.value()) continue;
            return formDesignResponse;
        }
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public void copyDirectory(String id, String parentId, String uuid, String newName, String newDesc) throws LcdpException, IOException {
    }

    @Override
    public FormDesignResponse<ModuleInfo> deleteDirectory(String id) throws LcdpException, IOException {
        this.sysMidFileCodeService.deleteModuleResource(id);
        return new FormDesignResponse();
    }

    @Override
    public void updateDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        SysMidFileCode moduleMetaFileInfo = this.sysMidFileCodeService.getMetaFile(moduleInfo.getId());
        if (HussarUtils.isEmpty((Object)moduleMetaFileInfo)) {
            throw new HussarException("\u672a\u627e\u5230\u8d44\u6e90\u6570\u636e");
        }
        moduleMetaFileInfo.setName(moduleInfo.getName());
        moduleMetaFileInfo.setData(JSON.toJSONString((Object)((Object)moduleInfo)));
        this.sysMidFileCodeService.updateById((Object)moduleMetaFileInfo);
    }

    @Override
    public void moveDirectory(String id, String parentId, String newName, String newDesc) throws LcdpException, IOException {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        metaFile.setParentId(parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFile.setName(newName);
        }
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        if (newName != null) {
            metaFileData.put("name", (Object)newName);
        }
        if (newDesc != null) {
            metaFileData.put("desc", (Object)newDesc);
        }
        this.sysMidFileCodeService.updateById((Object)metaFile);
    }
}

