/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.CustomComponentGroupInfo;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelPageManifest;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.ModelPageTemplate;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/speed/pageTemplateInfo"})
public class PageTemplateInfoController {
    @Resource
    private PageTemplateInfoService pageTemplateInfoService;

    @PostMapping(value={"/add"})
    public FormDesignResponse<CustomComponentGroupInfo> addDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.create(pageTemplateInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<PageInfo> updateDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.updateFileMeta(pageTemplateInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/delete"})
    public FormDesignResponse<PageInfo> deleteDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.delete(pageTemplateInfo);
        return new FormDesignResponse();
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public FormDesignResponse<String> upload(@RequestPart(value="file") MultipartFile file) throws LcdpException, IOException {
        return this.pageTemplateInfoService.upload(file);
    }

    @GetMapping(value={"/delCover"})
    public FormDesignResponse<PageInfo> delCover(String fileName) throws LcdpException, IOException {
        this.pageTemplateInfoService.delCover(fileName);
        return new FormDesignResponse();
    }

    @GetMapping(value={"/getCover"})
    public ResponseEntity<byte[]> getCover(String fileName) throws IOException, LcdpException {
        return this.pageTemplateInfoService.getCover(fileName);
    }

    @PostMapping(value={"/saveTemplate"})
    public ApiResponse<String> uploadTemplate(@RequestParam String functionType, @RequestParam String pageType, @RequestBody MultipartFile zipFile) throws IOException {
        return this.pageTemplateInfoService.uploadTemplate(functionType, pageType, zipFile);
    }

    @GetMapping(value={"/getTemplate"})
    public ApiResponse<List<ModelPageTemplate>> getTemplate(@RequestParam String functionType, @RequestParam String pageType) throws IOException {
        return this.pageTemplateInfoService.getTemplate(functionType, pageType);
    }

    @GetMapping(value={"/importTemplate"})
    public ApiResponse<String> importTemplate(@RequestParam Long fileId) throws IOException {
        return this.pageTemplateInfoService.importTemplate(fileId);
    }

    @PostMapping(value={"/checkTemplate"})
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkTemplate(@RequestBody MultipartFile zipFile) throws IOException {
        return this.pageTemplateInfoService.checkTemplate(zipFile);
    }

    @GetMapping(value={"/import/model_pages"})
    public ApiResponse<String> importModelPages(@RequestParam Long fileId) throws IOException {
        return this.pageTemplateInfoService.importModelPages(fileId);
    }

    @PostMapping(value={"/check/model_pages"})
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkModelPages(@RequestBody MultipartFile zipFile) throws IOException {
        return this.pageTemplateInfoService.checkModelPages(zipFile);
    }

    @GetMapping(value={"/list/model_pages"})
    public FormDesignResponse<Map<String, List<ModelPageManifest>>> listModelPages(@RequestParam String pageType) throws IOException, LcdpException {
        return this.pageTemplateInfoService.listModelPages(pageType);
    }

    @PostMapping(value={"/down/model_pages"})
    public ResponseEntity<byte[]> downModelPages(@RequestBody List<ModelPageManifest> manifests) throws IOException, LcdpException {
        return this.pageTemplateInfoService.downModelPages(manifests);
    }

    @GetMapping(value={"/editTemplateName"})
    public ApiResponse<String> editTemplateName(@RequestParam String functionType, @RequestParam String pageType, @RequestParam String identity, @RequestParam String templateName) throws IOException {
        return this.pageTemplateInfoService.editTemplateName(functionType, pageType, identity, templateName);
    }

    @GetMapping(value={"/deleteTemplate"})
    public ApiResponse<String> deleteTemplate(@RequestParam String functionType, @RequestParam String pageType, @RequestParam String identity) throws IOException {
        return this.pageTemplateInfoService.deleteTemplate(functionType, pageType, identity);
    }
}

