/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateCategoryInfo;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateCategoryInfoService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageTemplateCategoryInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class PageTemplateCategoryInfoServiceOnLineImpl
implements PageTemplateCategoryInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private StorageService storageService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void createDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        if (!ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getName())) {
            String catePath = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
            String metaPath = this.addMeta(this.relativeToAbsolute(catePath, rootPath));
            Boolean isExists = Boolean.TRUE.equals(this.storageService.existsByPath(metaPath).getData());
            if (isExists.booleanValue()) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaPath);
            }
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateCategoryInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u6a21\u677f\u5206\u7c7b\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void updateDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        if (!ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getName())) {
            String catePath = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
            String metaPath = this.addMeta(this.relativeToAbsolute(catePath, rootPath));
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateCategoryInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u6a21\u677f\u5206\u7c7b\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void deleteDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        String filePath = this.relativeToAbsolute(pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName(), rootPath);
        this.storageService.deleteByPath(this.addMeta(filePath), false);
        List storageEntities = (List)this.storageService.list(filePath, ".meta", true).getData();
        this.deletePageTemps(storageEntities, filePath);
    }

    public void deletePageTemps(List<StorageEntity> storageEntities, String catePath) throws LcdpException, IOException {
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject file = JSON.parseObject((String)new String(storageEntity.getContent() != null ? storageEntity.getContent() : "".getBytes(), "UTF-8"));
            String fileName = file.getString("name");
            String cover = file.getString("cover");
            String filePath = catePath + File.separator + fileName;
            this.storageService.deleteByPath(this.addMeta(filePath), false);
            this.delCover(cover);
        }
    }

    public void delCover(String fileName) throws LcdpException {
        if (!"".equals(fileName)) {
            String fileSavePath = this.pathStrategy.resourcePathService().projectStorePageTemplateCover(new String[0]).getRemotePath();
            String filePath = ToolUtil.pathFomatterByOS((String)fileSavePath) + File.separator + fileName;
            this.storageService.deleteByPath(filePath, false);
        }
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }
}

