/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.MetaConfigVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MetaFileService;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="MetaFileServiceOnlineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class MetaFileServiceOnlineImpl
implements MetaFileService {
    @Autowired
    private FileMappingService fileMappingService;
    @Autowired
    private LcdpVersionProperties lcdpVersionProperties;
    @Autowired
    private FormDesignProperties formDesignProperties;
    private static final String UPGRADE = "upgrade";
    private static final String REPLACED_ID = "replacedId";
    private static final String VERSION = "version";

    @Override
    public MetaConfigVo updateMetaVersionById(String id) throws LcdpException, IOException {
        String lcdpVersion;
        MetaConfigVo metaConfigVo = new MetaConfigVo();
        String metaPath = this.fileMappingService.getMetaPath(id);
        JSONObject jsonObject = this.fileMappingService.getJsonObjectById(id);
        String rootPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath()});
        File metaFile = new File(this.relativeToAbsolute(metaPath, rootPath));
        String currentVersion = (String)jsonObject.get((Object)VERSION);
        if (!HussarUtils.equals((Object)currentVersion, (Object)(lcdpVersion = this.lcdpVersionProperties.getLcdpVersion()))) {
            List ids = (List)ToolCacheUtile.get((String)UPGRADE, (String)(REPLACED_ID + id));
            ToolCacheUtile.evict((String)UPGRADE, (String)(REPLACED_ID + id));
            if (HussarUtils.isNotEmpty((Object)ids)) {
                List replacedId = (List)jsonObject.get((Object)REPLACED_ID);
                if (HussarUtils.isNotEmpty((Object)replacedId)) {
                    ids.addAll(replacedId);
                }
                jsonObject.put(REPLACED_ID, (Object)ids);
                metaConfigVo.setReplacedId(ids);
            }
            jsonObject.put(VERSION, (Object)lcdpVersion);
            metaConfigVo.setVersion(lcdpVersion);
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
            return metaConfigVo;
        }
        return metaConfigVo;
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }
}

