/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CustomComponentsFileTreeService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="CustomComponentsFileTreeServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class CustomComponentsFileTreeServiceOnLineImpl
implements CustomComponentsFileTreeService {
    private final StorageService storageService;
    private final PathStrategyService pathStrategy;

    @Autowired
    public CustomComponentsFileTreeServiceOnLineImpl(StorageService storageService, PathStrategyService pathStrategy) {
        this.storageService = storageService;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTree(String libName) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        String libPath = ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath() + File.separator + libName));
        List storageEntities = (List)this.storageService.list(libPath = ToolUtil.pathFomatterByOS((String)libPath), ".meta", true).getData();
        if (ToolUtil.isEmpty((Object)storageEntities)) {
            return response;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        List<JSONObject> fileList = this.iterator(storageEntities, errorFiles);
        String errStr = String.valueOf(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        response.setData(this.treeSort(fileList));
        return response;
    }

    private List<JSONObject> iterator(List<StorageEntity> storageEntities, List<String> errorFiles) throws IOException {
        ArrayList<JSONObject> fileList = new ArrayList<JSONObject>();
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject file = JSON.parseObject((String)new String(storageEntity.getContent(), "UTF-8"));
            if (file == null) {
                errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + storageEntity.getPath());
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    private List<JSONObject> treeSort(List<JSONObject> jsonObjects) {
        final Collator collator = Collator.getInstance();
        jsonObjects.sort(new Comparator<JSONObject>(){
            private static final String ORDER_FIELD = "label";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                String labelA = "";
                String labelB = "";
                try {
                    if ("category".equals(a.getString("fileType"))) {
                        labelA = a.getString(ORDER_FIELD);
                    }
                    if ("category".equals(b.getString("fileType"))) {
                        labelB = b.getString(ORDER_FIELD);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return collator.compare(labelA, labelB);
            }
        });
        return jsonObjects;
    }
}

