/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ResourceFileOperateCommonDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ResourceFileOperateCommonVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ResourceFileOperateCommonService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.ResourceFileOperateCommonServiceImpl")
public class ResourceFileOperateCommonServiceImpl
implements ResourceFileOperateCommonService {
    @Autowired
    private SysMidFileCodeService midFileCodeService;

    @Override
    public ApiResponse<ResourceFileOperateCommonVo> checkResourceName(ResourceFileOperateCommonDto commonDto) {
        String delFlag = "0";
        AssertUtil.isNotEmpty((String)commonDto.getParentId(), (String)"\u7236\u7ea7ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)commonDto.getCurrentName(), (String)"\u8d44\u6e90\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)commonDto.getCurrentDesc(), (String)"\u8d44\u6e90\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ResourceFileOperateCommonVo operateCommonVo = new ResourceFileOperateCommonVo();
        operateCommonVo.setNameCheckUniqueFlag(true);
        operateCommonVo.setDescCheckUniqueFlag(true);
        List midFileCodes = this.midFileCodeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)commonDto.getParentId())).eq(SysMidFileCode::getMetaFlag, (Object)true)).eq(HussarDelflagEntity::getDelFlag, (Object)delFlag));
        if (HussarUtils.isNotEmpty((Object)midFileCodes)) {
            for (SysMidFileCode m : midFileCodes) {
                PageInfo pageInfo = (PageInfo)JSONObject.parseObject((String)m.getData(), PageInfo.class);
                if (commonDto.getCurrentName().equals(pageInfo.getName())) {
                    operateCommonVo.setNameCheckUniqueFlag(false);
                }
                if (commonDto.getCurrentDesc().equals(pageInfo.getDesc())) {
                    operateCommonVo.setDescCheckUniqueFlag(false);
                }
                if (operateCommonVo.isNameCheckUniqueFlag() && operateCommonVo.isDescCheckUniqueFlag()) continue;
                break;
            }
        }
        return ApiResponse.success((Object)operateCommonVo);
    }

    @Override
    public ApiResponse<String> getStorageTypeCurrentEnv() {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
        if (formDesignProperties.getScenes().isDataBase()) {
            return ApiResponse.success((String)"DATABASE");
        }
        return ApiResponse.success((String)"PROJECTSTORE");
    }
}

