/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="ModuleInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class ModuleInfoServiceImpl
extends BaseFileServiceImpl<ModuleInfo>
implements ModuleInfoService {
    private final PathStrategyService pathStrategy;

    @Autowired
    public ModuleInfoServiceImpl(FileMappingService fileMappingService, FormDesignProperties speedCodeProperties, PathStrategyService pathStrategy) {
        this.formDesignProperties = speedCodeProperties;
        this.fileMappingService = fileMappingService;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public FormDesignResponse<String> createDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        File file;
        FormDesignResponse response = new FormDesignResponse();
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)moduleInfo.getParentId()) && !"#".equals(moduleInfo.getParentId())) {
            parentPath = this.getDataPath(moduleInfo.getParentId());
        }
        if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(parentPath + File.separator + moduleInfo.getName(), rootPath))))) {
            response.setErrorCode(LcdpExceptionEnum.FILE_ALREADY_EXIST.getCode());
            response.setErrorMsg(LcdpExceptionEnum.FILE_ALREADY_EXIST.getMsg());
            response.setData((Object)LcdpExceptionEnum.FILE_ALREADY_EXIST.getMsg());
            return response;
        }
        try {
            FileUtils.forceMkdir((File)file);
            File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
            FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)moduleInfo), (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            response.setErrorCode(LcdpExceptionEnum.DIRECTORY_CREATE_FAIL.getCode());
            response.setErrorMsg(LcdpExceptionEnum.DIRECTORY_CREATE_FAIL.getMsg() + file.getAbsolutePath());
            response.setData((Object)LcdpExceptionEnum.DIRECTORY_CREATE_FAIL.getMsg());
            return response;
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public FormDesignResponse<String> createDirectoryBatch(List<ModuleInfo> moduleInfoList) throws LcdpException, IOException {
        FormDesignResponse response = new FormDesignResponse();
        for (ModuleInfo moduleInfo : moduleInfoList) {
            FormDesignResponse<String> formDesignResponse = this.createDirectory(moduleInfo);
            if (formDesignResponse.getErrorCode() == HttpStatus.OK.value()) continue;
            return formDesignResponse;
        }
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public void copyDirectory(String id, String parentId, String uuid, String newName, String newDesc) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isDirectory((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)to)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        to = newName != null && !newName.equals("") ? new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath)) : new File(this.relativeToAbsolute(parentPath + File.separator + from.getName(), rootPath));
        if (!FileUtils.exists((File)to)) {
            FileUtils.forceMkdir((File)to);
        }
        File metaTo = new File(to.getAbsolutePath() + ".meta");
        try {
            for (File file : FileUtils.listFiles((File)from)) {
                if (FileUtils.isDirectory((File)file)) {
                    this.copyFile(file, to);
                    continue;
                }
                if (file.getName().indexOf(".dbd") >= 0) continue;
                FileUtils.copyFileToDirectory((File)file, (File)to, (boolean)false);
            }
            FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
        }
        File reRootMetaFile = new File(metaTo.getAbsolutePath());
        File reRootFile = new File(to.getAbsolutePath());
        if (FileUtils.exists((File)reRootMetaFile)) {
            File[] files;
            JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)reRootMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            jsonObject.put("id", (Object)uuid);
            if (newName != null) {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null) {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)reRootMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
            if (FileUtils.exists((File)reRootFile) && FileUtils.isDirectory((File)reRootFile) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)reRootFile)))) {
                int workFlowCount = 0;
                for (File file : files) {
                    this.iteratorFile(file, uuid, workFlowCount);
                    ++workFlowCount;
                }
            }
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store\uff0c\u590d\u5236\u6a21\u5757\u6216\u6587\u4ef6\u5939", new Object[0]), Collections.singletonList(rootPath));
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    private void copyFile(File file, File to) throws IOException {
        if (FileUtils.isDirectory((File)file)) {
            File target = new File(to, file.getName());
            if (!FileUtils.exists((File)target)) {
                FileUtils.forceMkdir((File)target);
            }
            for (File source : FileUtils.listFiles((File)file)) {
                if (FileUtils.isDirectory((File)source)) {
                    this.copyFile(source, target);
                    continue;
                }
                if (source.getName().indexOf(".dbd") >= 0) continue;
                try {
                    FileUtils.copyFileToDirectory((File)source, (File)target, (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void iteratorFile(File parentFile, String parentId, Integer workflowCount) throws LcdpException {
        if (FileUtils.exists((File)parentFile)) {
            File[] files;
            File metaFile = new File(this.addMeta(parentFile.getAbsolutePath()));
            if (FileUtils.exists((File)metaFile)) {
                try {
                    JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
                    jsonObject.put("parentId", (Object)parentId);
                    String id = ToolUtil.get36UUID();
                    if (FileUtils.isDirectory((File)parentFile)) {
                        parentId = id;
                    }
                    jsonObject.put("id", (Object)id);
                    if ("Workflow".equals(jsonObject.get((Object)"type"))) {
                        SimpleDateFormat identitySdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                        jsonObject.put("identity", (Object)("key-" + identitySdf.format(new Date()) + workflowCount));
                    }
                    FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaFile.getAbsolutePath());
                }
            }
            if (FileUtils.isDirectory((File)parentFile) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)parentFile)))) {
                for (File file : files) {
                    this.iteratorFile(file, parentId, workflowCount);
                    Integer n = workflowCount;
                    Integer n2 = workflowCount = Integer.valueOf(workflowCount + 1);
                }
            }
        }
    }

    @Override
    public FormDesignResponse<ModuleInfo> deleteDirectory(String id) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getDataPath(id);
        String dirPath = this.relativeToAbsolute(path, rootPath);
        File f = new File(dirPath);
        try {
            FileUtils.forceDelete((File)f);
            FileUtils.forceDelete((File)new File(this.addMeta(f.getAbsolutePath())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.project_store\uff0c\u5220\u9664\u6a21\u5757\uff1a%s", dirPath), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
        return new FormDesignResponse();
    }

    @Override
    public void updateDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(moduleInfo.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        boolean needRename = this.justRename(moduleInfo, metaFile);
        try {
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)moduleInfo), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaFile.getAbsolutePath());
        }
        if (needRename) {
            this.renameTwoFile(moduleInfo, file, metaFile, rootPath);
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6\uff1a.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void moveDirectory(String id, String parentId, String newName, String newDesc) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File pFile = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isDirectory((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)pFile)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, pFile.getAbsolutePath());
        }
        File newMetaFile = null;
        if (newName != null && !newName.equals("")) {
            pFile = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
            File metaTo = new File(pFile.getAbsolutePath() + ".meta");
            try {
                if (!pFile.exists()) {
                    FileUtils.moveDirectory((File)from, (File)pFile);
                    FileUtils.moveFile((File)metaFrom, (File)metaTo);
                } else {
                    FileUtils.moveDirectoryToDirectory((File)from, (File)pFile, (boolean)false);
                    FileUtils.moveFile((File)metaFrom, (File)metaTo);
                }
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(this.addMeta(pFile.getAbsolutePath()));
        } else {
            try {
                FileUtils.moveDirectoryToDirectory((File)from, (File)pFile, (boolean)true);
                FileUtils.moveFileToDirectory((File)metaFrom, (File)pFile, (boolean)true);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(pFile.getAbsolutePath() + File.separator + metaFrom.getName());
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            if (newName != null) {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null) {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newMetaFile.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6\uff1a.project_store", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }
}

