/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.common.collect.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.refer.PageRefer;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendScriptInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.FileLockCacheInfo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.FileResourceOccupyInfo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataCellInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.FileLockManagerServiceImpl")
public class FileLockManagerServiceImpl
implements FileLockManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockManagerServiceImpl.class);
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private DataCellInfoService dataCellInfoService;
    @Autowired
    private ExtendScriptInfoService extendScriptInfoService;
    @Autowired
    private FileTreeService fileTreeService;
    @Resource
    private FormDesignProperties formDesignProperties;
    private static final String CACHE_NAME_OCCUPY = "lockOccupy";
    public static final String MODULE_FOLDER = "Folder";

    @Override
    public ApiResponse<FileLockInfoVo> setFileLockContainCheck(FileResourceOccupyInfo occupyInfo) {
        FileLockInfoVo occupyInfoReturn = new FileLockInfoVo();
        occupyInfoReturn.setResourceId(occupyInfo.getResourceId());
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        String currentIp = IpUtils.getIp();
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)occupyInfo.getResourceId());
        ArrayList referFileLockOccupys = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isNotEmpty((Object)currentIdCache)) {
            LOGGER.info("\u5f53\u524d\u8d44\u6e90:{},\u4ece\u7f13\u5b58\u67e5\u8be2\u5230\u9501\u5360\u7528:{}", (Object)occupyInfo.getResourceId(), (Object)JSON.toJSONString((Object)currentIdCache));
            if (!HussarUtils.equals((Object)currentUserId, (Object)currentIdCache.getOccupyUserId()) || !currentIp.equals(currentIdCache.getOccupyUserIp())) {
                occupyInfoReturn.setOccupyFlag(true);
                occupyInfoReturn.setResourceName(currentIdCache.getResourceName());
                occupyInfoReturn.setOccupyUserId(currentIdCache.getOccupyUserId());
                occupyInfoReturn.setOccupyUserName(currentIdCache.getOccupyUserName());
                occupyInfoReturn.setOccupyUserIp(currentIdCache.getOccupyUserIp());
                return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5931\u8d25");
            }
            if (HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) {
                LOGGER.info("\u5f53\u524d\u8d44\u6e90:{},\u4ece\u7f13\u5b58\u67e5\u8be2\u5230\u5176\u5173\u8054\u8d44\u6e90\u9501\u5360\u7528:{}", (Object)occupyInfo.getResourceId(), (Object)currentIdCache.getReferResourceIds().stream().collect(Collectors.joining(",")));
                for (String id : currentIdCache.getReferResourceIds()) {
                    FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                    if (!HussarUtils.isNotEmpty((Object)associatedIdCache) || HussarUtils.equals((Object)currentUserId, (Object)associatedIdCache.getOccupyUserId()) && currentIp.equals(associatedIdCache.getOccupyUserIp())) continue;
                    FileLockInfoVo referFileLockOccupy = this.getReferFileLockInfoVo(associatedIdCache);
                    referFileLockOccupys.add(referFileLockOccupy);
                }
                if (HussarUtils.isNotEmpty((Object)referFileLockOccupys)) {
                    occupyInfoReturn.setOccupyFlag(false);
                    occupyInfoReturn.setReferResourceLockOccupys((List)referFileLockOccupys);
                    return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5931\u8d25");
                }
            }
        } else {
            this.fillOccupyInfoByFile(occupyInfo);
            if (HussarUtils.isNotEmpty(occupyInfo.getReferResourceIds())) {
                LOGGER.info("\u5f53\u524d\u8d44\u6e90\uff1a{},\u5176\u6587\u4ef6\u5173\u8054\u7684\u8d44\u6e90\uff1a{}", (Object)occupyInfo.getResourceId(), (Object)occupyInfo.getReferResourceIds().stream().collect(Collectors.joining(",")));
                for (String id : occupyInfo.getReferResourceIds()) {
                    FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                    if (!HussarUtils.isNotEmpty((Object)associatedIdCache) || HussarUtils.equals((Object)currentUserId, (Object)associatedIdCache.getOccupyUserId()) && currentIp.equals(associatedIdCache.getOccupyUserIp())) continue;
                    FileLockInfoVo referFileLockOccupy = this.getReferFileLockInfoVo(associatedIdCache);
                    referFileLockOccupys.add(referFileLockOccupy);
                }
                if (HussarUtils.isNotEmpty((Object)referFileLockOccupys)) {
                    occupyInfoReturn.setOccupyFlag(false);
                    occupyInfoReturn.setReferResourceLockOccupys((List)referFileLockOccupys);
                    return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5931\u8d25");
                }
                this.setFileLock(occupyInfo, currentUserId, currentIp, this.getReferResourceDesc(occupyInfo.getReferResourceIds()));
            } else {
                this.setFileLock(occupyInfo, currentUserId, currentIp, this.getReferResourceDesc(occupyInfo.getReferResourceIds()));
            }
        }
        return ApiResponse.success();
    }

    private Map<String, String> getReferResourceDesc(List<String> referIds) {
        HashMap referIdNameMap = Maps.newHashMapWithExpectedSize((int)5);
        if (HussarUtils.isNotEmpty(referIds)) {
            for (String id : referIds) {
                try {
                    PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
                    referIdNameMap.put(id, HussarUtils.isNotEmpty((Object)pageInfo.getDesc()) ? pageInfo.getDesc() : pageInfo.getName());
                }
                catch (Exception e) {
                    LOGGER.error(id + "\u83b7\u53d6\u5173\u8054\u8d44\u6e90\u540d\u79f0\u5931\u8d25," + e.getMessage());
                    referIdNameMap.put(id, "id");
                }
            }
        }
        return referIdNameMap;
    }

    @Override
    public void setFileLock(FileResourceOccupyInfo occupyInfo, Long currentUserId, String currentIp, Map<String, String> referIdNameMap) {
        FileLockCacheInfo currentIdCacheSave = new FileLockCacheInfo();
        currentIdCacheSave.setResourceId(occupyInfo.getResourceId());
        currentIdCacheSave.setResourceName(occupyInfo.getReourceName());
        currentIdCacheSave.setLockOccupyFlag(true);
        currentIdCacheSave.setOccupyUserId(currentUserId);
        currentIdCacheSave.setOccupyUserName(BaseSecurityUtil.getUser().getUserName());
        currentIdCacheSave.setOccupyUserIp(currentIp);
        currentIdCacheSave.setAssociatedFlag(false);
        currentIdCacheSave.setReferResourceIds(occupyInfo.getReferResourceIds());
        LOGGER.info("\u5f53\u524d\u8d44\u6e90:{},\u4fdd\u5b58\u8d44\u6e90\u9501\u5360\u7528:{}", (Object)occupyInfo.getResourceId(), (Object)JSON.toJSONString((Object)currentIdCacheSave));
        HussarCacheUtil.put((String)CACHE_NAME_OCCUPY, (Object)occupyInfo.getResourceId(), (Object)currentIdCacheSave, (long)this.formDesignProperties.getExpiryDate());
        if (HussarUtils.isNotEmpty(occupyInfo.getReferResourceIds())) {
            for (String id : occupyInfo.getReferResourceIds()) {
                FileLockCacheInfo linkIdCacheSave = new FileLockCacheInfo();
                linkIdCacheSave.setResourceId(id);
                linkIdCacheSave.setResourceName(referIdNameMap.get(id));
                linkIdCacheSave.setLockOccupyFlag(true);
                linkIdCacheSave.setOccupyUserId(currentUserId);
                linkIdCacheSave.setOccupyUserName(BaseSecurityUtil.getUser().getUserName());
                linkIdCacheSave.setOccupyUserIp(currentIp);
                linkIdCacheSave.setAssociatedFlag(true);
                linkIdCacheSave.setAssociatedWithId(occupyInfo.getResourceId());
                LOGGER.info("\u5f53\u524d\u8d44\u6e90:{},\u4fdd\u5b58\u5173\u8054\u8d44\u6e90\u9501\u5360\u7528:{}", (Object)occupyInfo.getResourceId(), (Object)JSON.toJSONString((Object)linkIdCacheSave));
                HussarCacheUtil.put((String)CACHE_NAME_OCCUPY, (Object)id, (Object)linkIdCacheSave, (long)this.formDesignProperties.getExpiryDate());
            }
        }
    }

    private void fillOccupyInfoByFile(FileResourceOccupyInfo occupyInfo) {
        Set<Object> referIds;
        String currentResourceName;
        block7: {
            currentResourceName = null;
            referIds = Sets.newLinkedHashSetWithExpectedSize((int)5);
            try {
                if (occupyInfo.getResourceType().contains("Page")) {
                    PageInfo pageInfo = (PageInfo)this.pageInfoService.get(occupyInfo.getResourceId());
                    currentResourceName = pageInfo.getDesc();
                    referIds = this.getReferResourceIdsForPage(pageInfo);
                    break block7;
                }
                if ("DataModel".equals(occupyInfo.getResourceType())) {
                    DataCellInfo dataCellInfo = (DataCellInfo)((Object)this.dataCellInfoService.get(occupyInfo.getResourceId()));
                    currentResourceName = dataCellInfo.getDesc();
                    break block7;
                }
                if ("Workflow".equals(occupyInfo.getResourceType())) {
                    WorkflowInfo workflowInfo = (WorkflowInfo)((Object)this.workflowService.get(occupyInfo.getResourceId()));
                    currentResourceName = HussarUtils.isNotEmpty((Object)workflowInfo.getDesc()) ? workflowInfo.getDesc() : workflowInfo.getName();
                    referIds = this.getReferResourceIdsForworkflowInfo(workflowInfo);
                    break block7;
                }
                if (occupyInfo.getResourceType().contains("Script")) {
                    PageInfo extendScriptInfo = (PageInfo)this.pageInfoService.get(occupyInfo.getResourceId());
                    currentResourceName = extendScriptInfo.getDesc();
                    break block7;
                }
                LOGGER.error("\u672a\u77e5\u8d44\u6e90\u7c7b\u578b:{}", (Object)occupyInfo.getResourceType());
                throw new BaseException("\u672a\u77e5\u8d44\u6e90\u7c7b\u578b");
            }
            catch (Exception e) {
                LOGGER.error("{},\u83b7\u53d6\u8d44\u6e90\u5931\u8d25,{}", (Object)occupyInfo.getResourceId(), (Object)e.getMessage());
                throw new BaseException("\u83b7\u53d6\u8d44\u6e90\u5931\u8d25\uff1a" + occupyInfo.getResourceId());
            }
        }
        if (HussarUtils.isNotEmpty((Object)referIds)) {
            referIds.remove(occupyInfo.getResourceId());
        }
        occupyInfo.setReourceName(currentResourceName);
        occupyInfo.setReferResourceIds(new ArrayList<Object>(referIds));
    }

    private List<String> getReferResourceIdsFordataCellInfo(DataCellInfo dataCellInfo) {
        ArrayList referIds = Lists.newArrayListWithCapacity((int)5);
        JSONObject jsonObject = JSON.parseObject((String)dataCellInfo.getData());
        JSONArray translates = jsonObject.getJSONArray("translate");
        if (ToolUtil.isNotEmpty((Object)translates)) {
            for (Object object : translates) {
                JSONObject translate = (JSONObject)object;
                if (!ToolUtil.isNotEmpty((Object)translate.getJSONArray("dataModelCondition")) || translate.getString("sourceId").equals(dataCellInfo.getId())) continue;
                referIds.add(translate.getString("sourceId"));
            }
        }
        return referIds;
    }

    private Set<String> getReferResourceIdsForworkflowInfo(WorkflowInfo workflowInfo) {
        LinkedHashSet referIds = Sets.newLinkedHashSetWithExpectedSize((int)5);
        JSONObject jsonObject = JSON.parseObject((String)workflowInfo.getData());
        if (HussarUtils.isEmpty((Object)jsonObject.get((Object)"references"))) {
            return referIds;
        }
        Object o = jsonObject.get((Object)"references");
        if (HussarUtils.isEmpty((Object)o)) {
            return referIds;
        }
        List references = JSON.parseArray((String)JSON.toJSONString((Object)o), PageRefer.class);
        for (PageRefer reference : references) {
            List referValuePathList = reference.getReferValuePath();
            if (!HussarUtils.isNotEmpty((Object)referValuePathList) || ((String)referValuePathList.get(0)).contains(".")) continue;
            referIds.add(referValuePathList.get(0));
        }
        return referIds;
    }

    private Set<String> getReferResourceIdsForPage(PageInfo pageInfo) {
        LinkedHashSet referIds = Sets.newLinkedHashSetWithExpectedSize((int)5);
        JSONObject jsonObject = JSON.parseObject((String)pageInfo.getData());
        if (HussarUtils.isEmpty((Object)jsonObject.get((Object)"references"))) {
            return referIds;
        }
        Object o = jsonObject.get((Object)"references");
        if (HussarUtils.isEmpty((Object)o)) {
            return referIds;
        }
        List references = JSON.parseArray((String)JSON.toJSONString((Object)o), PageRefer.class);
        for (PageRefer reference : references) {
            List referValuePathList = reference.getReferValuePath();
            if (!HussarUtils.isNotEmpty((Object)referValuePathList) || ((String)referValuePathList.get(0)).contains(".")) continue;
            referIds.add(referValuePathList.get(0));
        }
        return referIds;
    }

    @Override
    public ApiResponse<Boolean> manuallyCloseLock(String resourceId) {
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        String currentIp = IpUtils.getIp();
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.equals((Object)currentUserId, (Object)currentIdCache.getOccupyUserId()) && currentIp.equals(currentIdCache.getOccupyUserIp()) && !currentIdCache.isAssociatedFlag()) {
            LOGGER.info("\u5f53\u524d\u8d44\u6e90\uff1a{},\u88ab\u91ca\u653e", (Object)resourceId);
            HussarCacheUtil.evict((String)CACHE_NAME_OCCUPY, (Object)resourceId);
            if (HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) {
                for (String id : currentIdCache.getReferResourceIds()) {
                    FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                    if (!HussarUtils.isNotEmpty((Object)associatedIdCache) || !HussarUtils.equals((Object)currentUserId, (Object)associatedIdCache.getOccupyUserId()) || !currentIp.equals(associatedIdCache.getOccupyUserIp())) continue;
                    LOGGER.info("\u5f53\u524d\u8d44\u6e90\uff1a{},\u5173\u8054\u8d44\u6e90:{}\u88ab\u91ca\u653e", (Object)resourceId, (Object)id);
                    HussarCacheUtil.evict((String)CACHE_NAME_OCCUPY, (Object)id);
                }
            }
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<String>> delayLock(List<String> ids) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)securityUser)) {
            return ApiResponse.success(new ArrayList());
        }
        Long currentUserId = securityUser.getId();
        String currentIp = IpUtils.getIp();
        ArrayList occupyIds = Lists.newArrayListWithCapacity((int)5);
        for (String id : ids) {
            FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
            if (HussarUtils.isEmpty((Object)currentIdCache)) continue;
            if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.equals((Object)currentUserId, (Object)currentIdCache.getOccupyUserId()) && currentIp.equals(currentIdCache.getOccupyUserIp())) {
                HussarCacheUtil.put((String)CACHE_NAME_OCCUPY, (Object)id, (Object)currentIdCache, (long)this.formDesignProperties.getExpiryDate());
                if (!HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) continue;
                for (String referId : currentIdCache.getReferResourceIds()) {
                    FileLockCacheInfo referIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)referId);
                    if (!HussarUtils.isNotEmpty((Object)referIdCache)) continue;
                    HussarCacheUtil.put((String)CACHE_NAME_OCCUPY, (Object)referId, (Object)referIdCache, (long)this.formDesignProperties.getExpiryDate());
                }
                continue;
            }
            LOGGER.error("id={}\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5360\u7528", (Object)id);
            occupyIds.add(id);
        }
        if (HussarUtils.isNotEmpty((Object)occupyIds)) {
            return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyIds, (String)"\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<FileLockInfoVo> checkLock(String resourceId, List<String> referIds) {
        FileLockInfoVo occupyInfoReturn = new FileLockInfoVo();
        occupyInfoReturn.setResourceId(resourceId);
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        String currentIp = IpUtils.getIp();
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        if (!(!HussarUtils.isNotEmpty((Object)currentIdCache) || HussarUtils.equals((Object)currentUserId, (Object)currentIdCache.getOccupyUserId()) && currentIp.equals(currentIdCache.getOccupyUserIp()))) {
            occupyInfoReturn.setOccupyFlag(true);
            occupyInfoReturn.setResourceName(currentIdCache.getResourceName());
            occupyInfoReturn.setOccupyUserId(currentIdCache.getOccupyUserId());
            occupyInfoReturn.setOccupyUserName(currentIdCache.getOccupyUserName());
            occupyInfoReturn.setOccupyUserIp(currentIdCache.getOccupyUserIp());
            return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.isNotEmpty(referIds)) {
            ArrayList referFileLockOccupys = Lists.newArrayListWithCapacity((int)5);
            for (String id : referIds) {
                FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                if (!HussarUtils.isNotEmpty((Object)associatedIdCache) || HussarUtils.equals((Object)currentUserId, (Object)associatedIdCache.getOccupyUserId()) && currentIp.equals(associatedIdCache.getOccupyUserIp())) continue;
                FileLockInfoVo referFileLockOccupy = this.getReferFileLockInfoVo(associatedIdCache);
                referFileLockOccupys.add(referFileLockOccupy);
            }
            if (HussarUtils.isNotEmpty((Object)referFileLockOccupys)) {
                occupyInfoReturn.setOccupyFlag(false);
                occupyInfoReturn.setReferResourceLockOccupys((List)referFileLockOccupys);
                return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5931\u8d25");
            }
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<FileLockInfoVo> checkLockByResourceType(String id, String type) {
        FileResourceOccupyInfo occupyInfo = new FileResourceOccupyInfo();
        occupyInfo.setResourceId(id);
        occupyInfo.setResourceType(type);
        this.fillOccupyInfoByFile(occupyInfo);
        return this.checkLock(occupyInfo.getResourceId(), occupyInfo.getReferResourceIds());
    }

    @Override
    public ApiResponse<FileLockInfoVo> operateResouceCheck(String resourceId, String type) {
        FileLockInfoVo occupyInfoReturn = new FileLockInfoVo();
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        String currentIp = IpUtils.getIp();
        if (type.equals("Module") || type.equals(MODULE_FOLDER)) {
            try {
                List<String> idList = this.fileTreeService.getFileTreeId(resourceId);
                if (HussarUtils.isEmpty(idList)) {
                    return ApiResponse.success();
                }
                ArrayList childResourceLockOccupys = Lists.newArrayListWithCapacity((int)5);
                for (String id : idList) {
                    FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                    if (!HussarUtils.isNotEmpty((Object)associatedIdCache) || HussarUtils.equals((Object)currentUserId, (Object)associatedIdCache.getOccupyUserId()) && currentIp.equals(associatedIdCache.getOccupyUserIp())) continue;
                    FileLockInfoVo referFileLockOccupy = this.getReferFileLockInfoVo(associatedIdCache);
                    childResourceLockOccupys.add(referFileLockOccupy);
                }
                if (HussarUtils.isEmpty((Object)childResourceLockOccupys)) {
                    return ApiResponse.success();
                }
                occupyInfoReturn.setOccupyFlag(false);
                occupyInfoReturn.setChildResourceLockOccupys((List)childResourceLockOccupys);
                return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5f53\u524d\u8d44\u6e90\u6216\u5173\u8054\u8d44\u6e90\u88ab\u5360\u7528\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            catch (Exception e) {
                if (e instanceof LcdpException && ((LcdpException)((Object)e)).getLcdpExceptionEnum().getCode() == LcdpExceptionEnum.NOT_FOUND_ID_FILE.getCode()) {
                    throw new BaseException(LcdpExceptionEnum.NOT_FOUND_ID_FILE.getMessage() + ":" + resourceId + ",\u8bf7\u5237\u65b0\u9875\u9762");
                }
                throw new BaseException("\u83b7\u53d6\u6587\u4ef6\u6811\u5f02\u5e38");
            }
        }
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        if (!(!HussarUtils.isNotEmpty((Object)currentIdCache) || HussarUtils.equals((Object)currentUserId, (Object)currentIdCache.getOccupyUserId()) && currentIp.equals(currentIdCache.getOccupyUserIp()))) {
            occupyInfoReturn.setOccupyFlag(true);
            occupyInfoReturn.setResourceName(currentIdCache.getResourceName());
            occupyInfoReturn.setOccupyUserId(currentIdCache.getOccupyUserId());
            occupyInfoReturn.setOccupyUserName(currentIdCache.getOccupyUserName());
            occupyInfoReturn.setOccupyUserIp(currentIdCache.getOccupyUserIp());
            return ApiResponse.fail((int)LcdpExceptionEnum.RESULTCODE_FAILURE_LOCK.getCode(), (Object)occupyInfoReturn, (String)"\u5f53\u524d\u8d44\u6e90\u6216\u5173\u8054\u8d44\u6e90\u88ab\u5360\u7528\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<FileLockInfoVo> getOccupyLockInfo(String resourceId) {
        FileLockInfoVo occupyInfoReturn = new FileLockInfoVo();
        occupyInfoReturn.setResourceId(resourceId);
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        if (HussarUtils.isEmpty((Object)currentIdCache)) {
            return ApiResponse.success();
        }
        occupyInfoReturn.setResourceName(currentIdCache.getResourceName());
        occupyInfoReturn.setLockOccupyFlag(currentIdCache.isLockOccupyFlag());
        occupyInfoReturn.setOccupyUserId(currentIdCache.getOccupyUserId());
        occupyInfoReturn.setOccupyUserName(currentIdCache.getOccupyUserName());
        occupyInfoReturn.setOccupyUserIp(currentIdCache.getOccupyUserIp());
        occupyInfoReturn.setAssociatedFlag(currentIdCache.isAssociatedFlag());
        occupyInfoReturn.setAssociatedWithId(currentIdCache.getAssociatedWithId());
        if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) {
            ArrayList referFileLockOccupys = Lists.newArrayListWithCapacity((int)5);
            for (String id : currentIdCache.getReferResourceIds()) {
                FileLockCacheInfo associatedIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)id);
                FileLockInfoVo referFileLockOccupy = this.getReferFileLockInfoVo(associatedIdCache);
                referFileLockOccupys.add(referFileLockOccupy);
            }
            occupyInfoReturn.setReferResourceLockOccupys((List)referFileLockOccupys);
        }
        return ApiResponse.success((Object)occupyInfoReturn);
    }

    @Override
    public void saveLockByFile(BaseFile file) {
        Map<String, String> referResourceDesc = this.getReferResourceDesc(file.getReferResourceIds());
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)file.getId());
        if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds()) && HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) {
            for (String id : currentIdCache.getReferResourceIds()) {
                HussarCacheUtil.evict((String)CACHE_NAME_OCCUPY, (Object)id);
            }
        }
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        String currentIp = IpUtils.getIp();
        FileResourceOccupyInfo occupyInfo = new FileResourceOccupyInfo();
        occupyInfo.setResourceId(file.getId());
        occupyInfo.setReourceName(file.getDesc());
        occupyInfo.setReferResourceIds(file.getReferResourceIds());
        this.setFileLock(occupyInfo, currentUserId, currentIp, referResourceDesc);
    }

    @Override
    public ApiResponse<FileLockInfoVo> closeOccupyLockForceByResourceType(String resourceId, String type) {
        if (type.equals("Module") || type.equals(MODULE_FOLDER)) {
            try {
                List<String> idList = this.fileTreeService.getFileTreeId(resourceId);
                if (HussarUtils.isEmpty(idList)) {
                    return ApiResponse.success();
                }
                for (String id : idList) {
                    this.closeOccupyLockForce(id);
                }
            }
            catch (Exception e) {
                throw new BaseException("\u83b7\u53d6\u6587\u4ef6\u6811\u5f02\u5e38");
            }
        } else {
            this.closeOccupyLockForce(resourceId);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<FileLockInfoVo> closeOccupyLockForce(String resourceId) {
        FileLockCacheInfo currentIdCache = (FileLockCacheInfo)HussarCacheUtil.get((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        if (HussarUtils.isNotEmpty((Object)currentIdCache) && HussarUtils.isNotEmpty(currentIdCache.getReferResourceIds())) {
            for (String id : currentIdCache.getReferResourceIds()) {
                HussarCacheUtil.evict((String)CACHE_NAME_OCCUPY, (Object)id);
            }
        }
        HussarCacheUtil.evict((String)CACHE_NAME_OCCUPY, (Object)resourceId);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Long> getExpiryDate() {
        return ApiResponse.success((Object)this.formDesignProperties.getExpiryDate(), (String)"");
    }

    @NotNull
    private FileLockInfoVo getReferFileLockInfoVo(FileLockCacheInfo associatedIdCache) {
        FileLockInfoVo referFileLockOccupy = new FileLockInfoVo();
        referFileLockOccupy.setResourceId(associatedIdCache.getResourceId());
        referFileLockOccupy.setResourceName(associatedIdCache.getResourceName());
        referFileLockOccupy.setLockOccupyFlag(associatedIdCache.isLockOccupyFlag());
        referFileLockOccupy.setOccupyUserId(associatedIdCache.getOccupyUserId());
        referFileLockOccupy.setOccupyUserName(associatedIdCache.getOccupyUserName());
        referFileLockOccupy.setOccupyUserIp(associatedIdCache.getOccupyUserIp());
        referFileLockOccupy.setOccupyFlag(true);
        referFileLockOccupy.setAssociatedFlag(associatedIdCache.isAssociatedFlag());
        referFileLockOccupy.setAssociatedWithId(associatedIdCache.getAssociatedWithId());
        return referFileLockOccupy;
    }
}

