/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.CustomComponentGroupInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CustomComponentGroupInfoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="CustomComponentGroupInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class CustomComponentGroupInfoServiceImpl
implements CustomComponentGroupInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private FormDesignProperties speedCodeProperties;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void create(CustomComponentGroupInfo customComponentGroupInfo) throws LcdpException, IOException {
        String parentPath;
        File mateFile;
        if (customComponentGroupInfo.getReferences() == null) {
            customComponentGroupInfo.setReferences(new JSONObject());
        }
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        this.iterator(file, jsonObjects, customComponentGroupInfo.getCategory());
        String libName = "";
        if (jsonObjects.size() != 0) {
            libName = this.getCurrFileInfo(jsonObjects).getString("libName");
        }
        if (FileUtils.exists((File)(mateFile = new File(this.relativeToAbsolute((parentPath = libName + File.separator + customComponentGroupInfo.getCategory()) + File.separator + customComponentGroupInfo.getName() + ".meta", rootPath))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, mateFile.getAbsolutePath());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentGroupInfo), (String)"UTF-8", (boolean)false);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.customComponents", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateFileMeta(CustomComponentGroupInfo customComponentGroupInfo) throws IOException, LcdpException {
        String parentPath;
        File mateFile;
        if (customComponentGroupInfo.getReferences() == null) {
            customComponentGroupInfo.setReferences(new JSONObject());
        }
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        this.iterator(file, jsonObjects, customComponentGroupInfo.getCategory());
        String libName = "";
        if (jsonObjects.size() != 0) {
            libName = this.getCurrFileInfo(jsonObjects).getString("libName");
        }
        if (!FileUtils.exists((File)(mateFile = new File(this.relativeToAbsolute((parentPath = libName + File.separator + customComponentGroupInfo.getCategory()) + File.separator + customComponentGroupInfo.getName() + ".meta", rootPath))))) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, customComponentGroupInfo.getName());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentGroupInfo), (String)"UTF-8");
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.customComponents", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void delete(String name) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath));
        ArrayList<JSONObject> categoryJsonObjects = new ArrayList<JSONObject>();
        this.iterator(file, categoryJsonObjects, name);
        String cover = "";
        String category = "";
        if (categoryJsonObjects.size() != 0) {
            category = this.getCurrFileInfo(categoryJsonObjects).getString("category");
            cover = this.getCurrFileInfo(categoryJsonObjects).getString("cover");
        }
        ArrayList<JSONObject> groupJsonObjects = new ArrayList<JSONObject>();
        this.iterator(file, groupJsonObjects, category);
        String libName = "";
        if (groupJsonObjects.size() != 0) {
            libName = this.getCurrFileInfo(groupJsonObjects).getString("libName");
        }
        String parentPath = libName + File.separator + category;
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + name + ".meta", rootPath));
        try {
            FileUtils.forceDelete((File)mateFile);
            if (!"".equals(cover)) {
                this.delCover(cover);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, mateFile.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6.customComponents", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath();
        FormDesignResponse response = FileUtils.upload((MultipartFile)file, (String)fileSavePath);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u7ec4\u4ef6\u56fe\u7247\uff1a%s", file.getOriginalFilename()), Collections.singletonList(fileSavePath));
        return response;
    }

    @Override
    public void delCover(String fileName) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath) + File.separator + fileName);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, file.getAbsolutePath());
            }
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u5c01\u9762\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    @Override
    public ResponseEntity<byte[]> getFile(String fileName) throws IOException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath();
        File file = new File(fileSavePath + File.separator + fileName);
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        MediaType mime = ext.equals("jpg") || ext.equals("JPG") ? MediaType.IMAGE_JPEG : (ext.equals("png") || ext.equals("PNG") ? MediaType.IMAGE_PNG : MediaType.IMAGE_JPEG);
        if (FileUtils.exists((File)file) && !FileUtils.isDirectory((File)file)) {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return ResponseEntity.ok().contentType(mime).body((Object)bytes);
        }
        return null;
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    public void iterator(File file, List<JSONObject> currFileInfo, String name) {
        File[] files;
        if (FileUtils.isDirectory((File)file) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)file)))) {
            for (File file1 : files) {
                String filepath = file1.getPath();
                if (this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath().equals(filepath)) continue;
                if (FileUtils.isDirectory((File)file1)) {
                    this.iterator(file1, currFileInfo, name);
                    continue;
                }
                File mataFile = new File(file1.getAbsolutePath());
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"));
                    if (!name.equals(jsonObject.getString("name"))) continue;
                    currFileInfo.add(jsonObject);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JSONObject getCurrFileInfo(List<JSONObject> jsonObjects) {
        JSONObject jsonObject = null;
        Iterator<JSONObject> iterator = jsonObjects.iterator();
        while (iterator.hasNext()) {
            JSONObject currFileInfo;
            jsonObject = currFileInfo = iterator.next();
        }
        return jsonObject;
    }
}

