/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.model.WebProSetInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WebProSetInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="WebProSetInfoServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class WebProSetInfoServiceDBImpl
implements WebProSetInfoService {
    private final FormDesignProperties speedCodeProperties;
    private final PathStrategyService pathStrategy;
    private static final String FILE_PATH = File.separator + "setting" + File.separator + "webProSetInfo.json";
    private static final Long FILE_ID = 942797525239472128L;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;

    public WebProSetInfoServiceDBImpl(FormDesignProperties speedCodeProperties, PathStrategyService pathStrategy) {
        this.speedCodeProperties = speedCodeProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public WebProSetInfo get() throws IOException {
        return this.getWebProSetInfo();
    }

    @Override
    public void save(WebProSetInfo webProSetInfo) throws IOException {
        this.writeWebProSetInfoMapToDB(webProSetInfo);
    }

    private WebProSetInfo getWebProSetInfo() throws IOException {
        SysMidFileInfo sysMidFileInfo = this.sysMidFileInfoService.getByFileId(FILE_ID);
        if (HussarUtils.isNotEmpty((Object)sysMidFileInfo)) {
            String webProSetInfoJSON = sysMidFileInfo.getMidFileInfoData();
            return (WebProSetInfo)JSON.parseObject((String)webProSetInfoJSON, (TypeReference)new TypeReference<WebProSetInfo>(){}, (Feature[])new Feature[0]);
        }
        return new WebProSetInfo();
    }

    private void writeWebProSetInfoMapToDB(WebProSetInfo webProSetInfo) throws IOException {
        String webProSetInfoMapDTOJSON = JSON.toJSONString((Object)webProSetInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.writeWebProSetInfo(webProSetInfoMapDTOJSON);
    }

    private void writeWebProSetInfo(String fileContent) {
        this.writeWebProSetStringToDB(fileContent, FILE_PATH);
        VfgModeTool.pushToRemote((String)"\u63d0\u4ea4\u4ee3\u7801\uff1a.project-store/setting", Collections.singletonList(FILE_PATH));
    }

    private void writeWebProSetStringToDB(String content, String filePath) {
        SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
        sysMidFileInfo.setMidFileInfoId(FILE_ID);
        sysMidFileInfo.setMidFileInfoPath(filePath);
        sysMidFileInfo.setMidFileInfoData(content);
        this.sysMidFileInfoService.saveOrUpdateMore(sysMidFileInfo);
    }
}

