/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.dbimpl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.component.constant.CheckInfoEnum;
import com.jxdinfo.hussar.formdesign.component.model.CheckInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelPageManifest;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ModelPageTemplateUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.ModelPageTemplate;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class PageTemplateInfoServiceDBImpl
implements PageTemplateInfoService {
    @Resource
    private PrefixEntry prefixEntry;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;
    @Resource
    private PathStrategyService pathStrategy;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private OssService ossService;
    private final List<String> functionTypeRange = Arrays.asList("BASE", "MASTER_SLAVE", "FLOW", "FLOW_MASTER_SLAVE", "TASK", "TASK_MASTER_SLAVE");
    private final List<String> pageTypeRange = Arrays.asList("WebPage", "UniPage", "WebAndUni");
    private final List<String> flowTypeRange = Arrays.asList("FLOW", "FLOW_MASTER_SLAVE", "TASK", "TASK_MASTER_SLAVE");
    private final List<String> templateTypeRange = Arrays.asList("formPage", "listPage", "mobileFormPage", "mobileListPage");

    @Override
    public void create(PageTemplateInfo pageTemplateInfo) throws LcdpException, IOException {
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", ""));
        String absolutePath = mateFile.getPath();
        if (this.sysMidFileInfoService.checkExist(absolutePath)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, mateFile.getPath());
        }
        SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
        sysMidFileInfo.setMidFileInfoPath(absolutePath);
        sysMidFileInfo.setMidFileInfoData(JSON.toJSONString((Object)pageTemplateInfo));
        sysMidFileInfo.setPageType(pageTemplateInfo.getPageType());
        sysMidFileInfo.setMidFileInfoType(pageTemplateInfo.getFileType());
        this.sysMidFileInfoService.saveMore(sysMidFileInfo);
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateFileMeta(PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", ""));
        String absolutePath = mateFile.getPath();
        if (!this.sysMidFileInfoService.checkExist(absolutePath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, pageTemplateInfo.getName());
        }
        this.sysMidFileInfoService.update(absolutePath, JSON.toJSONString((Object)pageTemplateInfo));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void delete(PageTemplateInfo pageTemplateInfo) throws LcdpException {
        String parentPath = pageTemplateInfo.getPageType() + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", ""));
        String absolutePath = mateFile.getPath();
        this.sysMidFileInfoService.removeByPath(absolutePath);
        String cover = pageTemplateInfo.getCover();
        if (!"".equals(cover)) {
            this.delCover(cover);
        }
        this.sysQuoteRelationService.deleteQuoteRelationByReferResid(pageTemplateInfo.getName());
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        FormDesignResponse response = new FormDesignResponse();
        String fileName = file.getOriginalFilename();
        String path = File.separator + "cover" + File.separator + fileName;
        try {
            SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
            sysMidFileInfo.setMidFileInfoPath(path);
            sysMidFileInfo.setMidFileInfoData(Base64.getEncoder().encodeToString(file.getBytes()));
            sysMidFileInfo.setPageType("cover");
            sysMidFileInfo.setMidFileInfoType("cover");
            this.sysMidFileInfoService.saveMore(sysMidFileInfo);
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6a21\u677f\u5c01\u9762\u56fe\u7247\uff1a%s", file.getOriginalFilename()), Collections.singletonList(fileSavePath));
        response.setData((Object)fileName);
        return response;
    }

    @Override
    public void delCover(String fileName) throws LcdpException {
        String absolutePath = File.separator + "cover" + File.separator + fileName;
        if (this.sysMidFileInfoService.checkExist(absolutePath)) {
            this.sysMidFileInfoService.removeByPath(absolutePath);
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u5c01\u9762\uff1a%s", fileName), Collections.singletonList(absolutePath));
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    @Override
    public ResponseEntity<byte[]> getCover(String fileName) throws IOException, LcdpException {
        String absolutePath = File.separator + "cover" + File.separator + fileName;
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        MediaType mime = ext.equals("jpg") || ext.equals("JPG") ? MediaType.IMAGE_JPEG : (ext.equals("png") || ext.equals("PNG") ? MediaType.IMAGE_PNG : MediaType.IMAGE_JPEG);
        if (this.sysMidFileInfoService.checkExist(absolutePath)) {
            SysMidFileInfo sysMidFileInfo = this.sysMidFileInfoService.getByPath(absolutePath);
            byte[] bytes = new byte[]{};
            if (HussarUtils.isNotEmpty((Object)sysMidFileInfo)) {
                String fileContent = sysMidFileInfo.getMidFileInfoData();
                bytes = Base64.getDecoder().decode(fileContent);
            }
            return ResponseEntity.ok().contentType(mime).body((Object)bytes);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public ApiResponse<String> uploadTemplate(String functionType, String pageType, MultipartFile zipFile) throws IOException {
        String fileId;
        Path zipPath;
        Path tempDir;
        block100: {
            Throwable throwable;
            if (StringUtils.isBlank((CharSequence)functionType) || StringUtils.isBlank((CharSequence)pageType)) {
                return ApiResponse.fail((String)"\u529f\u80fd\u7c7b\u578b\u548c\u9875\u9762\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
            zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
            try {
                throwable = null;
                try (InputStream is = zipFile.getInputStream();){
                    Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            throwable = null;
            try (ZipFile zip = new ZipFile(zipPath.toFile());){
                Throwable throwable3;
                InputStream manifestStream;
                block97: {
                    ApiResponse apiResponse;
                    block98: {
                        block99: {
                            ZipEntry manifestEntry = zip.getEntry("manifest.json");
                            if (manifestEntry == null) {
                                ApiResponse apiResponse2 = ApiResponse.fail((String)"\u538b\u7f29\u5305\u7f3a\u5c11manifest\u6587\u4ef6");
                                return apiResponse2;
                            }
                            manifestStream = zip.getInputStream(manifestEntry);
                            throwable3 = null;
                            ObjectMapper mapper = new ObjectMapper();
                            JsonNode manifest = mapper.readTree(manifestStream);
                            String manifestFunction = manifest.get("functionType").asText();
                            String manifestPageType = manifest.get("pageType").asText();
                            if (functionType.equals(manifestFunction) && pageType.equals(manifestPageType)) break block97;
                            apiResponse = ApiResponse.fail((String)"\u53c2\u6570\u4e0e\u6a21\u677f\u63cf\u8ff0\u4e0d\u5339\u914d");
                            if (manifestStream == null) break block98;
                            if (throwable3 == null) break block99;
                            try {
                                manifestStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            break block98;
                        }
                        manifestStream.close();
                    }
                    return apiResponse;
                }
                try {
                    if (manifestStream != null) {
                        if (throwable3 != null) {
                            try {
                                manifestStream.close();
                            }
                            catch (Throwable mapper) {
                                throwable3.addSuppressed(mapper);
                            }
                        } else {
                            manifestStream.close();
                        }
                    }
                    break block100;
                    catch (Throwable mapper) {
                        try {
                            throwable3 = mapper;
                            throw mapper;
                        }
                        catch (Throwable throwable5) {
                            if (manifestStream != null) {
                                if (throwable3 != null) {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable3.addSuppressed(throwable6);
                                    }
                                } else {
                                    manifestStream.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
                catch (IOException e) {
                    throw new IOException(e);
                }
            }
            catch (Throwable manifestEntry) {
                throwable = manifestEntry;
                throw manifestEntry;
            }
        }
        try {
            ApiResponse<CheckResult<PageTemplateInductsInfo>> resultApiResponse = this.checkTemplate(zipFile);
            if (HussarUtils.isEmpty(((CheckResult)resultApiResponse.getData()).getData())) {
                return ApiResponse.fail((String)("\u6587\u4ef6\u6709\u8bef\uff1a" + ((CheckResult)resultApiResponse.getData()).getCheckInfos().get(0).getInfos().get(0).getMsg()));
            }
            fileId = ((PageTemplateInductsInfo)((CheckResult)resultApiResponse.getData()).getData()).getId();
            if (HussarUtils.isEmpty((Object)fileId)) {
                return ApiResponse.fail((String)"\u4e0a\u4f20\u5931\u8d25");
            }
        }
        catch (IOException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        Path targetPath = Paths.get(tempDir.toString(), functionType, pageType, fileId);
        Files.createDirectories(targetPath, new FileAttribute[0]);
        try (ZipFile zip = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path entryPath = targetPath.resolve(entry.getName());
                if (!entryPath.normalize().startsWith(targetPath)) {
                    throw new SecurityException("\u975e\u6cd5\u6587\u4ef6\u8def\u5f84");
                }
                if (entry.isDirectory()) continue;
                InputStream is = zip.getInputStream(entry);
                Object object = null;
                try {
                    Files.copy(is, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is == null) continue;
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        String appId = this.prefixEntry.getPrefix();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ArrayList<SysMidFileInfo> sysMidFileInfoList = new ArrayList<SysMidFileInfo>();
        try (Stream<Path> paths = Files.walk(targetPath, new FileVisitOption[0]);){
            List jsonFiles = paths.filter(p -> p.toString().endsWith(".json")).collect(Collectors.toList());
            for (Path jsonFile : jsonFiles) {
                byte[] fileContent = Files.readAllBytes(jsonFile);
                JSONObject jsonObject = JSONObject.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                jsonObject.put("identity", (Object)fileId);
                SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
                sysMidFileInfo.setMidFileId(fileId.toString());
                String modelPageTemplatePath = FileUtil.posixPath((String[])new String[]{"modelPageTemplate", functionType, pageType, fileId});
                sysMidFileInfo.setMidFileInfoPath(modelPageTemplatePath);
                sysMidFileInfo.setMidFileInfoName(jsonFile.getFileName().toString());
                sysMidFileInfo.setMidFileInfoData(Base64.getEncoder().encodeToString(JSON.toJSONString((Object)jsonObject).getBytes()));
                sysMidFileInfo.setPageType(pageType);
                sysMidFileInfo.setMidFileInfoType("modelPageTemplate");
                if ("manifest.json".equals(jsonFile.getFileName().toString())) {
                    sysMidFileInfo.setMetaFlag("1");
                } else {
                    sysMidFileInfo.setMetaFlag("0");
                }
                sysMidFileInfo.setAppId(appId);
                sysMidFileInfo.setTenantCode(tenantCode);
                sysMidFileInfoList.add(sysMidFileInfo);
            }
        }
        if (HussarUtils.isNotEmpty(sysMidFileInfoList)) {
            this.sysMidFileInfoService.saveBatch(sysMidFileInfoList);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<ModelPageTemplate>> getTemplate(String functionType, String pageType) throws IOException {
        String modelPageTemplatePath = FileUtil.posixPath((String[])new String[]{functionType, pageType});
        List sysMidFileInfos = this.sysMidFileInfoService.listLikePath(modelPageTemplatePath);
        if (HussarUtils.isEmpty((Object)sysMidFileInfos)) {
            return ApiResponse.success(new ArrayList());
        }
        ArrayList<ModelPageManifest> modelPageManifests = new ArrayList<ModelPageManifest>();
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            String midFileInfoData;
            if (!HussarUtils.equals((Object)"1", (Object)sysMidFileInfo.getMetaFlag()) || HussarUtils.isEmpty((Object)(midFileInfoData = sysMidFileInfo.getMidFileInfoData()))) continue;
            ModelPageManifest manifestData = (ModelPageManifest)JSONObject.parseObject((String)new String(Base64.getDecoder().decode(midFileInfoData), StandardCharsets.UTF_8), ModelPageManifest.class);
            modelPageManifests.add(manifestData);
        }
        ArrayList<ModelPageTemplate> modelPageTemplateList = new ArrayList<ModelPageTemplate>();
        for (ModelPageManifest manifest : modelPageManifests) {
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
            ModelPageTemplate modelPageTemplate = new ModelPageTemplate();
            for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
                if (!"0".equals(sysMidFileInfo.getMetaFlag()) || !String.valueOf(manifest.getIdentity()).equals(sysMidFileInfo.getMidFileId())) continue;
                JSONObject jsonObject = JSON.parseObject((String)new String(Base64.getDecoder().decode(sysMidFileInfo.getMidFileInfoData()), StandardCharsets.UTF_8));
                if (HussarUtils.isNotEmpty((Object)jsonObject.getString("templateType")) && this.templateTypeRange.contains(jsonObject.getString("templateType"))) {
                    jsonObjectList.add(jsonObject);
                    continue;
                }
                if (!sysMidFileInfo.getMidFileInfoName().toLowerCase().contains("slave")) continue;
                modelPageTemplate.setEditTableTemplates(jsonObject);
            }
            if (this.flowTypeRange.contains(functionType)) {
                org.springframework.core.io.Resource[] bpmResources = SpringContextHolder.getApplicationContext().getResources("classpath*:/template/bpmTemplate.json");
                JSONObject jsonObject = JSON.parseObject((String)IOUtils.toString((InputStream)bpmResources[0].getInputStream(), (Charset)StandardCharsets.UTF_8));
                modelPageTemplate.setBpmTemplates(jsonObject);
            }
            modelPageTemplate.setAttributes(jsonObjectList);
            modelPageTemplate.setTemplateName(manifest.getTemplateName());
            modelPageTemplate.setIdentity(String.valueOf(manifest.getIdentity()));
            modelPageTemplateList.add(modelPageTemplate);
        }
        return ApiResponse.success(modelPageTemplateList);
    }

    @Override
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkTemplate(MultipartFile zipFile) throws IOException {
        CheckResult<PageTemplateInductsInfo> checkResult = new CheckResult<PageTemplateInductsInfo>();
        CheckInfo completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.fail(), -2);
        if (HussarUtils.isEmpty((Object)zipFile) || HussarUtils.isEmpty((Object)zipFile.getOriginalFilename())) {
            completeCheck.addInfos("\u6587\u4ef6\u4e3a\u7a7a", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        Path tempDir = Files.createTempDirectory("template_upload_", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try (InputStream is = zipFile.getInputStream();){
            Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            completeCheck.addInfos("\u6587\u4ef6\u5904\u7406\u5931\u8d25", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        ModelPageTemplateUtil.validateDirectory(zipPath, checkResult);
        ModelPageTemplateUtil.deleteTempFile(tempDir);
        if (checkResult.getResult() == -1) {
            return ApiResponse.success(checkResult);
        }
        Long zipFileId = (Long)this.ossService.backgroundUpload(zipFile).getData();
        completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        PageTemplateInductsInfo pageTemplateInductsInfo = new PageTemplateInductsInfo();
        pageTemplateInductsInfo.setId(zipFileId.toString());
        checkResult.addCheckInfos(completeCheck);
        checkResult.setData(pageTemplateInductsInfo);
        return ApiResponse.success(checkResult);
    }

    @Override
    public ApiResponse<String> importTemplate(Long fileId) throws IOException {
        String pageType;
        String functionType;
        Object manifestEntry2;
        Throwable throwable;
        String storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
        MultipartFile zipFile = this.getMultipartFile(fileId);
        Path tempDir = Files.createTempDirectory("template_upload_", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try {
            throwable = null;
            try (InputStream is = zipFile.getInputStream();){
                Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        throwable = null;
        try (ZipFile zip = new ZipFile(zipPath.toFile());){
            manifestEntry2 = zip.getEntry("manifest.json");
            if (manifestEntry2 == null) {
                ApiResponse apiResponse = ApiResponse.fail((String)"\u538b\u7f29\u5305\u7f3a\u5c11manifest\u6587\u4ef6");
                return apiResponse;
            }
            try (InputStream manifestStream = zip.getInputStream((ZipEntry)manifestEntry2);){
                ObjectMapper mapper = new ObjectMapper();
                JsonNode manifest = mapper.readTree(manifestStream);
                functionType = manifest.get("functionType").asText();
                pageType = manifest.get("pageType").asText();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable manifestEntry2) {
            throwable = manifestEntry2;
            throw manifestEntry2;
        }
        Path targetPath = Paths.get(storagePath, functionType, pageType, fileId.toString());
        Files.createDirectories(targetPath, new FileAttribute[0]);
        ZipFile zip = new ZipFile(zipPath.toFile());
        manifestEntry2 = null;
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path entryPath = targetPath.resolve(entry.getName());
                if (!entryPath.normalize().startsWith(targetPath)) {
                    throw new SecurityException("\u975e\u6cd5\u6587\u4ef6\u8def\u5f84");
                }
                if (entry.isDirectory()) continue;
                InputStream is = zip.getInputStream(entry);
                Object object = null;
                try {
                    Files.copy(is, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable3) {
                    object = throwable3;
                    throw throwable3;
                }
                finally {
                    if (is == null) continue;
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object).addSuppressed(throwable4);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Throwable entries) {
            manifestEntry2 = entries;
            throw entries;
        }
        finally {
            if (zip != null) {
                if (manifestEntry2 != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable entries) {
                        ((Throwable)manifestEntry2).addSuppressed(entries);
                    }
                } else {
                    zip.close();
                }
            }
        }
        String appId = this.prefixEntry.getPrefix();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ArrayList<SysMidFileInfo> sysMidFileInfoList = new ArrayList<SysMidFileInfo>();
        try (Stream<Path> paths = Files.walk(targetPath, new FileVisitOption[0]);){
            List jsonFiles = paths.filter(p -> p.toString().endsWith(".json")).collect(Collectors.toList());
            for (Path jsonFile : jsonFiles) {
                byte[] fileContent = Files.readAllBytes(jsonFile);
                JSONObject jsonObject = JSONObject.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                jsonObject.put("identity", (Object)fileId);
                SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
                sysMidFileInfo.setMidFileId(fileId.toString());
                String modelPageTemplatePath = FileUtil.posixPath((String[])new String[]{"modelPageTemplate", functionType, pageType, String.valueOf(fileId)});
                sysMidFileInfo.setMidFileInfoPath(modelPageTemplatePath);
                sysMidFileInfo.setMidFileInfoName(jsonFile.getFileName().toString());
                sysMidFileInfo.setMidFileInfoData(Base64.getEncoder().encodeToString(JSON.toJSONString((Object)jsonObject).getBytes()));
                sysMidFileInfo.setPageType(pageType);
                sysMidFileInfo.setMidFileInfoType("modelPageTemplate");
                if ("manifest.json".equals(jsonFile.getFileName().toString())) {
                    sysMidFileInfo.setMetaFlag("1");
                } else {
                    sysMidFileInfo.setMetaFlag("0");
                }
                sysMidFileInfo.setAppId(appId);
                sysMidFileInfo.setTenantCode(tenantCode);
                sysMidFileInfoList.add(sysMidFileInfo);
            }
        }
        if (HussarUtils.isNotEmpty(sysMidFileInfoList)) {
            this.sysMidFileInfoService.saveBatch(sysMidFileInfoList);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> editTemplateName(String functionType, String pageType, String identity, String templateName) {
        String modelPageTemplate = FileUtil.posixPath((String[])new String[]{identity});
        List sysMidFileInfos = this.sysMidFileInfoService.listLikePath(modelPageTemplate);
        if (HussarUtils.isEmpty((Object)sysMidFileInfos)) {
            return ApiResponse.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6587\u4ef6");
        }
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            String midFileInfoData;
            if (!HussarUtils.equals((Object)"1", (Object)sysMidFileInfo.getMetaFlag()) || HussarUtils.isEmpty((Object)(midFileInfoData = sysMidFileInfo.getMidFileInfoData()))) continue;
            ModelPageManifest manifestData = (ModelPageManifest)JSONObject.parseObject((String)new String(Base64.getDecoder().decode(midFileInfoData), StandardCharsets.UTF_8), ModelPageManifest.class);
            manifestData.setTemplateName(templateName);
            sysMidFileInfo.setMidFileInfoData(Base64.getEncoder().encodeToString(JSON.toJSONString((Object)manifestData).getBytes()));
            this.sysMidFileInfoService.saveOrUpdate((Object)sysMidFileInfo);
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @Override
    public ApiResponse<String> deleteTemplate(String functionType, String pageType, String identity) throws IOException {
        String modelPageTemplate = FileUtil.posixPath((String[])new String[]{identity});
        List sysMidFileInfos = this.sysMidFileInfoService.listLikePath(modelPageTemplate);
        if (HussarUtils.isEmpty((Object)sysMidFileInfos)) {
            return ApiResponse.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6587\u4ef6");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            ids.add(sysMidFileInfo.getMidFileInfoId());
        }
        this.sysMidFileInfoService.removeBatchByIds(ids);
        return ApiResponse.success();
    }

    public MultipartFile getMultipartFile(Long ossFileId) {
        try {
            AttachmentManagerModel model = this.ossService.getModelById(ossFileId);
            String attachmentName = model.getAttachmentName();
            ApiResponse download = this.ossService.backgroundDownload(ossFileId);
            byte[] data = (byte[])download.getData();
            return new MockMultipartFile(attachmentName, data);
        }
        catch (Exception var10) {
            throw new BaseException((Throwable)var10);
        }
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    @Override
    public FormDesignResponse<Map<String, List<ModelPageManifest>>> listModelPages(String pageType) {
        String modelPageTemplate = FileUtil.posixPath((String[])new String[]{"modelPageTemplate"});
        HashMap res = new HashMap();
        ArrayList<ModelPageManifest> modelPageManifests = new ArrayList<ModelPageManifest>();
        List sysMidFileInfos = this.sysMidFileInfoService.listLikePath(modelPageTemplate);
        if (HussarUtils.isEmpty((Object)sysMidFileInfos)) {
            return FormDesignResponse.success(new HashMap());
        }
        for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
            String midFileInfoData;
            if (!HussarUtils.equals((Object)"1", (Object)sysMidFileInfo.getMetaFlag()) || HussarUtils.isEmpty((Object)(midFileInfoData = sysMidFileInfo.getMidFileInfoData()))) continue;
            ModelPageManifest manifestData = (ModelPageManifest)JSONObject.parseObject((String)new String(Base64.getDecoder().decode(midFileInfoData), StandardCharsets.UTF_8), ModelPageManifest.class);
            modelPageManifests.add(manifestData);
        }
        Map<String, List<ModelPageManifest>> functionTypeGroup = modelPageManifests.stream().filter(modelPageManifest -> modelPageManifest.getPageType().equals(pageType)).collect(Collectors.groupingBy(ModelPageManifest::getFunctionType));
        return FormDesignResponse.success(functionTypeGroup);
    }

    @Override
    public ResponseEntity<byte[]> downModelPages(List<ModelPageManifest> manifests) {
        Path tempTargetDirectory;
        Path tempDirectory;
        if (HussarUtils.isEmpty(manifests)) {
            return null;
        }
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SysMidFileInfo.class);
        if (manifests.isEmpty()) {
            return null;
        }
        lambdaQueryWrapper.or(wrapper -> {
            for (ModelPageManifest manifest : manifests) {
                String modelPageTemplate = FileUtil.posixPath((String[])new String[]{"modelPageTemplate", manifest.getFunctionType(), manifest.getPageType(), String.valueOf(manifest.getIdentity())});
                ((LambdaQueryWrapper)wrapper.or()).like(SysMidFileInfo::getMidFileInfoPath, (Object)modelPageTemplate);
            }
        });
        List templates = this.sysMidFileInfoService.list((Wrapper)lambdaQueryWrapper);
        Map<String, List<SysMidFileInfo>> pathFiles = this.groupByPathPrefix(templates);
        try {
            tempDirectory = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
            tempTargetDirectory = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new HussarException();
        }
        Path finalTempDirectory = tempDirectory;
        ArrayList<String> zips = new ArrayList<String>();
        pathFiles.forEach((prefix, files) -> {
            String zipFileName = "";
            String pre = FileUtil.posixPath((String[])new String[]{finalTempDirectory.toAbsolutePath().toString(), prefix});
            String target = FileUtil.posixPath((String[])new String[]{tempTargetDirectory.toAbsolutePath().toString(), prefix});
            try {
                Files.createDirectories(Paths.get(target, new String[0]), new FileAttribute[0]);
                for (SysMidFileInfo file : files) {
                    if (HussarUtils.equals((Object)"1", (Object)file.getMetaFlag())) {
                        zipFileName = String.valueOf(((Map)JSONObject.parseObject((String)new String(Base64.getDecoder().decode(file.getMidFileInfoData()), StandardCharsets.UTF_8), Map.class)).get("templateName"));
                    }
                    String path = FileUtil.posixPath((String[])new String[]{pre, file.getMidFileInfoName()});
                    FileUtils.writeStringToFile((File)new File(path), (String)new String(Base64.getDecoder().decode(file.getMidFileInfoData()), StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8);
                }
                String zipPath = String.format("%s.zip", zipFileName);
                ZipUtil.zip(pre, FileUtil.posixPath((String[])new String[]{target, zipPath}));
                zips.add(FileUtil.posixPath((String[])new String[]{target, zipPath}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        try {
            ResponseEntity<byte[]> responseEntity = ZipUtil.downloadZipFiles(zips);
            ModelPageTemplateUtil.deleteTempFile(tempDirectory);
            ModelPageTemplateUtil.deleteTempFile(tempTargetDirectory);
            return responseEntity;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkModelPages(MultipartFile zipFile) throws IOException {
        Throwable throwable;
        CheckResult<PageTemplateInductsInfo> checkResult = new CheckResult<PageTemplateInductsInfo>();
        CheckInfo completeCheck = new CheckInfo(zipFile.getOriginalFilename() + CheckInfoEnum.COMPLETE.fail(), -2);
        if (HussarUtils.isEmpty((Object)zipFile) || HussarUtils.isEmpty((Object)zipFile.getOriginalFilename())) {
            completeCheck.addInfos("\u6587\u4ef6\u4e3a\u7a7a", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        Path tempDir = Files.createTempDirectory("template_upload_", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try {
            throwable = null;
            try (InputStream is = zipFile.getInputStream();){
                Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            completeCheck.addInfos(zipFile.getOriginalFilename() + "\u6587\u4ef6\u5904\u7406\u5931\u8d25", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        throwable = null;
        try (ZipFile zip = new ZipFile(zipPath.toFile(), Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path targetPath = tempDir.resolve(zipPath.getFileName() + entry.getName());
                if (Files.exists(targetPath, new LinkOption[0])) {
                    throw new IOException("Duplicate file: " + targetPath);
                }
                if (entry.isDirectory() || entry.getName().endsWith("/")) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                InputStream is = zip.getInputStream(entry);
                Throwable throwable3 = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
                    Throwable throwable4 = null;
                    try {
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = is.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable4 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable6) {
                                throwable4.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable7) {
                    throwable3 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (is == null) continue;
                    if (throwable3 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable8) {
                            throwable3.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Throwable entries) {
            throwable = entries;
            throw entries;
        }
        Files.deleteIfExists(zipPath);
        try {
            throwable = null;
            try (Stream<Path> pathStream = Files.walk(tempDir, new FileVisitOption[0]);){
                ApiResponse apiResponse;
                List jsonFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".zip")).filter(path -> !path.equals(tempDir)).collect(Collectors.toList());
                if (HussarUtils.isEmpty(jsonFiles)) {
                    ModelPageTemplateUtil.deleteTempFile(tempDir);
                    apiResponse = this.checkTemplate(zipFile);
                    return apiResponse;
                }
                for (Path dir : jsonFiles) {
                    ModelPageTemplateUtil.validateDirectory(dir, checkResult);
                }
                if (checkResult.getResult() == -1) {
                    apiResponse = ApiResponse.success(checkResult);
                    return apiResponse;
                }
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            completeCheck.addInfos(e.getMessage(), -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        ModelPageTemplateUtil.deleteTempFile(tempDir);
        Long zipFileId = (Long)this.ossService.backgroundUpload(zipFile).getData();
        completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        PageTemplateInductsInfo pageTemplateInductsInfo = new PageTemplateInductsInfo();
        pageTemplateInductsInfo.setId(zipFileId.toString());
        checkResult.addCheckInfos(completeCheck);
        checkResult.setData(pageTemplateInductsInfo);
        return ApiResponse.success(checkResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ApiResponse<String> importModelPages(Long fileId) throws IOException {
        ApiResponse<String> entry;
        Throwable throwable;
        MultipartFile zipFile = this.getMultipartFile(fileId);
        Path tempDir = Files.createTempDirectory("template_upload_", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getName()));
        try {
            throwable = null;
            try (InputStream is = zipFile.getInputStream();){
                Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
        }
        throwable = null;
        try (ZipFile zip = new ZipFile(zipPath.toFile(), Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                Path targetPath = tempDir.resolve(zipPath.getFileName() + entry.getName());
                if (Files.exists(targetPath, new LinkOption[0])) {
                    throw new IOException("Duplicate file: " + targetPath);
                }
                if (entry.isDirectory() || entry.getName().endsWith("/")) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = zip.getInputStream((ZipEntry)entry);
                Throwable throwable3 = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
                    Throwable throwable4 = null;
                    try {
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = inputStream.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable4 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable6) {
                                throwable4.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable7) {
                    throwable3 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable3 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable8) {
                            throwable3.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (Throwable entries) {
            throwable = entries;
            throw entries;
        }
        Files.deleteIfExists(zipPath);
        try {
            throwable = null;
            try (Stream<Path> pathStream = Files.walk(tempDir, new FileVisitOption[0]);){
                List jsonFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".zip")).filter(path -> !path.equals(tempDir)).collect(Collectors.toList());
                if (HussarUtils.isEmpty(jsonFiles)) {
                    ModelPageTemplateUtil.deleteTempFile(tempDir);
                    entry = this.importTemplate(fileId);
                    return entry;
                }
                ArrayList<Object> fileIds = new ArrayList<Object>();
                for (Path path2 : jsonFiles) {
                    MockMultipartFile multipartFile = new MockMultipartFile(path2.getFileName().toString().replace("/", ""), path2.getFileName().toString().replace("/", ""), null, Files.readAllBytes(path2));
                    fileIds.add(this.ossService.backgroundUpload((MultipartFile)multipartFile).getData());
                }
                Iterator<Object> iterator = fileIds.iterator();
                while (iterator.hasNext()) {
                    Long l = (Long)iterator.next();
                    this.importTemplate(l);
                }
                return ApiResponse.success();
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private Map<String, List<SysMidFileInfo>> groupByPathPrefix(List<SysMidFileInfo> objList) {
        HashMap<String, List<SysMidFileInfo>> result = new HashMap<String, List<SysMidFileInfo>>();
        for (SysMidFileInfo obj : objList) {
            String path = obj.getMidFileInfoPath();
            String prefix = PageTemplateInfoServiceDBImpl.extractPathPrefix(path);
            result.computeIfAbsent(prefix, k -> new ArrayList()).add(obj);
        }
        return result;
    }

    private static String extractPathPrefix(String path) {
        int lastSlashIndex = path.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return path.substring(lastSlashIndex + 1);
        }
        return "";
    }
}

