/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.dao.SysMidFileCodeMapper;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysMidFileCodeServiceImpl
extends HussarServiceImpl<SysMidFileCodeMapper, SysMidFileCode>
implements SysMidFileCodeService {
    @Resource
    private PrefixEntry prefixEntry;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysMidFileCodeServiceImpl.class);

    @HussarTransactional
    public void saveFile(BaseFile baseFile) {
        if (baseFile instanceof ModuleInfo) {
            this.save((BaseEntity)FileDataBaseHelper.convertToMetaFile(baseFile));
        } else {
            this.save((BaseEntity)FileDataBaseHelper.covertToMainFile(baseFile));
            this.save((BaseEntity)FileDataBaseHelper.convertToMetaFile(baseFile));
        }
    }

    public SysMidFileCode getMainFile(String fileId) {
        return (SysMidFileCode)((SysMidFileCodeMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)fileId)).eq(SysMidFileCode::getMetaFlag, (Object)"0")).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public SysMidFileCode getMetaFile(String fileId) {
        return (SysMidFileCode)((SysMidFileCodeMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)fileId)).eq(SysMidFileCode::getMetaFlag, (Object)"1")).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public List<SysMidFileCode> getAllFiles() {
        return this.list((Wrapper)this.lambdaQueryWrapper().and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    @HussarTransactional
    public void updateFile(BaseFile baseFile) {
        SysMidFileCode metaFile;
        SysMidFileCode mainFile = this.getMainFile(baseFile.getId());
        if (HussarUtils.isNotEmpty((Object)mainFile)) {
            mainFile.setName(FileDataBaseHelper.getName(baseFile));
            mainFile.setData(FileDataBaseHelper.getMainFileData(baseFile));
            this.updateById((BaseEntity)mainFile);
        }
        if (HussarUtils.isNotEmpty((Object)(metaFile = this.getMetaFile(baseFile.getId())))) {
            metaFile.setName(FileDataBaseHelper.getName(baseFile));
            metaFile.setData(FileDataBaseHelper.getMetaFileData(baseFile));
            this.updateById((BaseEntity)metaFile);
        }
    }

    public void updateMetaFileInfo(SysMidFileCode metaFileInfo) {
        ((SysMidFileCodeMapper)this.baseMapper).updateById((Object)metaFileInfo);
    }

    public void getSubResourceIds(String parentId, List<SysMidFileCode> results) {
        List childResourceList = this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)parentId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (HussarUtils.isNotEmpty((Object)childResourceList)) {
            List childResourceIds = childResourceList.stream().map(SysMidFileCode::getFileId).map(String::valueOf).collect(Collectors.toList());
            results.addAll(childResourceList);
            for (String childId : childResourceIds) {
                this.getSubResourceIds(childId, results);
            }
        }
    }

    public String getModelPath(String fileId) {
        StringBuilder modelPath = new StringBuilder();
        ArrayDeque<String> pathStack = new ArrayDeque<String>();
        String currentFileId = fileId;
        while (true) {
            SysMidFileCode metaFile = this.getMetaFile(currentFileId);
            pathStack.push(metaFile.getName());
            String parentId = metaFile.getParentId();
            if (HussarUtils.equals((Object)"#", (Object)parentId) || HussarUtils.equals((Object)"common_model", (Object)parentId)) break;
            currentFileId = parentId;
        }
        while (pathStack.size() > 1) {
            modelPath.append("/").append((String)pathStack.pop());
        }
        return modelPath.toString();
    }

    public void deleteModuleResource(String resourceId) {
        List sysMidFileCodes;
        ArrayList<SysMidFileCode> subResource = new ArrayList<SysMidFileCode>();
        this.getSubResourceIds(resourceId, subResource);
        if (HussarUtils.isNotEmpty(subResource)) {
            for (SysMidFileCode sysMidFileCode : subResource) {
                sysMidFileCode.setDelFlag("1");
            }
            this.updateBatchById(subResource);
        }
        if (HussarUtils.isNotEmpty((Object)(sysMidFileCodes = this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)resourceId)).eq(SysMidFileCode::getMetaFlag, (Object)"1"))))) {
            for (SysMidFileCode sysMidFileCode : sysMidFileCodes) {
                sysMidFileCode.setDelFlag("1");
            }
            this.updateBatchById(sysMidFileCodes);
        }
    }

    public void deleteFile(String fileId) {
        List sysMidFileCodes = this.list((Wrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)fileId));
        if (HussarUtils.isNotEmpty((Object)sysMidFileCodes)) {
            for (SysMidFileCode sysMidFileCode : sysMidFileCodes) {
                sysMidFileCode.setDelFlag("1");
            }
            this.updateBatchById(sysMidFileCodes);
        }
    }

    public List<SysMidFileCode> getChildFileByParentId(String parentId) {
        return this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)parentId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public boolean isLeaf(String fileId) {
        List<SysMidFileCode> childFiles = this.getChildFileByParentId(fileId);
        return HussarUtils.isEmpty(childFiles);
    }

    public SysMidFileCode getOneCondition(String parentId, String type, String name) {
        return (SysMidFileCode)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)parentId)).eq(SysMidFileCode::getName, (Object)type)).eq(SysMidFileCode::getType, (Object)name)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public void removeByPId(String pId) {
        SysMidFileCode sysMidFileCode = (SysMidFileCode)((SysMidFileCodeMapper)this.baseMapper).selectOne((Wrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)pId));
        if (ToolUtil.isNotEmpty((Object)sysMidFileCode)) {
            sysMidFileCode.setDelFlag("1");
            this.updateById((BaseEntity)sysMidFileCode);
        }
    }

    public void saveBatchMore(List<SysMidFileCode> sysMidFileCodeList) {
        String appId = null;
        String tenantCode = null;
        if (VfgModeTool.isModularization()) {
            appId = this.prefixEntry.getPrefix();
            tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        }
        for (SysMidFileCode sysMidFileCode : sysMidFileCodeList) {
            sysMidFileCode.setAppId(appId);
            sysMidFileCode.setTenantCode(tenantCode);
        }
        this.saveBatch(sysMidFileCodeList);
    }

    public List<SysMidFileCode> getByPId(String pId) {
        return this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)pId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public List<SysMidFileCode> getByFileId(String fileId) {
        return this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)fileId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public SysMidFileCode getNotMetaFile(String fileId) {
        return (SysMidFileCode)((SysMidFileCodeMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)fileId)).eq(SysMidFileCode::getMetaFlag, (Object)"0")).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public LambdaQueryWrapper<SysMidFileCode> lambdaQueryWrapper() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SysMidFileCode.class);
        if (VfgModeTool.isModularization()) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysMidFileCode::getAppId, (Object)this.prefixEntry.getPrefix())).eq(SysMidFileCode::getTenantCode, (Object)BaseSecurityUtil.getUser().getTenantCode());
        }
        return lambdaQueryWrapper;
    }
}

