/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileDataBaseCommonService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseFileDataBaseCommonServiceImpl<T extends BaseFile>
implements BaseFileDataBaseCommonService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFileDataBaseCommonService.class);
    @Autowired
    private SysMidFileCodeService sysMidFileCodeService;
    @Autowired
    private GodAxeModelService godAxeModelService;
    @Autowired
    private FileDataBaseHelper fileDataBaseHelper;

    @Override
    @HussarTransactional
    public void updateFileData(T baseFile) throws LcdpException {
        long startTime = System.currentTimeMillis();
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(baseFile.getId());
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(baseFile.getId());
        if (HussarUtils.isEmpty((Object)mainFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        boolean needRename = this.justRename((BaseFile)baseFile, (BaseFile)JSON.parseObject((String)metaFile.getData(), BaseFile.class));
        mainFile.setData(baseFile.getData());
        baseFile.setData(null);
        metaFile.setData(JSON.toJSONString(baseFile));
        if (needRename) {
            mainFile.setName(FileDataBaseHelper.getName(baseFile));
            metaFile.setName(FileDataBaseHelper.getName(baseFile));
        }
        this.sysMidFileCodeService.updateById((Object)mainFile);
        this.sysMidFileCodeService.updateById((Object)metaFile);
        long endTime = System.currentTimeMillis();
        LOGGER.info("CODE \u6570\u636e\u5e93\u5b58\u50a8 -> \u4fdd\u5b58\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
    }

    @Override
    public boolean justRename(BaseFile file, BaseFile metaFile) {
        boolean needRename;
        boolean bl = needRename = !HussarUtils.equals((Object)file.getName(), (Object)metaFile.getName());
        if (file instanceof WorkflowInfo) {
            WorkflowInfo workflowFile = (WorkflowInfo)file;
            WorkflowInfo workflowMetaFile = (WorkflowInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)metaFile), WorkflowInfo.class));
            boolean bl2 = needRename = !HussarUtils.equals((Object)workflowFile.geteName(), (Object)workflowMetaFile.geteName());
            if (needRename) {
                this.godAxeModelService.updateWorkflowProcessKey(workflowFile.geteName(), workflowMetaFile.geteName());
            }
            file.setVersion(metaFile.getVersion());
        }
        return needRename;
    }
}

