/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.helper;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.constant.FileConstant;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class FileDataBaseHelper {
    public static SysMidFileCode covertToMainFile(BaseFile baseFile) {
        SysMidFileCode mainFile = new SysMidFileCode();
        mainFile.setFileId(baseFile.getId());
        mainFile.setParentId(baseFile.getParentId());
        mainFile.setType(baseFile.getType());
        mainFile.setName(FileDataBaseHelper.getName(baseFile));
        mainFile.setMetaFlag("0");
        String mainFileData = HussarUtils.isEmpty((Object)baseFile.getData()) ? "" : baseFile.getData();
        mainFile.setData(mainFileData);
        if (VfgModeTool.isModularization()) {
            PrefixEntry prefixEntry = (PrefixEntry)SpringContextUtil.getBean(PrefixEntry.class);
            String appId = prefixEntry.getPrefix();
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            mainFile.setAppId(appId);
            mainFile.setTenantCode(tenantCode);
        }
        return mainFile;
    }

    public static SysMidFileCode convertToMetaFile(BaseFile baseFile) {
        SysMidFileCode metaFile = new SysMidFileCode();
        metaFile.setFileId(baseFile.getId());
        metaFile.setParentId(baseFile.getParentId());
        metaFile.setType(baseFile.getType());
        metaFile.setName(FileDataBaseHelper.getName(baseFile));
        metaFile.setMetaFlag("1");
        baseFile.setData(null);
        metaFile.setData(JSON.toJSONString((Object)baseFile));
        if (VfgModeTool.isModularization()) {
            PrefixEntry prefixEntry = (PrefixEntry)SpringContextUtil.getBean(PrefixEntry.class);
            String appId = prefixEntry.getPrefix();
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            metaFile.setAppId(appId);
            metaFile.setTenantCode(tenantCode);
        }
        return metaFile;
    }

    public static String getName(BaseFile baseFile) {
        if (baseFile instanceof WorkflowInfo) {
            return ((WorkflowInfo)baseFile).geteName();
        }
        return baseFile.getName();
    }

    public static String getMainFileData(BaseFile baseFile) {
        if (HussarUtils.isEmpty((Object)baseFile.getData())) {
            return "";
        }
        return baseFile.getData();
    }

    public static String getMetaFileData(BaseFile baseFile) {
        baseFile.setData(null);
        return JSON.toJSONString((Object)baseFile);
    }

    public String getFileName(SysMidFileCode childFile) {
        String name = childFile.getName();
        String fileSuffix = FileConstant.transFileSuffix((String)childFile.getType());
        String metaSuffix = HussarUtils.equals((Object)childFile.getMetaFlag(), (Object)"1") ? ".meta" : "";
        return name + fileSuffix + metaSuffix;
    }

    public static List<SysMidFileCode> getChildFiles(List<SysMidFileCode> allFiles, String parentId) {
        ArrayList<SysMidFileCode> childFiles = new ArrayList<SysMidFileCode>();
        if (HussarUtils.isNotEmpty(allFiles)) {
            return allFiles.stream().filter(file -> HussarUtils.equals((Object)file.getParentId(), (Object)parentId)).collect(Collectors.toList());
        }
        return childFiles;
    }

    public static boolean isMetaFile(SysMidFileCode file) {
        return HussarUtils.equals((Object)file.getMetaFlag(), (Object)"1");
    }
}

