/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggretionModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ParamPaserUtil;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="AggretionModuleInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class AggretionModuleInfoServiceImpl
extends BaseFileServiceImpl<ModuleInfo>
implements AggretionModuleInfoService {
    private static final Logger logger = LoggerFactory.getLogger(AggretionModuleInfoServiceImpl.class);
    @Autowired
    ModuleInfoService moduleInfoService;
    @Autowired
    AggretionModuleInfoService aggretionModuleInfoService;
    @Autowired
    IndexStorageLockService indexStorageLockService;
    @Autowired
    FileTreeService fileTreeService;
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired
    private PathStrategyService pathStrategy;

    @Override
    public FormDesignResponse<ModuleInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(id)).getErrorCode() != 200) {
            return sharedStorage;
        }
        List<String> idList = this.fileTreeService.getFileTreeId(id);
        for (String referResid : idList) {
            this.sysQuoteRelationService.deleteQuoteRelationByReferResid(referResid);
        }
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeDelete(id);
        return this.moduleInfoService.deleteDirectory(id);
    }

    @Override
    public FormDesignResponse<Map<String, Object>> copyDirectory(OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        String uuid = ToolUtil.get36UUID();
        HashMap<String, String> relationMap = new HashMap<String, String>();
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeCopy(operateFileVO.getId(), uuid, operateFileVO.getNewName(), operateFileVO.getParentId());
        this.aggretionModuleInfoService.copyDirectoryList(operateFileVO.getId(), operateFileVO.getParentId(), uuid, operateFileVO.getNewName(), operateFileVO.getNewDesc(), relationMap);
        for (Map.Entry entry : relationMap.entrySet()) {
            this.sysQuoteRelationService.copyQuoteRelation((String)entry.getKey(), (String)entry.getValue());
        }
        FormDesignResponse<List<JSONObject>> stringFormDesignResponse = this.fileTreeService.getFileTreeNew(uuid);
        if (!this.formDesignProperties.getScenes().isSharedStorage()) {
            JSONObject baseFile = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString(this.moduleInfoService.get(uuid)), JSONObject.class);
            List list = (List)stringFormDesignResponse.getData();
            list.add(baseFile);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("references", relationMap);
            map.put("fileTree", list);
            formDesignResponse.setData(map);
        }
        return formDesignResponse;
    }

    @Override
    public void moveDirectory(OperateFileVO operateFileVO) throws IOException, LcdpException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeMove(operateFileVO.getId(), operateFileVO.getNewName(), operateFileVO.getParentId());
        this.moduleInfoService.moveDirectory(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
    }

    @Override
    public void editDirectory(ModuleInfo moduleInfo) throws IOException, LcdpException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeEdit((BaseFile)moduleInfo);
        this.moduleInfoService.updateDirectory(moduleInfo);
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(parentId);
        if (ToolUtil.isNotEmpty((Object)pageInfo) && !"#".equals(pageInfo.getParentId())) {
            if (id.equals(pageInfo.getId())) {
                return true;
            }
            return this.copyCheck(id, pageInfo.getParentId());
        }
        return false;
    }

    @Override
    public void copyDirectoryList(String id, String parentId, String uuid, String newName, String newDesc, Map<String, String> relationMap) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isDirectory((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)to)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        to = newName != null && !newName.isEmpty() ? new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath)) : new File(this.relativeToAbsolute(parentPath + File.separator + from.getName(), rootPath));
        if (!FileUtils.exists((File)to)) {
            FileUtils.forceMkdir((File)to);
        }
        File metaTo = new File(to.getAbsolutePath() + ".meta");
        List<String> metaList = ParsingUtil.getFilePath(this.relativeToAbsolute(path, rootPath), ".meta");
        ArrayList<String> dataModelMetaName = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(metaList)) {
            metaList.forEach(meta -> {
                try {
                    JSONObject parseObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)new File((String)meta), (String)"UTF-8"));
                    String metaType = parseObject.getString("type");
                    if (ToolUtil.isNotEmpty((Object)metaType) && (HussarUtils.equals((Object)"DataModel", (Object)metaType) || HussarUtils.equals((Object)"JsScript", (Object)metaType) || HussarUtils.equals((Object)"CssScript", (Object)metaType) || HussarUtils.equals((Object)"VueScript", (Object)metaType) || HussarUtils.equals((Object)"MobileJsScript", (Object)metaType) || HussarUtils.equals((Object)"MobileCssScript", (Object)metaType) || HussarUtils.equals((Object)"MobileVueScript", (Object)metaType) || HussarUtils.equals((Object)"UniJsScript", (Object)metaType) || HussarUtils.equals((Object)"UniVueScript", (Object)metaType) || HussarUtils.equals((Object)"UniCssScript", (Object)metaType) || HussarUtils.equals((Object)"FrontScript", (Object)metaType) || HussarUtils.equals((Object)"CustomPage", (Object)metaType) || HussarUtils.equals((Object)"MobileFrontScript", (Object)metaType) || HussarUtils.equals((Object)"UniFrontScript", (Object)metaType) || HussarUtils.equals((Object)"UniCustomPage", (Object)metaType) || HussarUtils.equals((Object)"MobileCustomPage", (Object)metaType))) {
                        dataModelMetaName.add((String)meta);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        try {
            for (File file : FileUtils.listFiles((File)from)) {
                File toFile;
                String newFileContent;
                JSONObject parseObject;
                Object metaType;
                if (!FileUtils.isDirectory((File)file) && (ToolUtil.isNotEmpty((Object)(metaType = (parseObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"))).getString("type"))) && HussarUtils.equals((Object)"Workflow", (Object)metaType) || !file.getName().contains("."))) continue;
                boolean flag = false;
                if (ToolUtil.isNotEmpty(dataModelMetaName)) {
                    metaType = dataModelMetaName.iterator();
                    while (metaType.hasNext()) {
                        String metaName = (String)metaType.next();
                        if (!metaName.contains(file.getName())) continue;
                        flag = true;
                        break;
                    }
                }
                if (FileUtils.isDirectory((File)file)) {
                    this.copyFile(file, to, dataModelMetaName);
                } else if (!flag) {
                    FileUtils.copyFileToDirectory((File)file, (File)to, (boolean)false);
                }
                if (AppContextUtil.isExtension() || !FileUtils.isWpdFile((File)file) || !(newFileContent = FileUtils.readFileToString((File)(toFile = new File(this.relativeToAbsolute(file.getName(), to.getAbsolutePath()))), (String)"UTF-8")).contains("extendKey")) continue;
                newFileContent = ParamPaserUtil.replaceExtendKeys(newFileContent);
                FileUtils.writeStringToFile((File)toFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSON.parseObject((String)newFileContent)), (String)"UTF-8");
            }
            FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
        }
        File reRootMetaFile = new File(metaTo.getAbsolutePath());
        File reRootFile = new File(to.getAbsolutePath());
        if (FileUtils.exists((File)reRootMetaFile)) {
            File[] files;
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)reRootMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            jsonObject.put("id", (Object)uuid);
            if (newName != null) {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null) {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)reRootMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
            if (FileUtils.exists((File)reRootFile) && FileUtils.isDirectory((File)reRootFile) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)reRootFile)))) {
                int workFlowCount = 0;
                for (File file : files) {
                    this.iteratorFile(file, uuid, workFlowCount, relationMap);
                    ++workFlowCount;
                }
            }
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            formDesignResponse.setErrorCode(400);
            formDesignResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return formDesignResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !user.getId().equals(userId))) {
            formDesignResponse.setErrorCode(403);
            formDesignResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }

    String getDataPath(String id) throws LcdpException, IOException {
        return this.getMetaPath(id).replace(".meta", "");
    }

    private String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    private void copyFile(File file, File to, List<String> dataModelMetaName) throws IOException {
        if (FileUtils.isDirectory((File)file)) {
            File target = new File(to, file.getName());
            if (!FileUtils.exists((File)target)) {
                FileUtils.forceMkdir((File)target);
            }
            for (File source : FileUtils.listFiles((File)file)) {
                boolean flag = false;
                if (ToolUtil.isNotEmpty(dataModelMetaName)) {
                    for (String metaName : dataModelMetaName) {
                        if (!metaName.contains(source.getName())) continue;
                        flag = true;
                        break;
                    }
                }
                if (FileUtils.isDirectory((File)source)) {
                    this.copyFile(source, target, dataModelMetaName);
                    continue;
                }
                if (flag) continue;
                try {
                    JSONObject parseObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)source, (String)"UTF-8"));
                    String metaType = parseObject.getString("type");
                    if (ToolUtil.isNotEmpty((Object)metaType) && HussarUtils.equals((Object)"Workflow", (Object)metaType) || !source.getName().contains(".")) continue;
                    FileUtils.copyFileToDirectory((File)source, (File)target, (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void iteratorFile(File parentFile, String parentId, Integer workflowCount, Map<String, String> relationMap) throws LcdpException {
        if (FileUtils.exists((File)parentFile)) {
            File[] files;
            File metaFile = new File(this.addMeta(parentFile.getAbsolutePath()));
            if (FileUtils.exists((File)metaFile)) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
                    jsonObject.put("parentId", (Object)parentId);
                    if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)"isMenuSet"))) {
                        jsonObject.put("isMenuSet", (Object)false);
                    }
                    String id = ToolUtil.get36UUID();
                    if (FileUtils.isDirectory((File)parentFile)) {
                        parentId = id;
                    }
                    String oldId = (String)jsonObject.get((Object)"id");
                    relationMap.put(oldId, id);
                    jsonObject.put("id", (Object)id);
                    if ("Workflow".equals(jsonObject.get((Object)"type"))) {
                        jsonObject.put("version", (Object)"0");
                    }
                    FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
                    if (!parentFile.isDirectory()) {
                        String content = FileUtils.readFileToString((File)parentFile, (String)"UTF-8");
                        content = content.replaceAll(oldId, id);
                        FileUtils.writeStringToFile((File)parentFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSON.parseObject((String)content)), (String)"UTF-8");
                    }
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaFile.getAbsolutePath());
                }
            }
            if (FileUtils.isDirectory((File)parentFile) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)parentFile)))) {
                for (File file : files) {
                    this.iteratorFile(file, parentId, workflowCount, relationMap);
                    Integer n = workflowCount;
                    Integer n2 = workflowCount = Integer.valueOf(workflowCount + 1);
                }
            }
        }
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }
}

