/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.FileOperEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationWorkflowService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelCopyDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.model.SysQuoteRelation;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AggregationWorkflowServiceImpl")
public class AggregationWorkflowServiceImpl
implements AggregationWorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(AggregationWorkflowServiceImpl.class);
    @Autowired
    WorkflowService workflowService;
    @Autowired
    IndexStorageLockService indexStorageLockService;
    @Autowired
    FormDesignProperties formDesignProperties;
    @Autowired
    SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private FileLockManagerService lockManagerService;

    @Override
    public FormDesignResponse<WorkflowInfo> updateAllDataInfo(WorkflowInfo workflowInfo) throws IOException, LcdpException {
        ApiResponse<FileLockInfoVo> response = this.lockManagerService.checkLock(workflowInfo.getId(), workflowInfo.getReferResourceIds());
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (!response.isSuccess()) {
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData(response.getData());
            return formDesignResponse;
        }
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            this.disposeQuoteRelation(workflowInfo.getId(), workflowInfo.getData());
            this.workflowService.updateWorkFlowFile(workflowInfo);
        } else {
            this.workflowService.updateFileMeta(workflowInfo);
        }
        if (!FileOperEnum.UPDATE.getOperType().equals(workflowInfo.getOperType())) {
            this.lockManagerService.saveLockByFile(workflowInfo);
        }
        return formDesignResponse;
    }

    @Override
    public FormDesignResponse copyDataInfo(List<OperateFileVO> operateFileVOs) throws IOException, LcdpException {
        ArrayList<String> processKeys = new ArrayList<String>();
        ArrayList<ModelCopyDto> modelCopyDtoList = new ArrayList<ModelCopyDto>();
        for (OperateFileVO operateFileVO : operateFileVOs) {
            try {
                this.sysQuoteRelationService.copyQuoteRelation(operateFileVO.getId(), operateFileVO.getNewId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ModelCopyDto modelCopyDto = new ModelCopyDto();
            modelCopyDto.setId(operateFileVO.getId());
            modelCopyDto.setNewId(operateFileVO.getNewId());
            modelCopyDto.setNewName(operateFileVO.getNewName());
            modelCopyDto.setParentId(operateFileVO.getParentId());
            modelCopyDto.setCategory(operateFileVO.getCategory());
            modelCopyDto.setNewDesc(operateFileVO.getNewDesc());
            modelCopyDtoList.add(modelCopyDto);
            processKeys.add(operateFileVO.getNewDesc());
        }
        FormDesignResponse<Map> formDesignResponse = this.workflowService.checkProcessKey(processKeys);
        if (formDesignResponse.getErrorCode() == 10001) {
            return formDesignResponse;
        }
        List<String> newProcessKeys = this.workflowService.copyWorkFlow(modelCopyDtoList);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("processKey", newProcessKeys);
        FormDesignResponse response = new FormDesignResponse();
        response.setData(map);
        return response;
    }

    @Override
    public FormDesignResponse<WorkflowInfo> deleteDataInfo(String id, String identity, String organId, boolean forced, List<String> ids) throws IOException, LcdpException {
        Object sharedStorage;
        if (HussarUtils.hasEmpty((Object[])new Object[]{id, identity})) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(id)).getErrorCode() != 200) {
            return sharedStorage;
        }
        try {
            this.workflowService.deleteBpmFile(identity, organId, forced);
            this.sysQuoteRelationService.deleteQuoteRelationByReferResid(id);
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Workflow")).cascadeDelete(id);
            this.workflowService.delete(id);
            if (HussarUtils.isNotEmpty(ids)) {
                for (String item : ids) {
                    this.sysQuoteRelationService.deleteQuoteRelationByReferResid(item);
                    this.workflowService.delete(item);
                }
            }
        }
        catch (LcdpException e) {
            return FormDesignResponse.fail((Object)((Object)new WorkflowInfo()), (String)(e.getLcdpExceptionEnum().getMessage() + ": " + e.getDetail()));
        }
        catch (HussarException e) {
            return FormDesignResponse.fail((int)e.getExceptionCode(), null, (String)e.getMessage());
        }
        catch (Exception e) {
            return FormDesignResponse.fail((Object)((Object)new WorkflowInfo()), (String)e.getMessage());
        }
        return new FormDesignResponse();
    }

    @Override
    public void disposeQuoteRelation(String referResId, String data) {
        ArrayList<SysQuoteRelation> sysQuoteRelations = new ArrayList<SysQuoteRelation>();
        JSONObject parseObject = JSONObject.parseObject((String)data);
        JSONObject resObject = (JSONObject)parseObject.get((Object)"resReferencesIndex");
        HashMap resMap = new HashMap();
        for (Map.Entry entry : resObject.entrySet()) {
            resMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : resMap.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            obj.remove((Object)"id");
            SysQuoteRelation sysQuoteRelation = (SysQuoteRelation)JSONObject.toJavaObject((JSON)obj, SysQuoteRelation.class);
            sysQuoteRelations.add(sysQuoteRelation);
        }
        this.sysQuoteRelationService.deleteAndAddQuote(referResId, sysQuoteRelations);
    }

    @Override
    public void moveWorkFlow(String id, String parentId, String newName, String newDesc, String category) throws LcdpException, IOException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Workflow")).cascadeMove(id, newName, parentId);
        this.workflowService.moveWorkFlow(id, parentId, newName, newDesc, category);
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            formDesignResponse.setErrorCode(400);
            formDesignResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return formDesignResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !user.getId().equals(userId))) {
            formDesignResponse.setErrorCode(403);
            formDesignResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }
}

