/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.model;

import com.jxdinfo.hussar.formdesign.component.util.ComparableVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;

public class CompatibleVersions {
    private String rules;
    private List<String> versions;
    public static final String SCOPE = "scope";
    public static final String SELECTION = "selection";
    public static final String ALL = "all";

    public String getRules() {
        return this.rules;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public boolean check(String comparableVersion) {
        if (HussarUtils.isBlank((CharSequence)comparableVersion)) {
            return false;
        }
        if (HussarUtils.isBlank((CharSequence)this.rules)) {
            return false;
        }
        switch (this.rules) {
            case "all": {
                return true;
            }
            case "scope": {
                return this.scope(comparableVersion);
            }
            case "selection": {
                return this.selection(comparableVersion);
            }
        }
        return false;
    }

    private boolean scope(String comparableVersion) {
        if (HussarUtils.isEmpty(this.versions)) {
            return false;
        }
        String min = this.versions.get(0);
        if (HussarUtils.isBlank((CharSequence)min)) {
            return false;
        }
        int minSize = new ComparableVersion(comparableVersion).compareTo(new ComparableVersion(min));
        if (minSize < 0) {
            return false;
        }
        if (this.versions.size() == 1) {
            return true;
        }
        String max = this.versions.get(1);
        if (HussarUtils.isBlank((CharSequence)max)) {
            return true;
        }
        int maxSize = new ComparableVersion(comparableVersion).compareTo(new ComparableVersion(max));
        return maxSize <= 0;
    }

    private boolean selection(String comparableVersion) {
        if (HussarUtils.isEmpty(this.versions)) {
            return false;
        }
        for (String version : this.versions) {
            if (!version.equals(comparableVersion)) continue;
            return true;
        }
        return false;
    }
}

