/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.printTemplate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.printTemplate.service.PrintTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintGroupInfo;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintGroupInfoService;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class PrintTemplateServiceImpl
implements PrintTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(PrintTemplateServiceImpl.class);
    protected FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String ID_DELIMITER = "#";
    @Autowired
    PathStrategyService pathStrategyService;
    @Autowired(required=false)
    ISysTemplatePrintInfoService iSysTemplatePrintInfoService;
    @Autowired
    ISysTemplatePrintGroupInfoService iSysTemplatePrintGroupInfoService;

    @Override
    public void publishPrintTemplate(PublishCtx<CodeResult> publishCtx, String id) {
        ArrayList<Map> projectTemplatePrintInfos = new ArrayList<Map>();
        String groupId = "";
        if (HussarUtils.isNotEmpty((Object)publishCtx.getParams())) {
            Map printTemplate = (Map)publishCtx.getParams().get("printTemplate");
            if (ToolUtil.isNotEmpty((Object)printTemplate)) {
                List<SysTemplatePrintGroupInfo> sysTemplatePrintGroupInfos = this.processParentIds(id);
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = sysTemplatePrintGroupInfos.get(0);
                groupId = String.valueOf(sysTemplatePrintGroupInfo.getGroupId());
                this.iSysTemplatePrintGroupInfoService.processGroups((List)sysTemplatePrintGroupInfos);
            }
            if (ToolUtil.isNotEmpty((Object)printTemplate)) {
                for (Object key : printTemplate.keySet()) {
                    Map map = (Map)printTemplate.get(key);
                    map.put("templateId", key);
                    map.put("pageId", id);
                    projectTemplatePrintInfos.add(map);
                }
            }
        }
        List sysTemplatePrintInfoList = this.iSysTemplatePrintInfoService.getTemplateListByPageId(id);
        ArrayList<JSONObject> sysTemplatePrintInfos = new ArrayList<JSONObject>();
        if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
            for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                sysTemplatePrintInfos.add((JSONObject)JSONObject.toJSON((Object)sysTemplatePrintInfo));
            }
        }
        String rootPath = this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath();
        HashMap<String, Map> tempMapA = new HashMap<String, Map>();
        HashMap<String, Map> tempMapB = new HashMap<String, Map>();
        HashMap<String, Map> tempMapC = new HashMap<String, Map>();
        for (Map map : projectTemplatePrintInfos) {
            tempMapA.put(String.valueOf(map.get("templateId")), map);
        }
        for (Map map : sysTemplatePrintInfos) {
            tempMapB.put(String.valueOf(map.get("templateId")), map);
        }
        ArrayList<Long> removed = new ArrayList<Long>();
        for (Map obj : tempMapB.values()) {
            if (tempMapA.containsKey(String.valueOf(obj.get("templateId")))) continue;
            removed.add(Long.valueOf(String.valueOf(obj.get("templateId"))));
            tempMapC.put(String.valueOf(obj.get("templateId")), obj);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        PublishTemplateDto publishTemplateDto = new PublishTemplateDto();
        HashMap<String, byte[]> templateDatas = new HashMap<String, byte[]>();
        for (Map obj : tempMapA.values()) {
            if (tempMapC.containsKey(String.valueOf(obj.get("templateId")))) continue;
            File file = new File(FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}));
            try (FileInputStream fis = new FileInputStream(file);
                 ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
                int n;
                byte[] b = new byte[1024];
                while ((n = fis.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                byte[] data = bos.toByteArray();
                templateDatas.put(FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}), data);
                obj.put("data", data);
                obj.put("absolute", FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}));
                obj.put("fileName", file.getName());
                obj.put("groupId", groupId);
            }
            catch (IOException e) {
                logger.error("\u6a21\u677f\u6587\u4ef6\u8f6c\u5b57\u8282\u5931\u8d25{}", (Object)e.getMessage());
            }
            obj.put("relative", obj.get("templatePath"));
            arrayList.add(obj);
        }
        publishTemplateDto.setTemplateDatas(templateDatas);
        HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
        params.put("removed", removed);
        params.put("added", arrayList);
        publishTemplateDto.setParams(params);
        this.iSysTemplatePrintInfoService.processTemplates(publishTemplateDto);
    }

    public List<SysTemplatePrintGroupInfo> processParentIds(String id) {
        ArrayList<SysTemplatePrintGroupInfo> sysTemplatePrintGroupInfos = new ArrayList<SysTemplatePrintGroupInfo>();
        try {
            SysApplicationVo applicationVo;
            BaseFile pageInfo;
            do {
                ApiResponse groupByResource = this.iSysTemplatePrintGroupInfoService.getGroupByResourceId(id);
                pageInfo = null;
                pageInfo = this.fileMappingService.getPageInfoById(id);
                if (!HussarUtils.isNotEmpty((Object)pageInfo)) break;
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = new SysTemplatePrintGroupInfo();
                if (HussarUtils.isNotEmpty((Object)groupByResource.getData()) && HussarUtils.isNotEmpty((Object)((SysTemplatePrintGroupInfo)groupByResource.getData()).getGroupId())) {
                    sysTemplatePrintGroupInfo.setGroupId(((SysTemplatePrintGroupInfo)groupByResource.getData()).getGroupId());
                } else {
                    sysTemplatePrintGroupInfo.setGroupId(Long.valueOf(IdWorker.getId((Object)sysTemplatePrintGroupInfo)));
                }
                sysTemplatePrintGroupInfo.setGroupName(pageInfo.getDesc());
                sysTemplatePrintGroupInfo.setResourceId(pageInfo.getId());
                sysTemplatePrintGroupInfos.add(sysTemplatePrintGroupInfo);
            } while (!ID_DELIMITER.equals(id = pageInfo.getParentId()));
            if (HussarUtils.isNotEmpty((Object)(applicationVo = this.pathStrategyService.resourcePathService().projectAppName()))) {
                Long appId = applicationVo.getId();
                ApiResponse groupByResource = this.iSysTemplatePrintGroupInfoService.getGroupByResourceId(String.valueOf(appId));
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = new SysTemplatePrintGroupInfo();
                if (HussarUtils.isEmpty((Object)groupByResource.getData())) {
                    sysTemplatePrintGroupInfo.setGroupId(Long.valueOf(IdWorker.getId((Object)sysTemplatePrintGroupInfo)));
                } else {
                    sysTemplatePrintGroupInfo.setGroupId(((SysTemplatePrintGroupInfo)groupByResource.getData()).getGroupId());
                }
                sysTemplatePrintGroupInfo.setGroupName(applicationVo.getAppName());
                sysTemplatePrintGroupInfo.setResourceId(String.valueOf(applicationVo.getId()));
                sysTemplatePrintGroupInfos.add(sysTemplatePrintGroupInfo);
            }
            if (HussarUtils.isNotEmpty(sysTemplatePrintGroupInfos) && sysTemplatePrintGroupInfos.size() >= 2) {
                for (int i = 0; i < sysTemplatePrintGroupInfos.size() - 1; ++i) {
                    sysTemplatePrintGroupInfos.get(i).setParentId(sysTemplatePrintGroupInfos.get(i + 1).getGroupId());
                }
            }
            return sysTemplatePrintGroupInfos;
        }
        catch (LcdpException | IOException e) {
            throw new HussarException();
        }
    }

    @Override
    public Map<String, Object> uploadPrintTemplate(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputStream is = file.getInputStream();
        map.put("size", file.getSize());
        map.put("fileName", fileName);
        String templateId = String.valueOf(IdWorker.getId((Object)new SysTemplatePrintInfo()));
        String rootPath = this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath();
        String templatePath = FileUtil.posixPath((String[])new String[]{templateId, fileName});
        return this.saveFile(is, rootPath, templatePath, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printTemplateDownload(HttpServletResponse response, String templatePath, String fileName) throws IOException {
        try (InputStream inputStream = null;){
            if (ToolUtil.isEmpty((Object)templatePath)) {
                templatePath = "/printTemplate/templateDemo.zip";
                fileName = "templateDemo.zip";
                inputStream = this.getClass().getResourceAsStream(templatePath);
            } else {
                File file = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath(), templatePath}));
                if (!file.exists()) {
                    System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728: " + file.getPath());
                    return;
                }
                inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            if (inputStream != null) {
                int bytesRead;
                response.setContentType("multipart/form-data");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                byte[] buffer = new byte[1024];
                BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
                outputStream.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> saveFile(InputStream inputStream, String rootPath, String templatePath, Map<String, Object> map) {
        String uploadDir = FileUtil.posixPath((String[])new String[]{rootPath, templatePath});
        File uploadDirFile = new File(uploadDir);
        if (!uploadDirFile.getParentFile().exists()) {
            uploadDirFile.getParentFile().mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(FileUtil.posixPath((String[])new String[]{rootPath, templatePath}));){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            map.put("templatePath", templatePath);
            Map<String, Object> map2 = map;
            return map2;
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            return new HashMap<String, Object>();
        }
    }
}

