/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.printTemplate.service.dbimpl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.SysPrintTemplateStorage;
import com.jxdinfo.hussar.formdesign.printTemplate.service.ISysPrintTemplateStorageService;
import com.jxdinfo.hussar.formdesign.printTemplate.service.PrintTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintGroupInfo;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintGroupInfoService;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PrintTemplateServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class PrintTemplateServiceDBImpl
implements PrintTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(PrintTemplateServiceDBImpl.class);
    protected FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String ID_DELIMITER = "#";
    @Autowired
    PathStrategyService pathStrategyService;
    @Resource
    private ISysPrintTemplateStorageService printTemplateStorageService;
    @Autowired(required=false)
    ISysTemplatePrintInfoService iSysTemplatePrintInfoService;
    @Autowired
    ISysTemplatePrintGroupInfoService iSysTemplatePrintGroupInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishPrintTemplate(PublishCtx<CodeResult> publishCtx, String id) {
        Map printTemplate = (Map)publishCtx.getParams().get("printTemplate");
        ArrayList<Object> projectTemplatePrintInfos = new ArrayList<Object>();
        String groupId = "";
        if (ToolUtil.isNotEmpty((Object)printTemplate)) {
            List<SysTemplatePrintGroupInfo> sysTemplatePrintGroupInfos = this.processParentIds(id);
            SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = sysTemplatePrintGroupInfos.get(0);
            groupId = String.valueOf(sysTemplatePrintGroupInfo.getGroupId());
            this.iSysTemplatePrintGroupInfoService.processGroups((List)sysTemplatePrintGroupInfos);
        }
        if (ToolUtil.isNotEmpty((Object)printTemplate)) {
            for (String key : printTemplate.keySet()) {
                Map map = (Map)printTemplate.get(key);
                map.put("templateId", key);
                map.put("pageId", id);
                map.put("groupId", groupId);
                projectTemplatePrintInfos.add(map);
            }
        }
        List sysTemplatePrintInfoList = this.iSysTemplatePrintInfoService.getTemplateListByPageId(id);
        ArrayList<JSONObject> sysTemplatePrintInfos = new ArrayList<JSONObject>();
        if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
            for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                sysTemplatePrintInfos.add((JSONObject)JSONObject.toJSON((Object)sysTemplatePrintInfo));
            }
        }
        HashMap<String, Map> tempMapA = new HashMap<String, Map>();
        HashMap<String, Map> tempMapB = new HashMap<String, Map>();
        HashMap<String, Map> tempMapC = new HashMap<String, Map>();
        for (Map map : projectTemplatePrintInfos) {
            tempMapA.put(String.valueOf(map.get("templateId")), map);
        }
        for (Map map : sysTemplatePrintInfos) {
            tempMapB.put(String.valueOf(map.get("templateId")), map);
        }
        ArrayList<Long> removed = new ArrayList<Long>();
        for (Map obj : tempMapB.values()) {
            if (tempMapA.containsKey(String.valueOf(obj.get("templateId")))) continue;
            removed.add(Long.valueOf(String.valueOf(obj.get("templateId"))));
            tempMapC.put(String.valueOf(obj.get("templateId")), obj);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        PublishTemplateDto publishTemplateDto = new PublishTemplateDto();
        HashMap<String, byte[]> templateDatas = new HashMap<String, byte[]>();
        for (Map obj : tempMapA.values()) {
            if (tempMapC.containsKey(String.valueOf(obj.get("templateId")))) continue;
            String templatePath = String.valueOf(obj.get("templatePath"));
            InputStream fis = null;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
                SysPrintTemplateStorage printTemplateStorage = this.printTemplateStorageService.getByPath(templatePath);
                if (HussarUtils.isNotEmpty((Object)((Object)printTemplateStorage))) {
                    String fileContent = printTemplateStorage.getFileContent();
                    byte[] byteArray = Base64.getDecoder().decode(fileContent);
                    fis = new ByteArrayInputStream(byteArray);
                }
                byte[] b = new byte[1024];
                if (HussarUtils.isNotEmpty((Object)fis)) {
                    int n;
                    while ((n = fis.read(b)) != -1) {
                        bos.write(b, 0, n);
                    }
                }
                byte[] data = bos.toByteArray();
                templateDatas.put(templatePath, data);
                obj.put("data", data);
                obj.put("absolute", templatePath);
                obj.put("fileName", printTemplateStorage.getFileName());
            }
            catch (IOException e) {
                logger.error("\u6a21\u677f\u6587\u4ef6\u8f6c\u5b57\u8282\u5931\u8d25{}", (Object)e.getMessage());
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)fis)) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25");
                    }
                }
            }
            obj.put("relative", templatePath);
            arrayList.add(obj);
        }
        publishTemplateDto.setTemplateDatas(templateDatas);
        HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
        params.put("removed", removed);
        params.put("added", arrayList);
        publishTemplateDto.setParams(params);
        this.iSysTemplatePrintInfoService.processTemplates(publishTemplateDto);
    }

    private List<SysTemplatePrintGroupInfo> processParentIds(String id) {
        ArrayList<SysTemplatePrintGroupInfo> sysTemplatePrintGroupInfos = new ArrayList<SysTemplatePrintGroupInfo>();
        try {
            SysApplicationVo applicationVo;
            BaseFile pageInfo;
            do {
                ApiResponse groupByResource = this.iSysTemplatePrintGroupInfoService.getGroupByResourceId(id);
                pageInfo = null;
                pageInfo = this.fileMappingService.getPageInfoById(id);
                if (!HussarUtils.isNotEmpty((Object)pageInfo)) break;
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = new SysTemplatePrintGroupInfo();
                if (HussarUtils.isNotEmpty((Object)groupByResource.getData())) {
                    sysTemplatePrintGroupInfo.setGroupId(((SysTemplatePrintGroupInfo)groupByResource.getData()).getGroupId());
                } else {
                    sysTemplatePrintGroupInfo.setGroupId(Long.valueOf(IdWorker.getId((Object)sysTemplatePrintGroupInfo)));
                }
                sysTemplatePrintGroupInfo.setGroupName(pageInfo.getDesc());
                sysTemplatePrintGroupInfo.setResourceId(pageInfo.getId());
                sysTemplatePrintGroupInfos.add(sysTemplatePrintGroupInfo);
            } while (!ID_DELIMITER.equals(id = pageInfo.getParentId()));
            if (HussarUtils.isNotEmpty((Object)(applicationVo = this.pathStrategyService.resourcePathService().projectAppName()))) {
                Long appId = applicationVo.getId();
                ApiResponse groupByResource = this.iSysTemplatePrintGroupInfoService.getGroupByResourceId(String.valueOf(appId));
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = new SysTemplatePrintGroupInfo();
                if (HussarUtils.isEmpty((Object)groupByResource.getData())) {
                    sysTemplatePrintGroupInfo.setGroupId(Long.valueOf(IdWorker.getId((Object)sysTemplatePrintGroupInfo)));
                } else {
                    sysTemplatePrintGroupInfo.setGroupId(((SysTemplatePrintGroupInfo)groupByResource.getData()).getGroupId());
                }
                sysTemplatePrintGroupInfo.setGroupName(applicationVo.getAppName());
                sysTemplatePrintGroupInfo.setResourceId(String.valueOf(applicationVo.getId()));
                sysTemplatePrintGroupInfos.add(sysTemplatePrintGroupInfo);
            }
            if (HussarUtils.isNotEmpty(sysTemplatePrintGroupInfos) && sysTemplatePrintGroupInfos.size() >= 2) {
                for (int i = 0; i < sysTemplatePrintGroupInfos.size() - 1; ++i) {
                    sysTemplatePrintGroupInfos.get(i).setParentId(sysTemplatePrintGroupInfos.get(i + 1).getGroupId());
                }
            }
            return sysTemplatePrintGroupInfos;
        }
        catch (LcdpException | IOException e) {
            throw new HussarException();
        }
    }

    @Override
    public Map<String, Object> uploadPrintTemplate(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputStream is = file.getInputStream();
        map.put("size", file.getSize());
        map.put("fileName", fileName);
        String templateId = String.valueOf(IdWorker.getId((Object)new SysTemplatePrintInfo()));
        String templatePath = templateId + File.separator + fileName;
        return this.saveFile(is, templateId, templatePath, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printTemplateDownload(HttpServletResponse response, String templatePath, String fileName) throws IOException {
        try (InputStream inputStream = null;){
            if (ToolUtil.isEmpty((Object)templatePath)) {
                templatePath = "/printTemplate/defaultTemplate.docx";
                fileName = "defaultTemplate.docx";
                inputStream = this.getClass().getResourceAsStream(templatePath);
            } else {
                SysPrintTemplateStorage printTemplateStorage = this.printTemplateStorageService.getByPath(templatePath);
                if (HussarUtils.isNotEmpty((Object)((Object)printTemplateStorage))) {
                    String fileContent = printTemplateStorage.getFileContent();
                    byte[] byteArray = Base64.getDecoder().decode(fileContent);
                    inputStream = new ByteArrayInputStream(byteArray);
                }
            }
            if (inputStream != null) {
                int bytesRead;
                response.setContentType("multipart/form-data");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                byte[] buffer = new byte[1024];
                BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
                outputStream.close();
            }
        }
    }

    public Map<String, Object> saveFile(InputStream inputStream, String templateId, String templatePath, Map<String, Object> map) {
        SysPrintTemplateStorage sysPrintTemplateStorage = new SysPrintTemplateStorage();
        sysPrintTemplateStorage.setFileId(Long.valueOf(templateId));
        sysPrintTemplateStorage.setFileName(String.valueOf(map.get("fileName")));
        sysPrintTemplateStorage.setFilePath(templatePath);
        try {
            int bytesRead;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            byte[] imageBytes = outputStream.toByteArray();
            String base64EncodedString = Base64.getEncoder().encodeToString(imageBytes);
            sysPrintTemplateStorage.setFileContent(base64EncodedString);
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        this.printTemplateStorageService.saveMore(sysPrintTemplateStorage);
        map.put("templatePath", templatePath);
        return map;
    }
}

