/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.version.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.version.service.FilePathService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilePathServiceImpl
implements FilePathService {
    private static final String FILE_PATH_STORE = "/publish/file_path/file_path.json";
    private static String FILE_PATH_STORE_PATH = "";

    @Autowired
    public FilePathServiceImpl(FormDesignProperties formDesignProperties) {
        String projectPath = formDesignProperties.getProjectPath();
        String storeRootPath = formDesignProperties.getProjectRootPath();
        FILE_PATH_STORE_PATH = projectPath + storeRootPath + FILE_PATH_STORE;
    }

    @Override
    public void saveFilePathWithId(String id, String filePath) throws IOException {
        File file = new File(FILE_PATH_STORE_PATH);
        Map<String, String> filePathMap = this.getFilePathMap();
        filePathMap.put(id, filePath);
        FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(filePathMap), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public String getFilePathById(String id) throws IOException {
        Map<String, String> filePathMap = this.getFilePathMap();
        return filePathMap.get(id);
    }

    private Map<String, String> getFilePathMap() throws IOException {
        File file = new File(FILE_PATH_STORE_PATH);
        if (!FileUtils.exists((File)file)) {
            return new HashMap<String, String>();
        }
        String filePathMapJson = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return (Map)JSONObject.parseObject((String)filePathMapJson, (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public String getFileContent(String currentFilePath) throws IOException {
        File currentFile;
        if (ToolUtil.isNotEmpty((Object)currentFilePath) && FileUtils.exists((File)(currentFile = new File(currentFilePath)))) {
            return FileUtils.readFileToString((File)currentFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }
}

