/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateCategoryInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateCategoryInfoService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageTemplateCategoryInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class PageTemplateCategoryInfoServiceImpl
implements PageTemplateCategoryInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void createDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        File file;
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String path = "";
        if (!ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)pageTemplateCategoryInfo.getName())) {
            path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        }
        if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(path, rootPath))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        try {
            FileUtils.forceMkdir((File)file);
            File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
            FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateCategoryInfo), (String)"UTF-8", (boolean)false);
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6587\u4ef6\uff1a%s", fileOfMeta.getName()), Collections.singletonList(fileOfMeta.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.DIRECTORY_CREATE_FAIL, file.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        try {
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateCategoryInfo), (String)"UTF-8");
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6\uff1a%s", metaFile.getName()), Collections.singletonList(metaFile.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaFile.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void deleteDirectory(PageTemplateCategoryInfo pageTemplateCategoryInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String path = pageTemplateCategoryInfo.getLibName() + File.separator + pageTemplateCategoryInfo.getName();
        File cateFile = new File(this.relativeToAbsolute(path, rootPath));
        List<String> coverList = this.getCovers(cateFile);
        File coverSaveDirectory = new File(this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath());
        try {
            File[] files;
            for (File file : files = FileUtils.listFiles((File)cateFile)) {
                this.sysQuoteRelationService.deleteQuoteRelationByReferResid(file.getName().split("\\.")[0]);
            }
            this.deleteCovers(coverSaveDirectory, coverList);
            FileUtils.forceDelete((File)cateFile);
            FileUtils.forceDelete((File)new File(this.addMeta(cateFile.getAbsolutePath())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, cateFile.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    public List<String> getCovers(File cateFile) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        File[] files = FileUtils.listFiles((File)cateFile);
        if (ToolUtil.isNotEmpty((Object)files)) {
            for (File file1 : files) {
                File mataFile = new File(file1.getAbsolutePath());
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"));
                String cover = (String)jsonObject.get((Object)"cover");
                if ("".equals(cover)) continue;
                list.add(cover);
            }
        }
        return list;
    }

    public void deleteCovers(File file, List<String> coverList) throws IOException {
        File[] files = FileUtils.listFiles((File)file);
        if (ToolUtil.isNotEmpty((Object)files) && coverList.size() > 0) {
            block0: for (File file1 : files) {
                String coverName = file1.getName();
                for (int i = 0; i < coverList.size(); ++i) {
                    if (!coverName.equals(coverList.get(i))) continue;
                    coverList.remove(coverList.get(i));
                    --i;
                    FileUtils.forceDelete((File)file1);
                    if (coverList.size() == 0) continue block0;
                }
            }
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }
}

