/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.MetaConfigVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MetaFileService;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class MetaFileDataBaseServiceImpl
implements MetaFileService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private LcdpVersionProperties lcdpVersionProperties;
    @Resource
    private FileDataBaseHelper fileDataBaseHelper;
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    private static final String VERSION = "version";
    private static final String UPGRADE = "upgrade";
    private static final String REPLACED_ID = "replacedId";

    @Override
    public MetaConfigVo updateMetaVersionById(String id) throws LcdpException, IOException {
        String lcdpVersion;
        MetaConfigVo metaConfigVo = new MetaConfigVo();
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        JSONObject jsonObject = this.fileMappingService.getJsonObjectById(id);
        String currentVersion = (String)jsonObject.get((Object)VERSION);
        if (!HussarUtils.equals((Object)currentVersion, (Object)(lcdpVersion = this.lcdpVersionProperties.getLcdpVersion()))) {
            List ids = (List)ToolCacheUtile.get((String)(UPGRADE + id), (String)(REPLACED_ID + id));
            ToolCacheUtile.evict((String)(UPGRADE + id), (String)(REPLACED_ID + id));
            if (HussarUtils.isNotEmpty((Object)ids)) {
                List replacedId = (List)jsonObject.get((Object)REPLACED_ID);
                if (HussarUtils.isNotEmpty((Object)replacedId)) {
                    ids.addAll(replacedId);
                }
                jsonObject.put(REPLACED_ID, (Object)ids);
                metaConfigVo.setReplacedId(ids);
            }
            jsonObject.put(VERSION, (Object)lcdpVersion);
            metaConfigVo.setVersion(lcdpVersion);
            metaFile.setData(JSON.toJSONString((Object)jsonObject));
            this.sysMidFileCodeService.updateById((Object)metaFile);
            return metaConfigVo;
        }
        return metaConfigVo;
    }
}

