/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.refer.PageRefer;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileDataBaseCommonService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileService;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFileDataBaseServiceImpl<T extends BaseFile>
implements BaseFileService<T> {
    protected FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    protected SysMidFileCodeService sysMidFileCodeService = (SysMidFileCodeService)SpringContextHolder.getBean(SysMidFileCodeService.class);
    protected GodAxeModelService godAxeModelService = (GodAxeModelService)SpringContextHolder.getBean(GodAxeModelService.class);
    protected PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    protected FileDataBaseHelper fileDataBaseHelper = (FileDataBaseHelper)SpringContextHolder.getBean(FileDataBaseHelper.class);
    protected LcdpVersionProperties lcdpVersionProperties = (LcdpVersionProperties)SpringContextHolder.getBean(LcdpVersionProperties.class);
    protected BaseFileDataBaseCommonService dataBaseCommonService = (BaseFileDataBaseCommonService)SpringContextHolder.getBean(BaseFileDataBaseCommonService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFileDataBaseServiceImpl.class);

    @Override
    @HussarTransactional
    public String create(T baseFile) throws LcdpException, IOException {
        String version = this.lcdpVersionProperties.getLcdpVersion();
        baseFile.setVersion(version);
        this.sysMidFileCodeService.saveFile(baseFile);
        return version;
    }

    @Override
    @HussarTransactional
    public void createMultiple(List<T> baseFiles) {
        for (BaseFile baseFile : baseFiles) {
            this.sysMidFileCodeService.saveFile(baseFile);
        }
    }

    @Override
    public void addOrUpdateFileData(T baseFile) throws LcdpException {
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(baseFile.getId());
        if (HussarUtils.isEmpty((Object)mainFile)) {
            this.sysMidFileCodeService.saveFile(baseFile);
        } else {
            this.updateFileData(baseFile);
        }
    }

    @Override
    public void delete(String fileId) throws LcdpException, IOException {
        this.sysMidFileCodeService.deleteFile(fileId);
    }

    @Override
    public void update(T baseFile) throws LcdpException {
        this.dataBaseCommonService.updateFileData(baseFile);
    }

    @Override
    public void updateFile(T baseFile) throws LcdpException {
        this.dataBaseCommonService.updateFileData(baseFile);
    }

    @Override
    public JSONObject updateFileNew(T baseFile) {
        String fileData = baseFile.getData();
        JSONObject fileDataJsonObj = JSON.parseObject((String)fileData);
        Object referencesObj = fileDataJsonObj.get((Object)"references");
        if (ToolUtil.isNotEmpty((Object)referencesObj)) {
            JSONArray referArray = JSON.parseArray((String)JSON.toJSONString((Object)referencesObj));
            PageRefer pageRefer = (PageRefer)JSON.parseObject((String)JSON.toJSONString((Object)referArray.get(0)), PageRefer.class);
            String referPath = pageRefer.getReferPath();
            String name = referPath.split("\\.")[0];
            fileDataJsonObj = JSON.parseObject((String)fileData.replaceAll(name, baseFile.getId()));
        }
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(baseFile.getId());
        mainFile.setData(JSON.toJSONString((Object)fileDataJsonObj));
        return fileDataJsonObj;
    }

    @Override
    @HussarTransactional
    public void updateFileData(T baseFile) throws LcdpException {
        this.dataBaseCommonService.updateFileData(baseFile);
    }

    @Override
    @HussarTransactional
    public void updateFileCommonModelData(T baseFile) throws LcdpException {
        this.sysMidFileCodeService.updateFile(baseFile);
    }

    @Override
    public void updateFileMeta(T baseFile) throws IOException, LcdpException {
        this.dataBaseCommonService.updateFileData(baseFile);
    }

    @Override
    public T get(String id) throws LcdpException, IOException {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(id);
        if (HussarUtils.isEmpty((Object)metaFile)) {
            return null;
        }
        Type fileType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        BaseFile t = (BaseFile)JSON.parseObject((String)metaFile.getData(), (Type)fileType, (Feature[])new Feature[0]);
        if (HussarUtils.isNotEmpty((Object)mainFile)) {
            t.setData(mainFile.getData());
        }
        return (T)t;
    }

    @Override
    public JSONObject getCrossApp(String appId, String fileId) throws LcdpException, IOException {
        return null;
    }

    @Override
    @HussarTransactional
    public void move(String fileId, String parentId, String newName, String newDesc) {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(fileId);
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(fileId);
        metaFile.setParentId(parentId);
        mainFile.setParentId(parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFile.setName(newName);
            mainFile.setName(newName);
        }
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFileData.put("name", (Object)newName);
        }
        if (newDesc != null) {
            metaFileData.put("desc", (Object)newDesc);
        }
        this.sysMidFileCodeService.updateById((Object)metaFile);
        this.sysMidFileCodeService.updateById((Object)mainFile);
    }

    @Override
    public void copy(String fileId, String parentId, String newId, String newName, String newDesc) {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(fileId);
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(fileId);
        metaFile.setId(null);
        metaFile.setFileId(newId);
        metaFile.setParentId(parentId);
        mainFile.setId(null);
        mainFile.setFileId(newId);
        mainFile.setParentId(parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFile.setName(newName);
            mainFile.setName(newName);
        }
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        metaFileData.put("id", (Object)newId);
        metaFileData.put("isMenuSet", (Object)false);
        if (newName != null && !newName.isEmpty()) {
            metaFileData.put("name", (Object)newName);
        }
        if (newDesc != null && !newDesc.isEmpty()) {
            metaFileData.put("desc", (Object)newDesc);
        }
        metaFile.setData(JSON.toJSONString((Object)metaFileData));
        this.sysMidFileCodeService.save((Object)metaFile);
        this.sysMidFileCodeService.save((Object)mainFile);
    }

    @Override
    public JSONObject copyNew(String fileId, String parentId, String newId, String newName, String newDesc) {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(fileId);
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(fileId);
        metaFile.setId(null);
        metaFile.setFileId(newId);
        metaFile.setParentId(parentId);
        mainFile.setId(null);
        mainFile.setFileId(newId);
        mainFile.setParentId(parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFile.setName(newName);
            mainFile.setName(newName);
        }
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        metaFileData.put("id", (Object)newId);
        metaFileData.put("isMenuSet", (Object)false);
        if (newName != null && !newName.isEmpty()) {
            metaFileData.put("name", (Object)newName);
        }
        if (newDesc != null && !newDesc.isEmpty()) {
            metaFileData.put("desc", (Object)newDesc);
        }
        metaFile.setData(JSON.toJSONString((Object)metaFileData));
        String mainFileData = mainFile.getData();
        mainFileData = mainFileData.replaceAll(fileId, newId);
        mainFile.setData(mainFileData);
        this.sysMidFileCodeService.save((Object)metaFile);
        this.sysMidFileCodeService.save((Object)mainFile);
        return JSON.parseObject((String)mainFileData);
    }

    @Override
    public String getJsPath(String id) throws LcdpException {
        return this.fileMappingService.getFormatPath(id);
    }

    @Override
    public JSONObject getExtend(String id) throws IOException, LcdpException {
        return null;
    }
}

