/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.ComponentCategoryInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentCategoryService;
import com.jxdinfo.hussar.formdesign.component.vo.AllComponentCategoryInfoVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class ComponentCategoryServiceImpl
implements ComponentCategoryService {
    @Override
    public synchronized boolean addCategory(ComponentCategoryInfo componentCategoryInfo) throws IOException, LcdpException {
        if (HussarUtils.isEmpty((Object)componentCategoryInfo) || HussarUtils.isEmpty((Object)componentCategoryInfo.getName())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUNT_FILED, "\u672a\u627e\u5230\u5206\u7c7b\u4fe1\u606f");
        }
        List<ComponentCategoryInfo> componentCategoryInfos = this.getAllComponentCategoryInfo(componentCategoryInfo.getLibName());
        int index = -1;
        for (int i = 0; i < componentCategoryInfos.size(); ++i) {
            if (!componentCategoryInfo.getName().equals(componentCategoryInfos.get(i).getName())) continue;
            index = i;
        }
        if (index == -1) {
            componentCategoryInfos.add(componentCategoryInfo);
        } else {
            componentCategoryInfos.set(index, componentCategoryInfo);
        }
        this.writeComponentCategorys(componentCategoryInfos, componentCategoryInfo.getLibName());
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath();
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6\uff1a .projectStore components", new Object[0]), Collections.singletonList(path1));
        return true;
    }

    @Override
    public AllComponentCategoryInfoVo getAllComponentCategoryInfo() throws IOException {
        AllComponentCategoryInfoVo componentCategoryInfoVo = new AllComponentCategoryInfoVo();
        List<ComponentCategoryInfo> webPageComponentCategoryInfos = this.getAllComponentCategoryInfo("WebPage");
        List<ComponentCategoryInfo> mobilePageComponentCategoryInfos = this.getAllComponentCategoryInfo("MobilePage");
        List<ComponentCategoryInfo> uniPageComponentCategoryInfos = this.getAllComponentCategoryInfo("UniPage");
        componentCategoryInfoVo.setWebPageComponentCategoryInfos(webPageComponentCategoryInfos);
        componentCategoryInfoVo.setMobilePageComponentCategoryInfos(mobilePageComponentCategoryInfos);
        componentCategoryInfoVo.setUniPageComponentCategoryInfos(uniPageComponentCategoryInfos);
        return componentCategoryInfoVo;
    }

    @Override
    public List<ComponentCategoryInfo> getAllComponentCategoryInfo(String type) throws IOException {
        if (VfgModeTool.isRemote()) {
            ArrayList<ComponentCategoryInfo> componentCategoryInfos = new ArrayList<ComponentCategoryInfo>();
            componentCategoryInfos.addAll(this.getAllExtensionComponentCategoryInfo(type));
            componentCategoryInfos.addAll(this.getAllOtherComponentCategoryInfo(type));
            return componentCategoryInfos;
        }
        List<ComponentCategoryInfo> componentCategoryInfos = new ArrayList<ComponentCategoryInfo>();
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath();
        File file1 = new File(path1);
        if (!com.jxdinfo.hussar.formdesign.common.util.FileUtils.exists((File)file1)) {
            return componentCategoryInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
        File file2 = new File(path2);
        if (!com.jxdinfo.hussar.formdesign.common.util.FileUtils.exists((File)file2)) {
            return componentCategoryInfos;
        }
        String jsonStr = com.jxdinfo.hussar.formdesign.common.util.FileUtils.readFileToString((File)file2, (Charset)StandardCharsets.UTF_8);
        componentCategoryInfos = JSON.parseArray((String)jsonStr, ComponentCategoryInfo.class);
        return componentCategoryInfos;
    }

    public List<ComponentCategoryInfo> getAllExtensionComponentCategoryInfo(String type) throws IOException {
        List<ComponentCategoryInfo> componentCategoryInfos = new ArrayList<ComponentCategoryInfo>();
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            return componentCategoryInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentCategoryInfos;
        }
        String jsonStr = FileUtils.readFileToString((File)file2, (Charset)StandardCharsets.UTF_8);
        componentCategoryInfos = JSON.parseArray((String)jsonStr, ComponentCategoryInfo.class);
        return componentCategoryInfos;
    }

    public List<ComponentCategoryInfo> getAllOtherComponentCategoryInfo(String type) throws IOException {
        List<ComponentCategoryInfo> componentCategoryInfos = new ArrayList<ComponentCategoryInfo>();
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath();
        File file1 = new File(path1);
        if (!com.jxdinfo.hussar.formdesign.common.util.FileUtils.exists((File)file1)) {
            return componentCategoryInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
        File file2 = new File(path2);
        if (!com.jxdinfo.hussar.formdesign.common.util.FileUtils.exists((File)file2)) {
            return componentCategoryInfos;
        }
        String jsonStr = com.jxdinfo.hussar.formdesign.common.util.FileUtils.readFileToString((File)file2, (Charset)StandardCharsets.UTF_8);
        componentCategoryInfos = JSON.parseArray((String)jsonStr, ComponentCategoryInfo.class);
        return componentCategoryInfos;
    }

    @Override
    public void writeComponentCategorys(List<ComponentCategoryInfo> componentCategoryInfos, String type) throws IOException {
        if (VfgModeTool.isRemote()) {
            List<ComponentCategoryInfo> customCategoryList = componentCategoryInfos.stream().filter(componentCategoryInfo -> ComponentType.CUSTOM.getValue().equals(componentCategoryInfo.getName())).collect(Collectors.toList());
            this.writeOtherComponentCategorys(customCategoryList, type);
            List<ComponentCategoryInfo> extensionCategoryList = componentCategoryInfos.stream().filter(componentCategoryInfo -> !ComponentType.CUSTOM.getValue().equals(componentCategoryInfo.getName())).collect(Collectors.toList());
            this.writeExtensionComponentCategorys(extensionCategoryList, type);
        } else {
            String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath();
            File file1 = new File(path1);
            if (!com.jxdinfo.hussar.formdesign.common.util.FileUtils.exists((File)file1)) {
                com.jxdinfo.hussar.formdesign.common.util.FileUtils.forceMkdir((File)file1);
            }
            String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
            File file = new File(path2);
            com.jxdinfo.hussar.formdesign.common.util.FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentCategoryInfos), (String)"UTF-8", (boolean)false);
        }
    }

    public void writeExtensionComponentCategorys(List<ComponentCategoryInfo> componentCategoryInfos, String type) throws IOException {
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            FileUtils.forceMkdir((File)file1);
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
        File file = new File(path2);
        FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentCategoryInfos), (String)"UTF-8", (boolean)false);
    }

    public void writeOtherComponentCategorys(List<ComponentCategoryInfo> componentCategoryInfos, String type) throws IOException {
        String path1 = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            com.jxdinfo.hussar.formdesign.common.util.FileUtils.forceMkdir((File)file1);
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentCategory.json"});
        File file = new File(path2);
        com.jxdinfo.hussar.formdesign.common.util.FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentCategoryInfos), (String)"UTF-8", (boolean)false);
    }
}

