/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl.BaseFileServiceOnLineImpl;
import com.jxdinfo.hussar.formdesign.preview.service.PagePreviewService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class PageInfoServiceOnLineImpl
extends BaseFileServiceOnLineImpl<PageInfo>
implements PageInfoService {
    private final FormDesignProperties formDesignProperties;
    @Qualifier(value="MicroAppInfoServiceImpl")
    @Autowired
    public MicroAppInfoService microAppInfoService;
    @Autowired
    public PagePreviewService pagePreviewService;

    @Autowired
    public PageInfoServiceOnLineImpl(FormDesignProperties formDesignProperties) {
        this.formDesignProperties = formDesignProperties;
    }

    @Override
    public PageInfoNode getPageInfoNodeFromPageToRoot(String id) throws IOException, LcdpException {
        BaseFile pageInfo = this.fileMappingService.getPageInfoById(id);
        String cnName = pageInfo.getDesc();
        String enName = pageInfo.getName();
        boolean isPage = "WebPage".equals(pageInfo.getType());
        PageInfoNode pageInfoNode = new PageInfoNode(enName, cnName, isPage, pageInfo.getId());
        String parentId = pageInfo.getParentId();
        if (!"#".equals(parentId)) {
            pageInfoNode.parent = this.getPageInfoNodeFromPageToRoot(parentId);
            pageInfoNode.parent.child = pageInfoNode;
        }
        return pageInfoNode;
    }

    @Override
    public String getWebUrl(String pageId) throws LcdpException {
        String path = "test";
        String url = this.formDesignProperties.getWebUrl() + "/#/" + AppContextUtil.getUnionPrefix() + "/" + path;
        return url;
    }

    @Override
    public String getMobileUrl(String pageId) throws IOException, LcdpException {
        String appId = ((PageInfo)this.get(pageId)).getMicroApp();
        Integer port = ((MicroAppInfo)((Object)this.microAppInfoService.get(appId))).getAppPort();
        String path = this.fileMappingService.getFormatPath(pageId);
        String url = path == null ? null : this.formDesignProperties.getMobileIp() + ":" + port + FileUtil.posixPath((String[])new String[]{"#", AppContextUtil.getUnionPrefix(), path});
        return url;
    }

    @Override
    public Map<String, Object> getAllReferencesAndErrorsList() throws IOException {
        return null;
    }

    @Override
    public List<String> getPageState(List<String> ids) {
        return null;
    }

    @Override
    public JSONObject getExtend(String id) throws IOException, LcdpException {
        return null;
    }
}

