/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl.BaseFileServiceOnLineImpl;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="ModuleInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class ModuleInfoServiceOnLineImpl
extends BaseFileServiceOnLineImpl<ModuleInfo>
implements ModuleInfoService {
    private final IndexStorageLockService indexStorageLockService;

    @Autowired
    public ModuleInfoServiceOnLineImpl(StorageService storageService, FileMappingService fileMappingService, IndexStorageLockService indexStorageLockService) {
        this.indexStorageLockService = indexStorageLockService;
        this.storageService = storageService;
        this.fileMappingService = fileMappingService;
    }

    @Override
    public FormDesignResponse<String> createDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        String path;
        String parentPath = null;
        String rootPath = this.getDataPath("#");
        if (!ToolUtil.isEmpty((Object)moduleInfo.getParentId()) && !"#".equals(moduleInfo.getParentId())) {
            parentPath = this.getDataPath(moduleInfo.getParentId());
        }
        String string = path = ToolUtil.isNotEmpty(parentPath) ? parentPath + File.separator + moduleInfo.getName() + ".meta" : rootPath + File.separator + moduleInfo.getName() + ".meta";
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, moduleInfo.getId());
        }
        StorageResult result = this.storageService.uploadByUuid(CategoryEnum.META, moduleInfo.getId(), ToolUtil.pathFomatterByOS((String)path), JSON.toJSONString((Object)((Object)moduleInfo)).getBytes(StandardCharsets.UTF_8), true);
        if (!result.isSuccess()) {
            throw new IOException(result.getMsg());
        }
        this.fileMappingService.fileMappingCacheEvict();
        return new FormDesignResponse();
    }

    @Override
    public FormDesignResponse<String> createDirectoryBatch(List<ModuleInfo> moduleInfoList) throws LcdpException, IOException {
        FormDesignResponse response = new FormDesignResponse();
        for (ModuleInfo moduleInfo : moduleInfoList) {
            FormDesignResponse<String> formDesignResponse = this.createDirectory(moduleInfo);
            if (formDesignResponse.getErrorCode() == HttpStatus.OK.value()) continue;
            return formDesignResponse;
        }
        response.setErrorCode(HttpStatus.OK.value());
        return response;
    }

    @Override
    public void copyDirectory(String id, String parentId, String uuid, String newName, String newDesc) throws LcdpException, IOException {
        String newJsonPath;
        StorageResult result;
        String path = this.getDataPath(id);
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1) + ".meta";
        List list = (List)this.storageService.list(path + "/", "", true).getData();
        String metaPath = this.getDataPath(parentId) + File.separator;
        metaPath = metaPath + (newName != null && !"".equals(newName) ? newName + ".meta" : fileName);
        BaseFile toMeta = this.fileMappingService.getPageInfoById(id);
        toMeta.setParentId(parentId);
        toMeta.setId(uuid);
        if (newName != null) {
            toMeta.setName(newName);
        }
        if (newDesc != null) {
            toMeta.setDesc(newDesc);
        }
        if (!(result = this.storageService.uploadByUuid(CategoryEnum.META, uuid, (newJsonPath = this.getNewJsonPath(parentId, metaPath)) + ".meta", JSON.toJSONString((Object)toMeta).getBytes(StandardCharsets.UTF_8), true)).isSuccess()) {
            throw new IOException(result.getMsg());
        }
        if (ToolUtil.isNotEmpty((Object)list)) {
            HashMap<String, String> moduleMetaInfos = new HashMap<String, String>();
            HashMap<String, String> moduleJsonInfos = new HashMap<String, String>();
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Boolean> dataModelMap = new HashMap<String, Boolean>();
            SimpleDateFormat identitySdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            for (int i = 0; i < list.size(); ++i) {
                StorageEntity o = (StorageEntity)list.get(i);
                if (o.getUuid().equals(id)) continue;
                String newId = ToolUtil.get36UUID();
                String newParentId = ToolUtil.get36UUID();
                byte[] data = o.getContent();
                String content = new String(data != null ? data : "".getBytes(), StandardCharsets.UTF_8);
                if ("META".equals(o.getType())) {
                    String isNewId;
                    WorkflowInfo moduleInfo = (WorkflowInfo)((Object)JSON.parseObject((String)content, (TypeReference)new TypeReference<WorkflowInfo>(){}, (Feature[])new Feature[0]));
                    if ("DataModel".equals(moduleInfo.getType())) {
                        dataModelMap.put(o.getUuid(), true);
                        continue;
                    }
                    if ("Workflow".equals(moduleInfo.getType())) {
                        moduleInfo.setIdentity("key-" + identitySdf.format(new Date()) + i);
                    }
                    if (ToolUtil.isEmpty((Object)(isNewId = (String)map.get(map.get(moduleInfo.getId()))))) {
                        map.put(moduleInfo.getId(), newId);
                        moduleInfo.setId(newId);
                    } else {
                        moduleInfo.setId(isNewId);
                    }
                    if (moduleInfo.getParentId().equals(id)) {
                        moduleInfo.setParentId(uuid);
                        map.put(id, uuid);
                        moduleMetaInfos.put(o.getUuid(), JSON.toJSONString((Object)((Object)moduleInfo)));
                        continue;
                    }
                    String isNewPId = (String)map.get(moduleInfo.getParentId());
                    if (ToolUtil.isEmpty((Object)isNewPId)) {
                        map.put(moduleInfo.getParentId(), newParentId);
                        moduleInfo.setParentId(newParentId);
                    } else {
                        moduleInfo.setParentId(isNewPId);
                    }
                    moduleMetaInfos.put(o.getUuid(), JSON.toJSONString((Object)((Object)moduleInfo)));
                    continue;
                }
                moduleJsonInfos.put(o.getUuid(), content);
            }
            for (StorageEntity o : list) {
                if (Boolean.TRUE.equals(dataModelMap.get(o.getUuid()))) continue;
                String entityPath = o.getPath();
                o.setPath(entityPath.replace(StringUtils.removeEnd((String)FileUtil.posixPath((String[])new String[]{path}), (String)".meta"), StringUtils.removeEnd((String)metaPath, (String)".meta")));
                this.iteratorFile(o, moduleMetaInfos, moduleJsonInfos, map);
            }
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private void iteratorFile(StorageEntity o, Map<String, String> moduleInfos1, Map<String, String> moduleInfos2, Map<String, String> map) throws IOException {
        String uuid = map.get(o.getUuid());
        if (ToolUtil.isEmpty((Object)uuid)) {
            return;
        }
        if ("META".equals(o.getType())) {
            StorageResult result = this.storageService.uploadByUuid(CategoryEnum.META, uuid, o.getPath(), moduleInfos1.get(o.getUuid()).getBytes(StandardCharsets.UTF_8), true);
            if (!result.isSuccess()) {
                throw new IOException(result.getMsg());
            }
        } else {
            StorageResult result = this.storageService.uploadByUuid(CategoryEnum.JSON, uuid, o.getPath(), moduleInfos2.get(o.getUuid()).getBytes(StandardCharsets.UTF_8), true);
            if (!result.isSuccess()) {
                throw new IOException(result.getMsg());
            }
        }
    }

    @Override
    public FormDesignResponse<ModuleInfo> deleteDirectory(String id) throws LcdpException, IOException {
        String path = this.fileMappingService.getMetaPath(id);
        StorageResult result = this.storageService.list(StringUtils.removeEnd((String)path, (String)".meta") + "/", "", false);
        if (result.isSuccess() && ToolUtil.isNotEmpty((Object)result.getData())) {
            SecurityUser user = BaseSecurityUtil.getUser();
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            if (ToolUtil.isEmpty((Object)user)) {
                speedCodeResponse.setErrorCode(400);
                speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
                return speedCodeResponse;
            }
            for (StorageEntity entity : (List)result.getData()) {
                StorageResult po;
                if ("META".equals(entity.getType()) || !ToolUtil.isNotEmpty((Object)(po = this.indexStorageLockService.getOneLockByResource(entity.getUuid())).getData()) || user.getId().equals(((StorageLockPO)po.getData()).getUserId())) continue;
                speedCodeResponse.setErrorCode(405);
                speedCodeResponse.setErrorMsg(((StorageLockPO)po.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
                return speedCodeResponse;
            }
            for (StorageEntity entity : (List)result.getData()) {
                if ("META".equals(entity.getType())) {
                    this.deleteFile(entity.getUuid());
                    continue;
                }
                this.deleteJson(entity.getUuid());
            }
        }
        this.deleteFile(id);
        this.fileMappingService.fileMappingCacheEvict();
        return new FormDesignResponse();
    }

    private void deleteFile(String id) throws LcdpException {
        StorageResult result = this.storageService.deleteByUuid(CategoryEnum.META, id, true);
        if (!result.isSuccess()) {
            String metaPath = this.fileMappingService.getMetaPath(id);
            this.storageService.deleteByPath(metaPath, true);
        }
    }

    private void deleteJson(String id) throws LcdpException {
        StorageResult result = this.storageService.deleteByUuid(CategoryEnum.JSON, id, true);
        if (!result.isSuccess()) {
            String dataPath = this.fileMappingService.getDataPath(id);
            this.storageService.deleteByPath(dataPath, true);
        }
    }

    @Override
    public void updateDirectory(ModuleInfo moduleInfo) throws LcdpException, IOException {
        String oldPath = this.fileMappingService.getMetaPath(moduleInfo.getId());
        String newPath = StringUtils.removeEnd((String)this.fileMappingService.getMetaPath(moduleInfo.getParentId()), (String)".meta") + File.separator + moduleInfo.getName() + ".meta";
        this.storageService.uploadByUuid(CategoryEnum.META, moduleInfo.getId(), oldPath, JSON.toJSONString((Object)((Object)moduleInfo)).getBytes(StandardCharsets.UTF_8), false);
        if (!oldPath.equals(newPath)) {
            this.moveFileList(oldPath, newPath);
            this.storageService.deleteByPath(oldPath, false);
        }
    }

    @Override
    public void moveDirectory(String id, String parentId, String newName, String newDesc) throws LcdpException, IOException {
        String newPath;
        String oldPath;
        BaseFile pageInfo = this.fileMappingService.getPageInfoById(id);
        pageInfo.setParentId(parentId);
        if (newName != null) {
            pageInfo.setName(newName);
        }
        if (newDesc != null) {
            pageInfo.setDesc(newDesc);
        }
        if (!(oldPath = this.fileMappingService.getMetaPath(id)).equals(newPath = this.getNewJsonPath(parentId, oldPath) + ".meta")) {
            this.storageService.uploadByUuid(CategoryEnum.META, id, oldPath, JSON.toJSONString((Object)pageInfo).getBytes(StandardCharsets.UTF_8), true);
            this.moveFileList(oldPath, newPath);
            this.storageService.deleteByPath(oldPath, false);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private void moveFileList(String oldPath, String newPath) {
        if (newPath != null) {
            StorageResult child = this.storageService.list(StringUtils.removeEnd((String)oldPath, (String)".meta") + "/", "", true);
            this.storageService.rename(oldPath, newPath, false);
            if (child.isSuccess()) {
                List list = (List)child.getData();
                for (StorageEntity entity : list) {
                    String entityPath = ToolUtil.pathFomatterByOS((String)entity.getPath());
                    int indexOf = entityPath.lastIndexOf(StringUtils.removeEnd((String)oldPath, (String)".meta"));
                    if (indexOf <= -1) continue;
                    String entityNewPath = StringUtils.removeEnd((String)newPath, (String)".meta") + entityPath.replace(StringUtils.removeEnd((String)oldPath, (String)".meta"), "");
                    this.storageService.rename(entity.getPath(), entityNewPath, false);
                }
            }
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private String getNewJsonPath(String newParentId, String oldMetaPath) throws LcdpException {
        String newMetaPath;
        String oldMetaName = oldMetaPath.substring(oldMetaPath.lastIndexOf("/") + 1).substring(oldMetaPath.lastIndexOf("\\") + 1);
        String newParentPath = this.fileMappingService.getDataPath(newParentId);
        String testNewMetaPath = newParentPath + File.separator + oldMetaName;
        if (Boolean.TRUE.equals(this.storageService.existsByPath(testNewMetaPath).getData())) {
            StringBuilder newDataName = new StringBuilder(oldMetaName.substring(0, oldMetaName.indexOf(46)));
            String suffix = oldMetaName.substring(oldMetaName.indexOf(46));
            do {
                newDataName.append('1');
            } while (Boolean.TRUE.equals(this.storageService.existsByPath(newParentPath + newDataName + suffix).getData()));
            newMetaPath = newParentPath + File.separator + newDataName + suffix;
        } else {
            newMetaPath = testNewMetaPath;
        }
        return newMetaPath.substring(0, newMetaPath.lastIndexOf(46));
    }
}

