/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.CustomComponentCategoryInfo;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CustomComponentCategoryInfoService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="CustomComponentCategoryInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class CustomComponentCategoryInfoServiceOnLineImpl
implements CustomComponentCategoryInfoService {
    @Resource
    private StorageService storageService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void createDirectory(CustomComponentCategoryInfo customComponentCategoryInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        if (!ToolUtil.isEmpty((Object)customComponentCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)customComponentCategoryInfo.getName())) {
            String catePath = customComponentCategoryInfo.getLibName() + File.separator + customComponentCategoryInfo.getName();
            String metaPath = this.addMeta(this.relativeToAbsolute(catePath, rootPath));
            Boolean isExists = Boolean.TRUE.equals(this.storageService.existsByPath(metaPath).getData());
            if (isExists.booleanValue()) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaPath);
            }
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentCategoryInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u7ec4\u4ef6\u5206\u7c7b\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void updateDirectory(CustomComponentCategoryInfo customComponentCategoryInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        if (!ToolUtil.isEmpty((Object)customComponentCategoryInfo.getLibName()) && !ToolUtil.isEmpty((Object)customComponentCategoryInfo.getName())) {
            String catePath = customComponentCategoryInfo.getLibName() + File.separator + customComponentCategoryInfo.getName();
            String metaPath = this.addMeta(this.relativeToAbsolute(catePath, rootPath));
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentCategoryInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u7ec4\u4ef6\u5206\u7c7b\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void deleteDirectory(String name) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        try {
            JSONObject customCusCate = this.iterator(name);
            String libName = customCusCate.getString("libName");
            String filePath = rootPath + File.separator + libName + File.separator + name;
            this.storageService.deleteByPath(this.addMeta(filePath), false);
            List storageEntities = (List)this.storageService.list(filePath, ".meta", true).getData();
            this.deleteCustomComponents(storageEntities, filePath);
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, "\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5206\u7c7b:" + name);
        }
    }

    public void deleteCustomComponents(List<StorageEntity> storageEntities, String catePath) throws LcdpException, IOException {
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject file = JSON.parseObject((String)new String(storageEntity.getContent() != null ? storageEntity.getContent() : "".getBytes(), "UTF-8"));
            String fileName = file.getString("name");
            String cover = file.getString("cover");
            String filePath = catePath + File.separator + fileName;
            this.storageService.deleteByPath(this.addMeta(filePath), false);
            this.delCover(cover);
        }
    }

    public void delCover(String fileName) {
        if (!"".equals(fileName)) {
            String fileSavePath = this.pathStrategy.resourcePathService().projectStoreCustomComponentsCover(new String[0]).getRemotePath();
            String filePath = ToolUtil.pathFomatterByOS((String)fileSavePath) + File.separator + fileName;
            this.storageService.deleteByPath(filePath, false);
        }
    }

    public JSONObject iterator(String name) throws IOException {
        JSONObject jsonObject = null;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        List storageEntities = (List)this.storageService.list(rootPath, ".meta", true).getData();
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject currFile = JSON.parseObject((String)new String(storageEntity.getContent() != null ? storageEntity.getContent() : "".getBytes(), "UTF-8"));
            String currName = currFile.getString("name");
            if (!name.equals(currName)) continue;
            jsonObject = currFile;
            break;
        }
        return jsonObject;
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    public JSONObject getCurrFileInfo(List<JSONObject> jsonObjects) {
        JSONObject jsonObject = null;
        Iterator<JSONObject> iterator = jsonObjects.iterator();
        while (iterator.hasNext()) {
            JSONObject currFileInfo;
            jsonObject = currFileInfo = iterator.next();
        }
        return jsonObject;
    }
}

