/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.component.constant.CheckInfoEnum;
import com.jxdinfo.hussar.formdesign.component.model.CheckInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelPageManifest;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ModelPageTemplateUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.ModelPageTemplate;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.formdesign.pageTemplate.service.impl.PageTemplateServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class PageTemplateInfoServiceImpl
implements PageTemplateInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private PathStrategyService pathStrategy;
    @Resource
    private OssService ossService;
    @Resource
    private PageTemplateServiceImpl pageTemplateService;
    private final List<String> functionTypeRange = Arrays.asList("BASE", "MASTER_SLAVE", "FLOW", "FLOW_MASTER_SLAVE", "TASK", "TASK_MASTER_SLAVE");
    private final List<String> flowTypeRange = Arrays.asList("FLOW", "FLOW_MASTER_SLAVE", "TASK", "TASK_MASTER_SLAVE");
    private final List<String> pageTypeRange = Arrays.asList("WebPage", "UniPage", "WebAndUni");
    private final List<String> templateTypeRange = Arrays.asList("formPage", "listPage", "mobileFormPage", "mobileListPage");

    @Override
    public void create(PageTemplateInfo pageTemplateInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        if (FileUtils.exists((File)mateFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, mateFile.getAbsolutePath());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo), (String)"UTF-8", (boolean)false);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6a21\u677f\u4e2d\u95f4\u6587\u4ef6\uff1a%s", mateFile.getName()), Collections.singletonList(mateFile.getAbsolutePath()));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateFileMeta(PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        if (!FileUtils.exists((File)mateFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, pageTemplateInfo.getName());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo), (String)"UTF-8");
        VfgModeTool.pushToRemote((String)String.format("\u4fee\u6539\u65f6\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6 .projectStore", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void delete(PageTemplateInfo pageTemplateInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String parentPath = pageTemplateInfo.getPageType() + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        try {
            FileUtils.forceDelete((File)mateFile);
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, mateFile.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u6587\u4ef6\uff1a%s", mateFile.getName()), Collections.singletonList(mateFile.getAbsolutePath()));
        String cover = pageTemplateInfo.getCover();
        if (!"".equals(cover)) {
            this.delCover(cover);
        }
        this.sysQuoteRelationService.deleteQuoteRelationByReferResid(pageTemplateInfo.getName());
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        FormDesignResponse response = FileUtils.upload((MultipartFile)file, (String)fileSavePath);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6a21\u677f\u5c01\u9762\u56fe\u7247\uff1a%s", file.getOriginalFilename()), Collections.singletonList(fileSavePath));
        return response;
    }

    @Override
    public void delCover(String fileName) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath) + File.separator + fileName);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, file.getAbsolutePath());
            }
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u5c01\u9762\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    @Override
    public ResponseEntity<byte[]> getCover(String fileName) throws IOException, LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        File file = new File(fileSavePath + File.separator + fileName);
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        MediaType mime = ext.equals("jpg") || ext.equals("JPG") ? MediaType.IMAGE_JPEG : (ext.equals("png") || ext.equals("PNG") ? MediaType.IMAGE_PNG : MediaType.IMAGE_JPEG);
        if (FileUtils.exists((File)file) && !FileUtils.isDirectory((File)file)) {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return ResponseEntity.ok().contentType(mime).body((Object)bytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ApiResponse<String> uploadTemplate(String functionType, String pageType, MultipartFile zipFile) throws IOException {
        if (StringUtils.isBlank((CharSequence)functionType) || StringUtils.isBlank((CharSequence)pageType)) {
            return ApiResponse.fail((String)"\u529f\u80fd\u7c7b\u578b\u548c\u9875\u9762\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try {
            block117: {
                block116: {
                    block114: {
                        block111: {
                            try {
                                is = zipFile.getInputStream();
                                var7_9 = null;
                                try {
                                    Files.copy(is, zipPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                }
                                catch (Throwable var8_12) {
                                    var7_9 = var8_12;
                                    throw var8_12;
                                }
                                finally {
                                    if (is != null) {
                                        if (var7_9 != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (Throwable var8_11) {
                                                var7_9.addSuppressed(var8_11);
                                            }
                                        } else {
                                            is.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException e) {
                                throw new IOException(e);
                            }
                            zip = new ZipFile(zipPath.toFile());
                            var7_9 = null;
                            try {
                                block112: {
                                    manifestEntry = zip.getEntry("manifest.json");
                                    if (manifestEntry == null) {
                                        var9_17 = ApiResponse.fail((String)"\u538b\u7f29\u5305\u7f3a\u5c11manifest\u6587\u4ef6");
                                        return var9_17;
                                    }
                                    manifestStream = zip.getInputStream(manifestEntry);
                                    var10_22 = null;
                                    mapper = new ObjectMapper();
                                    manifest = mapper.readTree(manifestStream);
                                    manifestFunction = manifest.get("functionType").asText();
                                    manifestPageType = manifest.get("pageType").asText();
                                    if (!HussarUtils.isNotEmpty((Object)manifest.get("identity"))) ** break block110
                                    var15_33 = ApiResponse.fail((String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u8981\u653eidentity\u5c5e\u6027");
                                    if (manifestStream == null) break block111;
                                    if (var10_22 == null) break block112;
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (Throwable var16_36) {
                                        var10_22.addSuppressed(var16_36);
                                    }
                                    break block111;
                                }
                                manifestStream.close();
                            }
                            catch (Throwable manifestEntry) {
                                var7_9 = manifestEntry;
                                throw manifestEntry;
                            }
                            finally {
                                if (zip != null) {
                                    if (var7_9 != null) {
                                        try {
                                            zip.close();
                                        }
                                        catch (Throwable var10_21) {
                                            var7_9.addSuppressed(var10_21);
                                        }
                                    } else {
                                        zip.close();
                                    }
                                }
                            }
                        }
                        return var15_33;
                        {
                            block115: {
                                if (functionType.equals(manifestFunction) && pageType.equals(manifestPageType)) ** break block113
                                var15_34 = ApiResponse.fail((String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
                                if (manifestStream == null) break block114;
                                if (var10_22 == null) break block115;
                                try {
                                    manifestStream.close();
                                }
                                catch (Throwable var16_38) {
                                    var10_22.addSuppressed(var16_38);
                                }
                                break block114;
                            }
                            manifestStream.close();
                        }
                    }
                    return var15_34;
                    {
                        try {
                            if (manifestStream != null) {
                                if (var10_22 != null) {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (Throwable mapper) {
                                        var10_22.addSuppressed(mapper);
                                    }
                                } else {
                                    manifestStream.close();
                                }
                            }
                            break block116;
                            catch (Throwable mapper) {
                                try {
                                    var10_22 = mapper;
                                    throw mapper;
                                }
                                catch (Throwable var17_42) {
                                    if (manifestStream != null) {
                                        if (var10_22 != null) {
                                            try {
                                                manifestStream.close();
                                            }
                                            catch (Throwable var18_43) {
                                                var10_22.addSuppressed(var18_43);
                                            }
                                        } else {
                                            manifestStream.close();
                                        }
                                    }
                                    throw var17_42;
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new IOException(e);
                        }
                    }
                }
                try {
                    resultApiResponse = this.checkTemplate(zipFile);
                    if (!HussarUtils.isEmpty(((CheckResult)resultApiResponse.getData()).getData())) break block117;
                    manifestEntry = ApiResponse.fail((String)("\u6587\u4ef6\u6709\u8bef\uff1a" + ((CheckResult)resultApiResponse.getData()).getCheckInfos().get(0).getInfos().get(0).getMsg()));
                    return manifestEntry;
                }
                catch (IOException e) {
                    manifestEntry = ApiResponse.fail((String)"\u6821\u9a8c\u5931\u8d25");
                    return manifestEntry;
                }
            }
            identity = ((PageTemplateInductsInfo)((CheckResult)resultApiResponse.getData()).getData()).getId();
            if (HussarUtils.isEmpty((Object)identity)) {
                manifestEntry = ApiResponse.fail((String)"\u4e0a\u4f20\u5931\u8d25");
                return manifestEntry;
            }
            storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
            targetPath = Paths.get(storagePath, new String[]{functionType, pageType, identity});
            Files.createDirectories(targetPath, new FileAttribute[0]);
            zip = new ZipFile(zipPath.toFile());
            var10_22 = null;
            try {
                entries = zip.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    entryPath = targetPath.resolve(entry.getName());
                    if (!entryPath.normalize().startsWith(targetPath)) {
                        throw new SecurityException("\u975e\u6cd5\u6587\u4ef6\u8def\u5f84");
                    }
                    if (entry.isDirectory()) continue;
                    is = zip.getInputStream(entry);
                    var15_35 = null;
                    try {
                        Files.copy(is, entryPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    catch (Throwable var16_41) {
                        var15_35 = var16_41;
                        throw var16_41;
                    }
                    finally {
                        if (is == null) continue;
                        if (var15_35 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var16_40) {
                                var15_35.addSuppressed(var16_40);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (Throwable entries) {
                var10_22 = entries;
                throw entries;
            }
            finally {
                if (zip != null) {
                    if (var10_22 != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable entries) {
                            var10_22.addSuppressed(entries);
                        }
                    } else {
                        zip.close();
                    }
                }
            }
            paths = Files.walk(Paths.get(targetPath.toString(), new String[0]), new FileVisitOption[0]);
            var10_22 = null;
            try {
                jsonFiles = paths.filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$uploadTemplate$0(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).collect(Collectors.toList());
                for (Path jsonFile : jsonFiles) {
                    PageTemplateInfoServiceImpl.insertLineToJson(jsonFile, identity);
                }
            }
            catch (Throwable var11_29) {
                var10_22 = var11_29;
                throw var11_29;
            }
            finally {
                if (paths != null) {
                    if (var10_22 != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable var11_28) {
                            var10_22.addSuppressed(var11_28);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        catch (IOException e) {
            var7_9 = ApiResponse.fail((String)e.getMessage());
            return var7_9;
        }
        finally {
            ModelPageTemplateUtil.deleteTempFile(tempDir);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<ModelPageTemplate>> getTemplate(String functionType, String pageType) throws IOException {
        String storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate", functionType, pageType}).getLocalPath();
        ArrayList<ModelPageTemplate> modelPageTemplateList = new ArrayList<ModelPageTemplate>();
        File tempFile = new File(storagePath);
        if (!tempFile.exists() || !tempFile.isDirectory()) {
            return ApiResponse.success(new ArrayList());
        }
        try (Stream<Path> pathStream = Files.walk(Paths.get(storagePath, new String[0]), 1, new FileVisitOption[0]);){
            List directoryFiles = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(Paths.get(storagePath, new String[0]))).collect(Collectors.toList());
            for (Path directoryPath : directoryFiles) {
                ModelPageTemplate modelPageTemplate = new ModelPageTemplate();
                ArrayList<JSONObject> attributes = new ArrayList<JSONObject>();
                Stream<Path> jsonStream = Files.walk(directoryPath, 1, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    List jsonFiles = jsonStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path1 -> path1.toString().endsWith(".json")).collect(Collectors.toList());
                    for (Path jsonPath : jsonFiles) {
                        String json = org.apache.commons.io.FileUtils.readFileToString((File)jsonPath.toFile(), (Charset)StandardCharsets.UTF_8);
                        JSONObject jsonObject = JSON.parseObject((String)json);
                        if ("manifest.json".equals(jsonPath.getFileName().toString())) {
                            modelPageTemplate.setIdentity(jsonObject.getString("identity"));
                            modelPageTemplate.setTemplateName(jsonObject.getString("templateName"));
                            modelPageTemplate.setCover(jsonObject.getString("cover"));
                            continue;
                        }
                        if (HussarUtils.isNotEmpty((Object)jsonObject.getString("templateType")) && this.templateTypeRange.contains(jsonObject.getString("templateType"))) {
                            attributes.add(jsonObject);
                            continue;
                        }
                        if (!jsonPath.getFileName().toString().toLowerCase().contains("slave")) continue;
                        modelPageTemplate.setEditTableTemplates(jsonObject);
                    }
                    if (this.flowTypeRange.contains(functionType)) {
                        org.springframework.core.io.Resource[] bpmResources = SpringContextHolder.getApplicationContext().getResources("classpath*:/template/bpmTemplate.json");
                        JSONObject jsonObject = JSON.parseObject((String)IOUtils.toString((InputStream)bpmResources[0].getInputStream(), (Charset)StandardCharsets.UTF_8));
                        modelPageTemplate.setBpmTemplates(jsonObject);
                    }
                    modelPageTemplate.setAttributes(attributes);
                    modelPageTemplateList.add(modelPageTemplate);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonStream == null) continue;
                    if (throwable != null) {
                        try {
                            jsonStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jsonStream.close();
                }
            }
        }
        return ApiResponse.success(modelPageTemplateList);
    }

    @Override
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkTemplate(MultipartFile zipFile) throws IOException {
        CheckResult<PageTemplateInductsInfo> checkResult = new CheckResult<PageTemplateInductsInfo>();
        CheckInfo completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.fail(), -2);
        if (HussarUtils.isEmpty((Object)zipFile) || HussarUtils.isEmpty((Object)zipFile.getOriginalFilename())) {
            completeCheck.addInfos("\u6587\u4ef6\u4e3a\u7a7a", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        Path tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try (InputStream is = zipFile.getInputStream();){
            Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            completeCheck.addInfos("\u6587\u4ef6\u5904\u7406\u5931\u8d25", -2);
            checkResult.addCheckInfos(completeCheck);
            checkResult.setResult(-1);
            return ApiResponse.success(checkResult);
        }
        ModelPageTemplateUtil.validateDirectory(zipPath, checkResult);
        ModelPageTemplateUtil.deleteTempFile(tempDir);
        if (checkResult.getResult() == -1) {
            return ApiResponse.success(checkResult);
        }
        Long zipFileId = (Long)this.ossService.backgroundUpload(zipFile).getData();
        completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        PageTemplateInductsInfo pageTemplateInductsInfo = new PageTemplateInductsInfo();
        pageTemplateInductsInfo.setId(zipFileId.toString());
        checkResult.addCheckInfos(completeCheck);
        checkResult.setData(pageTemplateInductsInfo);
        return ApiResponse.success(checkResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<String> importTemplate(Long fileId) throws IOException {
        Object object;
        String storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
        MultipartFile zipFile = this.getMultipartFile(fileId);
        Path tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
        try {
            String pageType;
            String functionType;
            try {
                InputStream is = zipFile.getInputStream();
                object = null;
                try {
                    Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            ZipFile zip = new ZipFile(zipPath.toFile());
            object = null;
            try {
                ZipEntry manifestEntry;
                ZipEntry zipEntry = manifestEntry = HussarUtils.isEmpty((Object)zip.getEntry("manifest.json")) ? zip.getEntry("/manifest.json") : zip.getEntry("manifest.json");
                if (manifestEntry == null) {
                    ApiResponse apiResponse = ApiResponse.fail((String)"\u538b\u7f29\u5305\u7f3a\u5c11manifest\u6587\u4ef6");
                    return apiResponse;
                }
                try {
                    InputStream manifestStream = zip.getInputStream(manifestEntry);
                    Object object2 = null;
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode manifest = mapper.readTree(manifestStream);
                        functionType = manifest.get("functionType").asText();
                        pageType = manifest.get("pageType").asText();
                    }
                    catch (Throwable mapper) {
                        object2 = mapper;
                        throw mapper;
                    }
                    finally {
                        if (manifestStream != null) {
                            if (object2 != null) {
                                try {
                                    manifestStream.close();
                                }
                                catch (Throwable mapper) {
                                    ((Throwable)object2).addSuppressed(mapper);
                                }
                            } else {
                                manifestStream.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new IOException(e);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zip != null) {
                    if (object != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zip.close();
                    }
                }
            }
            if (HussarUtils.isEmpty((Object)functionType) || HussarUtils.isEmpty((Object)pageType)) {
                zip = ApiResponse.fail((String)"manifest\u6587\u4ef6\u7f3a\u5c11\u76f8\u5173\u53c2\u6570");
                return zip;
            }
            Path targetPath = Paths.get(storagePath, functionType, pageType, fileId.toString());
            Files.createDirectories(targetPath, new FileAttribute[0]);
            try (ZipFile zip2 = new ZipFile(zipPath.toFile());){
                Enumeration<? extends ZipEntry> entries = zip2.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    Path entryPath = targetPath.resolve(entry.getName());
                    if (!entryPath.normalize().startsWith(targetPath)) {
                        throw new SecurityException("\u975e\u6cd5\u6587\u4ef6\u8def\u5f84");
                    }
                    if (entry.isDirectory()) continue;
                    InputStream is = zip2.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        Files.copy(is, entryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            var10_12 = null;
            try (Stream<Path> paths = Files.walk(Paths.get(targetPath.toString(), new String[0]), new FileVisitOption[0]);){
                List jsonFiles = paths.filter(p -> p.toString().endsWith(".json")).collect(Collectors.toList());
                for (Path jsonFile : jsonFiles) {
                    PageTemplateInfoServiceImpl.insertLineToJson(jsonFile, String.valueOf(fileId));
                }
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            object = ApiResponse.fail((String)e.getMessage());
            return object;
        }
        finally {
            ModelPageTemplateUtil.deleteTempFile(tempDir);
        }
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public ApiResponse<String> editTemplateName(String functionType, String pageType, String identity, String templateName) {
        try {
            String storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
            String absolutePath = storagePath + "/" + functionType + "/" + pageType + "/" + identity.replace(".", "_") + "/manifest.json";
            String originalContent = this.readJsonFile(absolutePath);
            String newContent = this.updateJsonContent(originalContent, templateName);
            try (FileOutputStream fileOutputStream = new FileOutputStream(absolutePath);){
                fileOutputStream.write(newContent.getBytes());
            }
            catch (IOException e) {
                throw new HussarException(e.getMessage());
            }
        }
        catch (IOException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> deleteTemplate(String functionType, String pageType, String identity) throws IOException {
        String storagePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
        String absolutePath = storagePath + "/" + functionType + "/" + pageType + "/" + identity.replace(".", "_");
        Path path = Paths.get(absolutePath, new String[0]).normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            return ApiResponse.fail((String)("\u8def\u5f84\u4e0d\u5b58\u5728: " + path));
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return ApiResponse.fail((String)("\u8def\u5f84\u4e0d\u662f\u76ee\u5f55: " + path));
        }
        ModelPageTemplateUtil.deleteTempFile(path);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public String readJsonFile(String absolutePath) throws IOException {
        Path path = Paths.get(absolutePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + absolutePath);
        }
        List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    public String updateJsonContent(String originalJson, String templateName) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        Map jsonMap = (Map)mapper.readValue(originalJson, (JavaType)type);
        jsonMap.put("templateName", templateName);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonMap);
    }

    private static void insertLineToJson(Path jsonPath, String identity) throws IOException {
        String json = org.apache.commons.io.FileUtils.readFileToString((File)jsonPath.toFile(), (Charset)StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        jsonObject.put("identity", (Object)identity);
        org.apache.commons.io.FileUtils.writeStringToFile((File)jsonPath.toFile(), (String)jsonObject.toJSONString(), (Charset)StandardCharsets.UTF_8);
    }

    public MultipartFile getMultipartFile(Long ossFileId) {
        try {
            AttachmentManagerModel model = this.ossService.getModelById(ossFileId);
            String attachmentName = model.getAttachmentName();
            ApiResponse download = this.ossService.backgroundDownload(ossFileId);
            byte[] data = (byte[])download.getData();
            return new MockMultipartFile(attachmentName, data);
        }
        catch (Exception var10) {
            throw new BaseException((Throwable)var10);
        }
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    @Override
    public FormDesignResponse<Map<String, List<ModelPageManifest>>> listModelPages(String pageType) {
        ArrayList<ModelPageManifest> manifests = new ArrayList<ModelPageManifest>();
        String path = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
        this.findManifestFiles(new File(path), manifests);
        Map<String, List<ModelPageManifest>> functionTypeGroup = manifests.stream().filter(modelPageManifest -> modelPageManifest.getPageType().equals(pageType)).collect(Collectors.groupingBy(ModelPageManifest::getFunctionType));
        return FormDesignResponse.success(functionTypeGroup);
    }

    private void findManifestFiles(File dir, List<ModelPageManifest> manifestContents) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.findManifestFiles(file, manifestContents);
                    continue;
                }
                if (!file.isFile() || !file.getName().equals("manifest.json")) continue;
                try {
                    String content = org.apache.commons.io.FileUtils.readFileToString((File)file);
                    if (!HussarUtils.isNotEmpty((Object)content)) continue;
                    manifestContents.add((ModelPageManifest)JSONObject.parseObject((String)content, ModelPageManifest.class));
                }
                catch (IOException e) {
                    throw new HussarException();
                }
            }
        }
    }

    @Override
    public ResponseEntity<byte[]> downModelPages(List<ModelPageManifest> manifests) {
        Path tempDirectory;
        String templatePath = this.pathStrategy.resourcePathService().projectStore(new String[]{"modelPageTemplate"}).getLocalPath();
        try {
            tempDirectory = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new HussarException();
        }
        ArrayList<String> zips = new ArrayList<String>();
        for (ModelPageManifest manifest : manifests) {
            if (HussarUtils.isEmpty((Object)manifest.getIdentity())) continue;
            String sourcePath = FileUtil.posixPath((String[])new String[]{templatePath, manifest.getFunctionType(), manifest.getPageType(), String.valueOf(manifest.getIdentity())});
            String targetPath = FileUtil.posixPath((String[])new String[]{tempDirectory.toAbsolutePath().toString(), manifest.getFunctionType(), manifest.getPageType(), String.valueOf(manifest.getIdentity()), PageTemplateInfoServiceImpl.sanitizePath(manifest.getTemplateName()) + "_" + System.currentTimeMillis()});
            try {
                Files.createDirectories(Paths.get(targetPath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new HussarException();
            }
            File sourcePathFile = new File(sourcePath);
            File targetPathFile = new File(targetPath);
            if (!sourcePathFile.exists() || !targetPathFile.exists()) {
                throw new HussarException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String zipPath = String.format("%s.zip", targetPath);
            try {
                ZipUtil.zip(sourcePath, zipPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            zips.add(zipPath);
        }
        try {
            ResponseEntity<byte[]> responseEntity = ZipUtil.downloadZipFiles(zips);
            PageTemplateInfoServiceImpl.deleteDirectory(tempDirectory.toFile());
            return responseEntity;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> checkModelPages(MultipartFile zipFile) throws IOException {
        CheckInfo completeCheck;
        CheckResult<PageTemplateInductsInfo> checkResult;
        block90: {
            Throwable throwable;
            checkResult = new CheckResult<PageTemplateInductsInfo>();
            completeCheck = new CheckInfo(zipFile.getOriginalFilename() + CheckInfoEnum.COMPLETE.fail(), -2);
            if (HussarUtils.isEmpty((Object)zipFile) || HussarUtils.isEmpty((Object)zipFile.getOriginalFilename())) {
                completeCheck.addInfos("\u6587\u4ef6\u4e3a\u7a7a", -2);
                checkResult.addCheckInfos(completeCheck);
                checkResult.setResult(-1);
                return ApiResponse.success(checkResult);
            }
            Path tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
            Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getOriginalFilename()));
            try {
                Stream<Path> pathStream;
                block87: {
                    ApiResponse apiResponse;
                    block88: {
                        block89: {
                            List jsonFiles;
                            block84: {
                                block85: {
                                    block86: {
                                        try {
                                            throwable = null;
                                            try (InputStream is = zipFile.getInputStream();){
                                                Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
                                            }
                                            catch (Throwable throwable2) {
                                                throwable = throwable2;
                                                throw throwable2;
                                            }
                                        }
                                        catch (IOException e) {
                                            completeCheck.addInfos(zipFile.getOriginalFilename() + "\u6587\u4ef6\u5904\u7406\u5931\u8d25", -2);
                                            checkResult.addCheckInfos(completeCheck);
                                            checkResult.setResult(-1);
                                            ApiResponse apiResponse2 = ApiResponse.success(checkResult);
                                            ModelPageTemplateUtil.deleteTempFile(tempDir);
                                            return apiResponse2;
                                        }
                                        throwable = null;
                                        try (ZipFile zip = new ZipFile(zipPath.toFile(), Charset.forName("GBK"));){
                                            Enumeration<? extends ZipEntry> entries = zip.entries();
                                            while (entries.hasMoreElements()) {
                                                ZipEntry entry = entries.nextElement();
                                                Path targetPath = tempDir.resolve(zipPath.getFileName() + entry.getName());
                                                if (Files.exists(targetPath, new LinkOption[0])) {
                                                    throw new IOException("Duplicate file: " + targetPath);
                                                }
                                                if (entry.isDirectory() || entry.getName().endsWith("/")) {
                                                    Files.createDirectories(targetPath, new FileAttribute[0]);
                                                    continue;
                                                }
                                                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                                                InputStream is = zip.getInputStream(entry);
                                                Throwable throwable3 = null;
                                                try {
                                                    BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
                                                    Throwable throwable4 = null;
                                                    try {
                                                        int len;
                                                        byte[] buffer = new byte[4096];
                                                        while ((len = is.read(buffer)) > 0) {
                                                            bos.write(buffer, 0, len);
                                                        }
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable4 = throwable5;
                                                        throw throwable5;
                                                    }
                                                    finally {
                                                        if (bos == null) continue;
                                                        if (throwable4 != null) {
                                                            try {
                                                                bos.close();
                                                            }
                                                            catch (Throwable throwable6) {
                                                                throwable4.addSuppressed(throwable6);
                                                            }
                                                            continue;
                                                        }
                                                        bos.close();
                                                    }
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable3 = throwable7;
                                                    throw throwable7;
                                                }
                                                finally {
                                                    if (is == null) continue;
                                                    if (throwable3 != null) {
                                                        try {
                                                            is.close();
                                                        }
                                                        catch (Throwable throwable8) {
                                                            throwable3.addSuppressed(throwable8);
                                                        }
                                                        continue;
                                                    }
                                                    is.close();
                                                }
                                            }
                                        }
                                        catch (Throwable entries) {
                                            throwable = entries;
                                            throw entries;
                                        }
                                        Files.deleteIfExists(zipPath);
                                        pathStream = Files.walk(tempDir, new FileVisitOption[0]);
                                        throwable = null;
                                        jsonFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".zip")).filter(path -> !path.equals(tempDir)).collect(Collectors.toList());
                                        if (!HussarUtils.isEmpty(jsonFiles)) break block84;
                                        ModelPageTemplateUtil.deleteTempFile(tempDir);
                                        apiResponse = this.checkTemplate(zipFile);
                                        if (pathStream == null) break block85;
                                        if (throwable == null) break block86;
                                        try {
                                            pathStream.close();
                                        }
                                        catch (Throwable targetPath) {
                                            throwable.addSuppressed(targetPath);
                                        }
                                        break block85;
                                    }
                                    pathStream.close();
                                }
                                return apiResponse;
                            }
                            for (Path dir : jsonFiles) {
                                ModelPageTemplateUtil.validateDirectory(dir, checkResult);
                            }
                            if (checkResult.getResult() != -1) break block87;
                            apiResponse = ApiResponse.success(checkResult);
                            if (pathStream == null) break block88;
                            if (throwable == null) break block89;
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            break block88;
                        }
                        pathStream.close();
                    }
                    return apiResponse;
                }
                try {
                    if (pathStream != null) {
                        if (throwable != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            pathStream.close();
                        }
                    }
                    break block90;
                    {
                        catch (Throwable throwable11) {
                            try {
                                throwable = throwable11;
                                throw throwable11;
                            }
                            catch (Throwable throwable12) {
                                if (pathStream != null) {
                                    if (throwable != null) {
                                        try {
                                            pathStream.close();
                                        }
                                        catch (Throwable throwable13) {
                                            throwable.addSuppressed(throwable13);
                                        }
                                    } else {
                                        pathStream.close();
                                    }
                                }
                                throw throwable12;
                            }
                        }
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    completeCheck.addInfos(e.getMessage(), -2);
                    checkResult.addCheckInfos(completeCheck);
                    checkResult.setResult(-1);
                    throwable = ApiResponse.success(checkResult);
                    return throwable;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                completeCheck.addInfos(e.getMessage(), -2);
                checkResult.addCheckInfos(completeCheck);
                checkResult.setResult(-1);
                throwable = ApiResponse.success(checkResult);
                return throwable;
            }
            finally {
                ModelPageTemplateUtil.deleteTempFile(tempDir);
            }
        }
        Long zipFileId = (Long)this.ossService.backgroundUpload(zipFile).getData();
        completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        PageTemplateInductsInfo pageTemplateInductsInfo = new PageTemplateInductsInfo();
        pageTemplateInductsInfo.setId(zipFileId.toString());
        checkResult.addCheckInfos(completeCheck);
        checkResult.setData(pageTemplateInductsInfo);
        return ApiResponse.success(checkResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ApiResponse<String> importModelPages(Long fileId) throws IOException {
        MultipartFile zipFile = this.getMultipartFile(fileId);
        Path tempDir = Files.createTempDirectory("modelPageTemplate", new FileAttribute[0]);
        Path zipPath = tempDir.resolve(Objects.requireNonNull(zipFile.getName()));
        try {
            ApiResponse<String> entry;
            Throwable throwable;
            try {
                throwable = null;
                try (InputStream is = zipFile.getInputStream();){
                    Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
            }
            throwable = null;
            try (ZipFile zip = new ZipFile(zipPath.toFile(), Charset.forName("GBK"));){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    Path targetPath = tempDir.resolve(zipPath.getFileName() + entry.getName());
                    if (Files.exists(targetPath, new LinkOption[0])) {
                        throw new IOException("Duplicate file: " + targetPath);
                    }
                    if (entry.isDirectory() || entry.getName().endsWith("/")) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    InputStream inputStream = zip.getInputStream((ZipEntry)entry);
                    Throwable throwable3 = null;
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
                        Throwable throwable4 = null;
                        try {
                            int len;
                            byte[] buffer = new byte[4096];
                            while ((len = inputStream.read(buffer)) > 0) {
                                bos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (bos == null) continue;
                            if (throwable4 != null) {
                                try {
                                    bos.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            bos.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable3 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Throwable entries) {
                throwable = entries;
                throw entries;
            }
            Files.deleteIfExists(zipPath);
            try {
                throwable = null;
                try (Stream<Path> pathStream = Files.walk(tempDir, new FileVisitOption[0]);){
                    List jsonFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".zip")).filter(path -> !path.equals(tempDir)).collect(Collectors.toList());
                    if (HussarUtils.isEmpty(jsonFiles)) {
                        ModelPageTemplateUtil.deleteTempFile(tempDir);
                        entry = this.importTemplate(fileId);
                        return entry;
                    }
                    ArrayList<Object> fileIds = new ArrayList<Object>();
                    for (Path path2 : jsonFiles) {
                        MockMultipartFile multipartFile = new MockMultipartFile(path2.getFileName().toString().replace("/", ""), path2.getFileName().toString().replace("/", ""), null, Files.readAllBytes(path2));
                        fileIds.add(this.ossService.backgroundUpload((MultipartFile)multipartFile).getData());
                    }
                    Iterator<Object> iterator = fileIds.iterator();
                    while (iterator.hasNext()) {
                        Long l = (Long)iterator.next();
                        this.importTemplate(l);
                    }
                    return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                return ApiResponse.fail((String)e.getMessage());
            }
        }
        catch (IOException | IllegalArgumentException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public static void deleteDirectory(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                PageTemplateInfoServiceImpl.deleteDirectory(file);
            }
        }
        dir.delete();
    }

    public static String sanitizePath(String path) {
        return path.replaceAll("[\\\\/:*?\"<>|]", "_");
    }

    private static /* synthetic */ boolean lambda$uploadTemplate$0(Path p) {
        return p.toString().endsWith(".json");
    }
}

