/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataCellInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="DataCellInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class DataCellInfoServiceImpl
extends BaseFileServiceImpl<DataCellInfo>
implements DataCellInfoService {
    private final PathStrategyService pathStrategy;

    @Autowired
    public DataCellInfoServiceImpl(FileMappingService fileMappingService, FormDesignProperties speedCodeProperties, PathStrategyService pathStrategy) {
        this.fileMappingService = fileMappingService;
        this.formDesignProperties = speedCodeProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public void updateDataCell(DataCellInfo dataCellInfo) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        JSONObject newData = JSONObject.parseObject((String)dataCellInfo.getData());
        List newArray = newData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
        List oldArray = null;
        File file = new File(rootPath + this.fileMappingService.getDataPath(dataCellInfo.getId()));
        if (FileUtils.exists((File)file)) {
            JSONObject oldData = null;
            String oldStr = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (ToolUtil.isNotEmpty((Object)oldStr)) {
                oldData = JSONObject.parseObject((String)oldStr);
            }
            if (ToolUtil.isNotEmpty(oldData)) {
                oldArray = oldData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
            }
            if (ToolUtil.isNotEmpty(oldArray)) {
                for (JSONObject oldJsonObject : oldArray) {
                    String oldFieldName = oldJsonObject.getString("name");
                    for (JSONObject newJsonObject : newArray) {
                        String newFieldName = newJsonObject.getString("name");
                        if (!oldFieldName.equals(newFieldName)) continue;
                        for (Map.Entry stringObjectEntry : newJsonObject.entrySet()) {
                            String entry = (String)stringObjectEntry.getKey();
                            if (!ToolUtil.isNotEmpty((Object)oldJsonObject.get((Object)entry)) || "dataType".equals(entry) || "isPrimary".equals(entry) || "comment".equals(entry) || "sourceDatModelId".equals(entry) || "sourceFieldName".equals(entry)) continue;
                            newJsonObject.put(entry, oldJsonObject.get((Object)entry));
                        }
                    }
                }
            }
        }
        String newDataStr = JSON.toJSONString((Object)newData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        dataCellInfo.setData(newDataStr);
        Object jsonObject = JSONObject.parse((String)dataCellInfo.getData());
        if (ToolUtil.isEmpty((Object)jsonObject)) {
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
        } else {
            FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8", (boolean)false);
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
    }
}

