/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/filetree"})
public class FileTreeController {
    private final FileTreeService fileTreeService;

    @Autowired
    public FileTreeController(FileTreeService fileTreeService) {
        this.fileTreeService = fileTreeService;
    }

    @GetMapping
    public FormDesignResponse<List<JSONObject>> getFileTree() throws IOException, LcdpException {
        return this.fileTreeService.getFileTree("#");
    }

    @GetMapping(value={"/getFileTreeCrossApp"})
    public List<Map<String, Object>> getFileTreeCrossApp() throws IOException, LcdpException {
        return this.fileTreeService.getFileTreeCrossApp("#");
    }

    @GetMapping(value={"/getFileTreeByType"})
    public FormDesignResponse<JSONArray> getFileTreeByType(String type) throws IOException, LcdpException {
        return this.fileTreeService.getFileTreeByType(type);
    }
}

