/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.factory.ModifierFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.MobilePageInfo;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationDataInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.impl.AggregationPageInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.model.SysQuoteRelation;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="aggregationDataInfoServiceImpl")
public class AggregationDataInfoServiceImpl
implements AggregationDataInfoService {
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private IndexStorageLockService indexStorageLockService;
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired
    private DataInfoService dataInfoService;
    private static final Logger logger = LoggerFactory.getLogger(AggregationPageInfoServiceImpl.class);

    @Override
    public FormDesignResponse<MobilePageInfo> updateAllDataInfo(MobilePageInfo pageInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(pageInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        if (ToolUtil.isEmpty((Object)((Object)pageInfo)) || ToolUtil.isEmpty((Object)pageInfo.getName())) {
            logger.error("\u6587\u4ef6\uff08{}\uff09\u7684name\u4f20\u9012\u4e3a\u7a7a\uff0cpageInfo\u5185\u5bb9\u4e3a\uff1a{}", (Object)pageInfo.getId(), (Object)JSONObject.toJSONString((Object)((Object)pageInfo)));
        }
        if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
            if (ToolUtil.isNotEmpty((Object)JSONObject.parseObject((String)pageInfo.getData()).getJSONObject("slots"))) {
                JSONArray components = JSONObject.parseObject((String)pageInfo.getData()).getJSONObject("slots").getJSONArray("default");
                this.registerLocalComponents(components);
            }
            this.disposeQuoteRelation(pageInfo.getId(), pageInfo.getData());
            this.pageInfoService.updateFile(pageInfo);
        } else {
            this.pageInfoService.updateFileMeta(pageInfo);
        }
        return new FormDesignResponse();
    }

    @Override
    public void disposeQuoteRelation(String referResId, String data) {
        ArrayList<SysQuoteRelation> sysQuoteRelations = new ArrayList<SysQuoteRelation>();
        JSONObject parseObject = JSONObject.parseObject((String)data);
        JSONObject resObject = (JSONObject)parseObject.get((Object)"resReferencesIndex");
        HashMap resMap = new HashMap();
        for (Map.Entry entry : resObject.entrySet()) {
            resMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : resMap.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            obj.remove((Object)"id");
            SysQuoteRelation sysQuoteRelation = (SysQuoteRelation)JSONObject.toJavaObject((JSON)obj, SysQuoteRelation.class);
            sysQuoteRelation.setReferResId(referResId);
            sysQuoteRelations.add(sysQuoteRelation);
        }
        this.sysQuoteRelationService.deleteAndAddQuote(referResId, sysQuoteRelations);
    }

    @Override
    public void updateFileMeta(MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(mobilePageInfo.getType())).cascadeEdit((BaseFile)mobilePageInfo);
        this.dataInfoService.updateFileMeta(mobilePageInfo);
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            formDesignResponse.setErrorCode(400);
            formDesignResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return formDesignResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !user.getId().equals(userId))) {
            formDesignResponse.setErrorCode(403);
            formDesignResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }

    private void registerLocalComponents(JSONArray components) {
        if (HussarUtils.isEmpty((Object)components)) {
            components = new JSONArray();
        }
        for (Object component : components) {
            JSONObject slots;
            JSONObject componentObj = (JSONObject)component;
            String componentName = componentObj.getString("name");
            if (componentName.contains("com.jxdinfo.uniLocal")) {
                ClazzFactory.register((String)componentName, (String)"com.jxdinfo.hussar.formdesign.uniui.uni.UniCommon");
                ModifierFactory.addComponentEventModifier((String)componentName, (String)"click", (String)"native");
                StyleFactory.addComponentClassName((String)componentName, (String)(".jxd_ins_" + componentName.replace("com.jxdinfo.uniLocal.JXD", "")));
            }
            if ((slots = componentObj.getJSONObject("slots")) == null) continue;
            for (Map.Entry entry : slots.entrySet()) {
                if (!(entry.getValue() instanceof JSONArray)) continue;
                this.registerLocalComponents((JSONArray)entry.getValue());
            }
        }
    }
}

