/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.filemapping.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.MetaConfigVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MetaFileService;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/filemapping"})
public class FileMappingController {
    private final FileMappingService fileMappingService;
    @Autowired
    private MetaFileService metaFileService;

    @Autowired
    public FileMappingController(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    @GetMapping
    public FormDesignResponse<Map<String, String>> getFileMapping() throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse.setData((Object)this.fileMappingService.fileMappingCache());
        return formDesignResponse;
    }

    @GetMapping(value={"/path"})
    public FormDesignResponse<String> getFileRelativePath(String id) throws IOException, LcdpException {
        FormDesignResponse stringFormDesignResponse = new FormDesignResponse();
        stringFormDesignResponse.setData((Object)this.fileMappingService.getFormatPath(id));
        return stringFormDesignResponse;
    }

    @DeleteMapping
    public FormDesignResponse evictFileMappingCache() {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        this.fileMappingService.fileMappingCacheEvict();
        formDesignResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return formDesignResponse;
    }

    @RequestMapping(value={"/updatePageVersion"})
    public FormDesignResponse<MetaConfigVo> updateVersion(@RequestParam String id) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse.setData((Object)this.metaFileService.updateMetaVersionById(id));
        return formDesignResponse;
    }
}

