/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.db.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFile;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsScriptFileVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsCommonService;
import com.jxdinfo.hussar.formdesign.extend.util.FileComparatorUtil;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.extend.util.PathComparatorUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.BaseFileDataBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class ExtendJsCommonServiceDbImpl
extends BaseFileDataBaseServiceImpl<ExtendJsFileInfo>
implements ExtendJsCommonService {
    @Override
    public List<ExtendJsPathVO> listJs(String codePath, String projectPath, String pageType) throws LcdpException, IOException {
        ArrayList<ExtendJsPathVO> pathVOList = new ArrayList<ExtendJsPathVO>();
        Map<String, String> registeredJs = this.getRegisteredJs(pageType);
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        String sourcePath = projectPath + (String)paths.get("EXTEND_JS_PATH_AB");
        List<String> sourceList = ParsingUtil.getFilePath(sourcePath, ".js");
        Map<String, List<ExtendJsFile>> mapList = ParsingUtil.groupByFile(sourceList, sourcePath);
        for (Map.Entry<String, List<ExtendJsFile>> entry : mapList.entrySet()) {
            ExtendJsPathVO pathVO = new ExtendJsPathVO();
            String[] keys = entry.getKey().split(",");
            pathVO.setLabel(keys[0]);
            pathVO.setPath(keys[1]);
            pathVO.setParentPath(keys[2]);
            ArrayList<ExtendJsFileVO> jsFileList = new ArrayList<ExtendJsFileVO>();
            for (ExtendJsFile jsFile : entry.getValue()) {
                ExtendJsFileVO fileVO = ParsingUtil.getJsFileInformation(sourcePath + jsFile.getFilePath());
                fileVO.setSize(jsFile.getSize());
                fileVO.setFileName(jsFile.getFileName());
                fileVO.setFilePath(jsFile.getFilePath().replaceAll("\\\\", "/"));
                if (registeredJs.containsKey(jsFile.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""))) {
                    fileVO.setState(1);
                } else {
                    fileVO.setState(0);
                }
                jsFileList.add(fileVO);
            }
            jsFileList.sort(new FileComparatorUtil());
            pathVO.setListFile(jsFileList);
            pathVOList.add(pathVO);
        }
        ParsingUtil.createBlankDirectory(pathVOList);
        pathVOList.sort(new PathComparatorUtil());
        ParsingUtil.addBlankRootDirectory(pathVOList);
        return ParsingUtil.recursiveFilePath("0", pathVOList);
    }

    private Map<String, String> getRegisteredJs(String pageType) {
        String fileType;
        HashMap<String, String> map = new HashMap<String, String>();
        switch (pageType) {
            case "WebPage": {
                fileType = "FrontScript";
                break;
            }
            case "UniPage": {
                fileType = "UniFrontScript";
                break;
            }
            case "MobilePage": {
                fileType = "MobileFrontScript";
                break;
            }
            default: {
                throw new HussarException("\u672a\u627e\u5230\u6307\u5b9a\u7c7b\u578b\u6269\u5c55\u6269\u5c55\u811a\u672c\uff1a" + pageType);
            }
        }
        List jsFiles = this.sysMidFileCodeService.list((Wrapper)((LambdaQueryWrapper)this.sysMidFileCodeService.lambdaQueryWrapper().eq(SysMidFileCode::getType, (Object)fileType)).eq(SysMidFileCode::getMetaFlag, (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)jsFiles)) {
            for (SysMidFileCode jsFile : jsFiles) {
                ExtendJsFileInfo fileInfo = (ExtendJsFileInfo)((Object)JSON.parseObject((String)jsFile.getData(), ExtendJsFileInfo.class));
                String filePath = fileInfo.getFilePath().replaceAll("\\\\", "").replaceAll("/", "");
                map.put(filePath, null);
            }
        }
        return map;
    }

    @Override
    public ExtendJsCheckVO getErrorForJs(String projectPath, String filePath, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        filePath = this.getPath(projectPath, pageType) + filePath;
        return ParsingUtil.checkMethod(filePath);
    }

    @Override
    public RegisterJsScriptFileVO listMethodByStorage(String projectPath, ExtendJsFileInfo fileInfo, String pageType) {
        RegisterJsScriptFileVO fileVO = this.getJsFileByInfo(fileInfo);
        if (StringUtil.isNotBlank((CharSequence)fileVO.getFilePath())) {
            String sourcePath = this.getPath(projectPath, pageType);
            String filePath = sourcePath + fileVO.getFilePath();
            fileVO.setExists(ParsingUtil.fileExistsByPath(filePath));
        }
        return fileVO;
    }

    @Override
    public RegisterJsScriptFileVO listMethodByPath(String projectPath, String filePath, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        String absolutePath = this.getPath(projectPath, pageType) + filePath;
        return ParsingUtil.getJsFileDetail(absolutePath, filePath);
    }

    @Override
    public RegisterJsScriptFileVO listMethodByPathAndStorage(String projectPath, String filePath, ExtendJsFileInfo fileInfo, String pageType) throws LcdpException {
        filePath = filePath.replaceAll("%", "/");
        String absolutePath = this.getPath(projectPath, pageType) + filePath;
        RegisterJsScriptFileVO sourceFileVO = ParsingUtil.getJsFileDetail(absolutePath, filePath);
        RegisterJsScriptFileVO registeredFileVO = this.getJsFileByInfo(fileInfo);
        return ParsingUtil.compareFile(sourceFileVO, registeredFileVO);
    }

    @Override
    public String getJsContentByPath(String projectPath, String filePath, String pageType) throws LcdpException {
        String content;
        filePath = filePath.replaceAll("%", "/");
        String sourcePath = this.getPath(projectPath, pageType);
        filePath = sourcePath + filePath;
        try {
            content = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return content;
    }

    @Override
    public boolean checkExists(String filePath, String pageType) throws LcdpException, IOException {
        String fileType;
        switch (pageType) {
            case "WebPage": {
                fileType = "FrontScript";
                break;
            }
            case "UniPage": {
                fileType = "UniFrontScript";
                break;
            }
            case "MobilePage": {
                fileType = "MobileFrontScript";
                break;
            }
            default: {
                throw new com.jxdinfo.hussar.core.exception.HussarException("\u6682\u4e0d\u652f\u6301 " + pageType + " \u7c7b\u578b\u7684\u9875\u9762");
            }
        }
        List metaFiles = this.sysMidFileCodeService.list((Wrapper)((LambdaQueryWrapper)this.sysMidFileCodeService.lambdaQueryWrapper().eq(SysMidFileCode::getType, (Object)fileType)).eq(SysMidFileCode::getMetaFlag, (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)metaFiles)) {
            for (SysMidFileCode metaFile : metaFiles) {
                String registeredPath;
                ExtendJsFileInfo fileInfo = (ExtendJsFileInfo)((Object)JSON.parseObject((String)metaFile.getData(), ExtendJsFileInfo.class));
                String sourcePath = filePath.replaceAll("\\\\", "/");
                if (!HussarUtils.equals((Object)sourcePath, (Object)(registeredPath = fileInfo.getFilePath().replaceAll("\\\\", "/")))) continue;
                return true;
            }
        }
        return false;
    }

    private RegisterJsScriptFileVO getJsFileByInfo(ExtendJsFileInfo fileInfo) {
        RegisterJsScriptFileVO fileVO = (RegisterJsScriptFileVO)((Object)BeanUtil.copyProperties((Object)((Object)fileInfo), RegisterJsScriptFileVO.class));
        fileVO = fileVO == null ? new RegisterJsScriptFileVO() : fileVO;
        String data = fileVO.getData();
        if (StringUtil.isNotBlank((CharSequence)data)) {
            RegisterJsScriptFileVO fileDTO = (RegisterJsScriptFileVO)((Object)JsonUtil.parse((String)data, RegisterJsScriptFileVO.class));
            fileVO.setMethods(fileDTO != null ? fileDTO.getMethods() : new ArrayList<RegisterJsMethodVO>());
        }
        fileVO.setData(null);
        return fileVO;
    }

    private String getPath(String projectPath, String pageType) {
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        return projectPath + (String)paths.get("EXTEND_JS_PATH_AB");
    }
}

