/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.common;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFile;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueData;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueEvent;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueInfo;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVuePathVO;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueProp;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendCustomVueCommonService;
import com.jxdinfo.hussar.formdesign.extend.util.ExtendCustomVueUtil;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.extend.util.VueFileComparatorUtil;
import com.jxdinfo.hussar.formdesign.extend.util.VuePathComparatorUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotDataBaseStorage.class})
public class ExtendCustomVueCommonImpl
extends BaseFileServiceImpl<ExtendCustomVueInfo>
implements ExtendCustomVueCommonService {
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public List<ExtendCustomVuePathVO> listVue(String projectPath, String pageType) throws LcdpException, IOException {
        ArrayList<ExtendCustomVuePathVO> pathVOList = new ArrayList<ExtendCustomVuePathVO>();
        List<String> metaList = null;
        String sourcePath = null;
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        String metaPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        metaList = ParsingUtil.getFilePath(metaPath, (String)paths.get("META_TYPE"));
        sourcePath = projectPath + (String)paths.get("EXTEND_VUE_PATH_AB");
        Map<String, String> vueList = ExtendCustomVueUtil.getRegisteredVuedPath(metaList);
        List<String> sourceList = ParsingUtil.getFilePath(sourcePath, ".vue");
        Map<String, List<ExtendJsFile>> mapList = ParsingUtil.groupByFile(sourceList, sourcePath);
        for (Map.Entry<String, List<ExtendJsFile>> entry : mapList.entrySet()) {
            ExtendCustomVuePathVO pathVO = new ExtendCustomVuePathVO();
            String[] keys = entry.getKey().split(",");
            pathVO.setLabel(keys[0]);
            pathVO.setPath(keys[1]);
            pathVO.setParentPath(keys[2]);
            ArrayList<ExtendCustomVueVO> vueFileList = new ArrayList<ExtendCustomVueVO>();
            for (ExtendJsFile jsFile : entry.getValue()) {
                ExtendCustomVueVO fileVO = ExtendCustomVueUtil.getVueFileInformation(sourcePath + jsFile.getFilePath());
                fileVO.setSize(jsFile.getSize());
                fileVO.setFileName(jsFile.getFileName());
                fileVO.setFilePath(jsFile.getFilePath().replaceAll("\\\\", "/"));
                if (vueList.containsKey(jsFile.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""))) {
                    fileVO.setState(1);
                } else {
                    fileVO.setState(0);
                }
                vueFileList.add(fileVO);
            }
            vueFileList.sort(new VueFileComparatorUtil());
            pathVO.setListFile(vueFileList);
            pathVOList.add(pathVO);
        }
        ExtendCustomVueUtil.createBlankDirectory(pathVOList);
        pathVOList.sort(new VuePathComparatorUtil());
        ExtendCustomVueUtil.addBlankRootDirectory(pathVOList);
        return ExtendCustomVueUtil.recursiveFilePath("0", pathVOList);
    }

    @Override
    public String getVueContentByPath(String projectPath, String filePath, String pageType) throws LcdpException {
        String content;
        filePath = filePath.replaceAll("%", "/");
        String sourcePath = ExtendCustomVueCommonImpl.getPath(projectPath, pageType);
        filePath = sourcePath + filePath;
        try {
            content = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return content;
    }

    @Override
    public boolean checkExists(String filePath, String pageType) throws LcdpException, IOException {
        String metaSuffix = null;
        String fileType = null;
        switch (pageType) {
            case "CustomPage": {
                metaSuffix = ".cpd.meta";
                fileType = "CustomPage";
                break;
            }
            case "UniCustomPage": {
                metaSuffix = ".ucpd.meta";
                fileType = "UniCustomPage";
                break;
            }
            default: {
                throw new HussarException("\u6682\u4e0d\u652f\u6301 " + pageType + " \u7c7b\u578b\u7684\u9875\u9762");
            }
        }
        String metaPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        List<String> metaList = ParsingUtil.getFilePath(metaPath, metaSuffix);
        try {
            for (String path : metaList) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendCustomVueInfo fileInfo = (ExtendCustomVueInfo)((Object)JSON.parseObject((String)content, ExtendCustomVueInfo.class));
                if (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals(fileType)) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return false;
    }

    @Override
    public ExtendCustomVueVO getCustomVueDetail(String projectPath, ExtendCustomVueInfo fileInfo, String pageType) {
        if (fileInfo == null) {
            return null;
        }
        ExtendCustomVueVO fileVO = (ExtendCustomVueVO)((Object)BeanUtil.copyProperties((Object)((Object)fileInfo), ExtendCustomVueVO.class));
        fileVO = fileVO != null ? fileVO : new ExtendCustomVueVO();
        String data = fileVO.getData();
        if (StringUtil.isNotBlank((CharSequence)data)) {
            ExtendCustomVueData fileData = (ExtendCustomVueData)JsonUtil.parse((String)data, ExtendCustomVueData.class);
            ExtendCustomVueVO fileVOTwo = (ExtendCustomVueVO)((Object)BeanUtil.copyProperties((Object)fileData, ExtendCustomVueVO.class));
            fileVO.setProps(fileVOTwo != null ? fileVOTwo.getProps() : new ArrayList<ExtendCustomVueProp>());
            fileVO.setEvents(fileVOTwo != null ? fileVOTwo.getEvents() : new ArrayList<ExtendCustomVueEvent>());
            String sourcePath = ExtendCustomVueCommonImpl.getPath(projectPath, pageType);
            String filePath = sourcePath + fileVO.getFilePath();
            fileVO.setExists(ParsingUtil.fileExistsByPath(filePath));
        }
        fileVO.setData(null);
        return fileVO;
    }

    private static String getPath(String projectPath, String pageType) {
        Map paths = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths();
        return projectPath + (String)paths.get("EXTEND_VUE_PATH_AB");
    }
}

