/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.move.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static String readFile(String path) throws FileNotFoundException {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return laststr.toString();
    }

    public static JSONObject readOneFile(String filePath) throws FileNotFoundException {
        try {
            if (StringUtils.isEmpty((CharSequence)filePath)) {
                return null;
            }
            String jsonContent = FileUtils.getJsContent((String)filePath);
            if (StringUtils.isNotEmpty((CharSequence)jsonContent)) {
                return JSON.parseObject((String)jsonContent);
            }
            return null;
        }
        catch (JSONException e) {
            logger.warn("\u5b58\u5728\u6587\u4ef6\u65e0\u6cd5\u8f6c\u6362\u4e3ajson\u683c\u5f0f");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void copyFiletoTargetPath(String path, String targetPath) throws IOException {
        File source = new File(path);
        File[] files = FileUtils.listFiles((File)source);
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            FileUtil.copyFile(files[i], targetPath);
        }
    }

    private static void copyFile(File source, String dest) throws IOException {
        File destfile = new File(dest);
        if (!FileUtils.exists((File)destfile)) {
            FileUtils.forceMkdir((File)destfile);
        }
        if (FileUtils.isDirectory((File)source)) {
            FileUtil.folderDeal(source, dest);
        } else if (FileUtils.isFile((File)source)) {
            FileUtil.fileDeal(source, dest);
        }
    }

    private static void folderDeal(File source, String dest) throws IOException {
        File file = new File(dest + "\\" + source.getName());
        FileUtils.forceMkdir((File)file);
        File[] files = FileUtils.listFiles((File)source);
        if (files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            FileUtil.copyFile(files[i], file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fileDeal(File source, String dest) throws IOException {
        try (FileOutputStream fos = null;
             FileInputStream fis = new FileInputStream(source);){
            int len;
            File dfile = new File(dest + "\\" + source.getName());
            if (!FileUtils.exists((File)dfile)) {
                FileUtils.createNewFile((File)dfile);
            }
            fos = new FileOutputStream(dfile);
            byte[] b = new byte[1024];
            while ((len = fis.read(b)) != -1) {
                fos.write(b, 0, len);
            }
        }
    }

    public static void deleteFolder(File folder) throws IOException {
        if (!FileUtils.exists((File)folder)) {
            return;
        }
        File[] files = FileUtils.listFiles((File)folder);
        if (files != null) {
            for (File file : files) {
                if (FileUtils.isDirectory((File)file)) {
                    FileUtil.deleteFolder(file);
                    continue;
                }
                FileUtils.delete((File)file);
            }
        }
        FileUtils.delete((File)folder);
    }

    private FileUtil() {
    }

    public static String getFileExtension(File file) {
        String extension = "";
        try {
            if (file != null && FileUtils.exists((File)file)) {
                String name = file.getName();
                extension = name.substring(name.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            extension = "";
        }
        return extension;
    }

    public static List<File> getFiles(String path, List<File> fileList) {
        File file = new File(path);
        if (FileUtils.isDirectory((File)file)) {
            File[] files;
            for (File fileIndex : files = FileUtils.listFiles((File)file)) {
                if (FileUtils.isDirectory((File)fileIndex)) {
                    FileUtil.getFiles(fileIndex.getPath(), fileList);
                    continue;
                }
                fileList.add(fileIndex);
            }
        }
        return fileList;
    }

    public static Map<String, List<File>> getLayeredFiles(String path, Map<String, List<File>> levelFileMap, Integer level, String pathTemp) {
        File file = new File(path);
        if (FileUtils.isDirectory((File)file)) {
            File[] files;
            for (File fileIndex : files = FileUtils.listFiles((File)file)) {
                String filePath = fileIndex.getPath();
                String catalog = filePath.substring(pathTemp.length(), filePath.lastIndexOf(File.separator));
                String key = level + ":" + catalog;
                List<File> temp = levelFileMap.get(key);
                if (ToolUtil.isNotEmpty(temp)) {
                    levelFileMap.get(key).add(fileIndex);
                } else {
                    LinkedList<File> list = new LinkedList<File>();
                    list.add(fileIndex);
                    levelFileMap.put(level + ":" + catalog, list);
                }
                if (!FileUtils.isDirectory((File)fileIndex)) continue;
                FileUtil.getLayeredFiles(fileIndex.getPath(), levelFileMap, level + 1, pathTemp);
            }
        }
        return levelFileMap;
    }

    public static Boolean generateJsonFile(List<JSONObject> jsonObjectList, List<String> urlList) throws IOException {
        LinkedList<String> writeFileUrlList = new LinkedList<String>();
        if (ToolUtil.isNotEmpty(jsonObjectList)) {
            for (int i = 0; i < jsonObjectList.size(); ++i) {
                String createFilePath = urlList.get(i);
                File testFile = new File(createFilePath);
                File fileParent = testFile.getParentFile();
                if (!FileUtils.exists((File)fileParent)) {
                    FileUtils.forceMkdir((File)fileParent);
                }
                if (!FileUtils.exists((File)testFile)) {
                    FileUtils.createNewFile((File)testFile);
                }
                String path = testFile.getPath();
                writeFileUrlList.add(path);
            }
        }
        return FileUtil.writeFile(writeFileUrlList, jsonObjectList);
    }

    public static Boolean writeFile(List<String> writeFileUrlList, List<JSONObject> jsonObjectList) throws IOException {
        return FileUtils.writeFile(writeFileUrlList, jsonObjectList);
    }
}

