/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.publishrecord.model.SysPublishRecord;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.preview.service.PagePreviewService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class PageInfoServiceImpl
extends BaseFileServiceImpl<PageInfo>
implements PageInfoService {
    @Qualifier(value="MicroAppInfoServiceImpl")
    @Autowired
    public MicroAppInfoService microAppInfoService;
    @Autowired
    public PagePreviewService pagePreviewService;
    @Autowired
    public ISysPublishRecordService sysPublishRecordService;
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);

    @Autowired
    public PageInfoServiceImpl(FormDesignProperties speedCodeProperties) {
        this.formDesignProperties = speedCodeProperties;
    }

    @Override
    public PageInfoNode getPageInfoNodeFromPageToRoot(String id) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)this.get(id);
        String cnName = pageInfo.getDesc();
        String enName = pageInfo.getName();
        boolean isPage = "WebPage".equals(pageInfo.getType());
        PageInfoNode pageInfoNode = new PageInfoNode(enName, cnName, isPage, pageInfo.getId());
        String parentId = pageInfo.getParentId();
        if (ToolUtil.isNotEmpty((Object)parentId) && !"#".equals(parentId)) {
            pageInfoNode.parent = this.getPageInfoNodeFromPageToRoot(parentId);
            pageInfoNode.parent.child = pageInfoNode;
        }
        return pageInfoNode;
    }

    @Override
    public String getWebUrl(String pageId) throws LcdpException {
        String url;
        String path = this.pagePreviewService.getPreviewPath(pageId);
        if (path == null) {
            url = null;
        } else {
            String devUser = VfgModeTool.isModularization() ? String.format("?tcode=%s&dev_user=%s&isResetRouter=true", BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getId()) : "?isResetRouter=true";
            url = String.format("%s%s%s", this.formDesignProperties.getWebUrl(), FileUtil.posixPath((String[])new String[]{"#", this.pathStrategy.vuePathService().prefix(), path}), devUser);
        }
        return url;
    }

    @Override
    public String getMobileUrl(String pageId) throws IOException, LcdpException {
        String url = this.formDesignProperties.getMobileUrl();
        String path = this.fileMappingService.getFormatPath(pageId);
        if (path != null && url != null) {
            String devUser = VfgModeTool.isModularization() ? String.format("?tcode=%s&dev_user=%s&isResetRouter=true", BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getId()) : "?isResetRouter=true";
            url = String.format("%s%s%s", url, FileUtil.posixPath((String[])new String[]{"#", this.pathStrategy.vuePathService().prefix(), path}), devUser);
        }
        return url;
    }

    @Override
    public Map<String, Object> getAllReferencesAndErrorsList() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> refMap = new HashMap<String, Object>();
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        File code = new File(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndCodePath());
        this.iteratorFile(refMap, errorMap, code, "code");
        File pageTemplate = new File(FileUtil.posixPath((String[])new String[]{((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath()}));
        this.iteratorFile(refMap, errorMap, pageTemplate, "pageTemplate");
        File component = new File(FileUtil.posixPath((String[])new String[]{((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndComponentsPath()}));
        this.iteratorFile(refMap, errorMap, component, "components");
        map.put("references", refMap);
        map.put("crossReferErrors", errorMap);
        return map;
    }

    @Override
    public List<String> getPageState(List<String> ids) throws IOException {
        ArrayList<String> idList = new ArrayList<String>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty(ids)) {
            wrapper.in(SysPublishRecord::getSourceId, new Object[0]);
        }
        List publishRecords = this.sysPublishRecordService.list(wrapper);
        ArrayList<String> functionList = new ArrayList<String>();
        HashSet<String> moduleList = new HashSet<String>();
        HashSet<String> bpmList = new HashSet<String>();
        HashSet<String> secondScriptList = new HashSet<String>();
        for (SysPublishRecord publishRecord : publishRecords) {
            if ("0".equals(publishRecord.getSourceType())) {
                idList.add(publishRecord.getSourceId());
                continue;
            }
            functionList.add(publishRecord.getSourceId());
        }
        File file = new File(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().getProjectAndCodePath());
        this.iteratorFileGetModuleId(file, functionList, moduleList, bpmList, secondScriptList);
        if (ToolUtil.isNotEmpty(ids)) {
            ArrayList<String> moduleIds = new ArrayList<String>(moduleList);
            block1: for (String string : ids) {
                for (String string2 : moduleIds) {
                    if (!string.equals(string2)) continue;
                    idList.add(string2);
                    continue block1;
                }
            }
            ArrayList<String> bpmIds = new ArrayList<String>(bpmList);
            block3: for (String id : ids) {
                for (String bpmId : bpmIds) {
                    if (!id.equals(bpmId)) continue;
                    idList.add(bpmId);
                    continue block3;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(secondScriptList);
            block5: for (String string : ids) {
                for (String s : arrayList) {
                    if (!string.equals(s)) continue;
                    idList.add(s);
                    continue block5;
                }
            }
        } else {
            idList.addAll(new ArrayList<String>(moduleList));
            idList.addAll(new ArrayList<String>(bpmList));
            idList.addAll(new ArrayList<String>(secondScriptList));
        }
        return idList;
    }

    private void iteratorFile(Map<String, Object> refMap, Map<String, Object> errorMap, File file, String type) throws IOException {
        if (FileUtils.exists((File)file)) {
            if (FileUtils.isDirectory((File)file)) {
                File[] files = FileUtils.listFiles((File)file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(refMap, errorMap, childFile, type);
                    }
                }
            } else {
                JSONObject jsonObject = null;
                try {
                    jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                }
                catch (JSONException e) {
                    return;
                }
                if ("code".equals(type)) {
                    JSONArray referArray = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"references")));
                    JSONArray errorArray = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"crossReferErrors")));
                    if (ToolUtil.isNotEmpty((Object)referArray)) {
                        JSONObject o = (JSONObject)referArray.get(0);
                        String id = o.get((Object)"referPath").toString().split("\\.")[0];
                        refMap.put(id, referArray);
                    }
                } else if ("pageTemplate".equals(type)) {
                    JSONArray errorArray;
                    JSONArray referArray;
                    JSONObject dataObj = JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.get((Object)"data")));
                    if (ToolUtil.isEmpty((Object)dataObj)) {
                        return;
                    }
                    Object references = dataObj.get((Object)"references");
                    Object crossReferErrors = dataObj.get((Object)"crossReferErrors");
                    if (ToolUtil.isNotEmpty((Object)references) && ToolUtil.isNotEmpty((Object)(referArray = JSON.parseArray((String)JSON.toJSONString((Object)references))))) {
                        refMap.put(file.getName().split("\\.")[0], referArray);
                    }
                    if (ToolUtil.isNotEmpty((Object)crossReferErrors) && ToolUtil.isNotEmpty((Object)(errorArray = JSON.parseArray((String)JSON.toJSONString((Object)crossReferErrors))))) {
                        errorMap.put(file.getName().split("\\.")[0], errorArray);
                    }
                } else if ("components".equals(type) && ToolUtil.isNotEmpty((Object)jsonObject) && ToolUtil.isNotEmpty((Object)jsonObject.get((Object)"references"))) {
                    JSONObject referObj = JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.get((Object)"references")));
                    if (ToolUtil.isEmpty((Object)referObj)) {
                        return;
                    }
                    Object refer = referObj.get((Object)"refer");
                    if (ToolUtil.isNotEmpty((Object)refer)) {
                        refMap.put(file.getName().split("\\.")[0], refer);
                    }
                }
            }
        }
    }

    private void iteratorFileGetModuleId(File file, List<String> functionList, Set<String> moduleList, Set<String> bpmList, Set<String> secondScriptList) throws IOException {
        if (FileUtils.exists((File)file)) {
            boolean isPublish;
            JSONObject jsonObject;
            if (file.isDirectory()) {
                File[] files;
                for (File childFile : files = FileUtils.listFiles((File)file)) {
                    this.iteratorFileGetModuleId(childFile, functionList, moduleList, bpmList, secondScriptList);
                }
            } else if (file.getName().endsWith(".dbd")) {
                JSONObject jsonObject2 = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                JSONArray operationsArray = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject2.get((Object)"operations")));
                for (Object o : operationsArray) {
                    JSONObject operation = (JSONObject)o;
                    for (String s : functionList) {
                        if (!operation.get((Object)"id").equals(s)) continue;
                        String id = jsonObject2.get((Object)"id").toString();
                        moduleList.add(id);
                        return;
                    }
                }
            } else if (file.getName().contains(".dbd") && file.getName().endsWith(".meta")) {
                boolean isPublish2;
                JSONObject jsonObject3 = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                if (ToolUtil.isNotEmpty((Object)jsonObject3.get((Object)"isPublished")) && ToolUtil.isNotEmpty((Object)(isPublish2 = ((Boolean)jsonObject3.get((Object)"isPublished")).booleanValue())) && isPublish2) {
                    moduleList.add(jsonObject3.get((Object)"id").toString());
                }
            } else if (file.getName().startsWith("bpm_") && file.getName().endsWith(".meta")) {
                JSONObject jsonObject4 = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                Object version = jsonObject4.get((Object)"version");
                if (ToolUtil.isNotEmpty((Object)version)) {
                    bpmList.add(jsonObject4.get((Object)"id").toString());
                }
            } else if ((file.getName().contains(".jsd") || file.getName().contains(".cpd") || file.getName().contains(".mjsd") || file.getName().contains(".mcpd") || file.getName().contains(".ujsd") || file.getName().contains(".ucpd") || file.getName().contains(".csd") || file.getName().contains(".ucsd") || file.getName().contains(".mcsd")) && file.getName().endsWith(".meta") && ToolUtil.isNotEmpty((Object)(jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"))).get((Object)"isPublished")) && ToolUtil.isNotEmpty((Object)(isPublish = ((Boolean)jsonObject.get((Object)"isPublished")).booleanValue())) && isPublish) {
                secondScriptList.add(jsonObject.get((Object)"id").toString());
            }
        }
    }
}

