/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.AdjustWorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelCopyDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.SaveInfoDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.WorkflowDumpDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl.BaseFileDataBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.upgrade.StandardExtendPropertiesApiService;
import com.jxdinfo.hussar.workflow.upgrade.StandardFormAuthApiService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class WorkFlowDataBaseServiceImpl
extends BaseFileDataBaseServiceImpl<WorkflowInfo>
implements WorkflowService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    @Autowired(required=false)
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private StandardFormAuthApiService formAuthApiService;
    @Resource
    private StandardExtendPropertiesApiService extendPropertiesApiService;
    public static String SYS_ACT_EXTENDS = "sysActExtends.json";

    @Override
    public void createWorkflow(WorkflowInfo workflowInfo) throws LcdpException, IOException {
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        workFlowList.add(this.dealData(workflowInfo));
        ApiResponse apiResponse = this.godAxeModelService.saveFileOnly(workFlowList);
        if (!apiResponse.isSuccess()) {
            throw new LcdpException(LcdpExceptionEnum.ERROR, apiResponse.getMsg());
        }
        this.sysMidFileCodeService.saveFile((BaseFile)workflowInfo);
    }

    @Override
    public void updateWorkFlowFile(WorkflowInfo workflowInfo) throws IOException, LcdpException {
        JSONObject mainFileData = JSON.parseObject((String)workflowInfo.getData());
        mainFileData.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        workflowInfo.setVersion(this.get(workflowInfo.getId()) != null ? ((WorkflowInfo)((Object)this.get(workflowInfo.getId()))).getVersion() : null);
        this.godAxeModelService.saveWorkflow(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId(), false, false);
        this.sysMidFileCodeService.updateFile((BaseFile)workflowInfo);
    }

    @Override
    public void deleteBpmFile(String identity, String organId, boolean forced) {
        ApiResponse apiResponse = this.godAxeModelService.deleteProcess(identity, organId, forced);
        if (!apiResponse.isSuccess()) {
            throw new HussarException(Integer.valueOf(apiResponse.getCode()), apiResponse.getMsg());
        }
    }

    @Override
    public FormDesignResponse<Object> adjustProcess(AdjustWorkflowInfo workflowInfo) throws IOException, LcdpException {
        String id = workflowInfo.getId();
        String appCode = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishToEnvStartLog((String)id, (String)appCode, (String)"\u5de5\u4f5c\u6d41");
        }
        workflowInfo.setVersion(this.get(id) != null ? ((WorkflowInfo)((Object)this.get(id))).getVersion() : null);
        WorkFlow oldWorkFlow = this.godAxeModelService.getFileByProcessKeyAndProcessIdAndOrganId(workflowInfo.getIdentity(), workflowInfo.getProcessTag());
        if (!workflowInfo.getOverride()) {
            // empty if block
        }
        JSONObject object = JSON.parseObject((String)workflowInfo.getData());
        object.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        workflowInfo.setVersion(oldWorkFlow.getVersion());
        AdjustWorkflowInfo workflowInfoBak = (AdjustWorkflowInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)workflowInfo)), AdjustWorkflowInfo.class));
        this.sysMidFileCodeService.updateFile((BaseFile)workflowInfoBak);
        try {
            ApiResponse obj = this.godAxeModelService.updateProcess(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId());
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            if (!obj.isSuccess()) {
                speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + obj.getMsg());
                speedCodeResponse.setErrorCode(14160 == obj.getCode() ? obj.getCode() : 500);
                if (VfgModeTool.isRemote()) {
                    PublishLogUtil.writePublishErrorLog((String)id, (String)appCode, (String)speedCodeResponse.getErrorMsg());
                    PublishLogUtil.writePublishFailLog((String)id, (String)appCode, (String)"\u5de5\u4f5c\u6d41");
                }
                return speedCodeResponse;
            }
            if (obj.getData() instanceof Map && "14160".equals(((Map)obj.getData()).get("code"))) {
                speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + ((Map)obj.getData()).get("msg"));
                speedCodeResponse.setErrorCode(14160);
                if (VfgModeTool.isRemote()) {
                    PublishLogUtil.writePublishErrorLog((String)id, (String)appCode, (String)speedCodeResponse.getErrorMsg());
                    PublishLogUtil.writePublishFailLog((String)id, (String)appCode, (String)"\u5de5\u4f5c\u6d41");
                }
                return speedCodeResponse;
            }
        }
        catch (Exception e) {
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + e.getMessage());
            speedCodeResponse.setErrorCode(500);
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)appCode, (String)speedCodeResponse.getErrorMsg());
                PublishLogUtil.writePublishFailLog((String)id, (String)appCode, (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishSuccessLog((String)id, (String)appCode, (String)"\u5de5\u4f5c\u6d41", (String)"2");
        }
        return new FormDesignResponse();
    }

    @Override
    public void moveWorkFlow(String id, String parentId, String newName, String newDesc, String category) {
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(id);
        metaFile.setParentId(parentId);
        mainFile.setParentId(parentId);
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFileData.put("name", (Object)newName);
        }
        metaFileData.put("category", (Object)category);
        this.sysMidFileCodeService.updateById((Object)metaFile);
        this.sysMidFileCodeService.updateById((Object)mainFile);
    }

    @Override
    public List<String> copyWorkFlow(List<ModelCopyDto> list) throws LcdpException, IOException {
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (ModelCopyDto modelCopyDto : list) {
            String processKey;
            String id = modelCopyDto.getId();
            String parentId = modelCopyDto.getParentId();
            String newId = modelCopyDto.getNewId();
            String newName = modelCopyDto.getNewName();
            String category = modelCopyDto.getCategory();
            String newDesc = modelCopyDto.getNewDesc();
            SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(id);
            SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
            String oldProcessKey = JSONObject.parseObject((String)metaFile.getData()).getString("identity");
            if (!oldProcessKey.equals(processKey = newDesc)) {
                this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
            }
            WorkflowInfo workflowInfo = (WorkflowInfo)((Object)super.get(id));
            WorkFlow workFlow = this.dealData(workflowInfo);
            workFlow.setIdentity(processKey);
            workFlow.setName(newName);
            workFlowList.add(workFlow);
            SysMidFileCode newMainFile = (SysMidFileCode)JSON.parseObject((String)JSON.toJSONString((Object)mainFile), SysMidFileCode.class);
            SysMidFileCode newMetaFile = (SysMidFileCode)JSON.parseObject((String)JSON.toJSONString((Object)metaFile), SysMidFileCode.class);
            newMetaFile.setId(null);
            newMetaFile.setFileId(newId);
            newMetaFile.setParentId(parentId);
            newMainFile.setId(null);
            newMainFile.setFileId(newId);
            newMainFile.setParentId(parentId);
            if (HussarUtils.isNotEmpty((Object)newDesc)) {
                newMetaFile.setName(newName);
                newMainFile.setName(newDesc);
            }
            JSONObject jsonObject = JSON.parseObject((String)newMetaFile.getData());
            jsonObject.put("parentId", (Object)parentId);
            jsonObject.put("id", (Object)newId);
            if (newName != null && !"".equals(newName)) {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null && !"".equals(newDesc)) {
                jsonObject.put("eName", (Object)newDesc);
                jsonObject.put("identity", (Object)newDesc);
            }
            if (category != null && !"".equals(category)) {
                jsonObject.put("category", (Object)category);
            }
            jsonObject.put("version", (Object)"0");
            String content = newMainFile.getData();
            content = content.replaceAll(id, newId);
            JSONObject wfdJsonObject = JSON.parseObject((String)content);
            JSONObject props = (JSONObject)wfdJsonObject.get((Object)"props");
            if (newDesc != null && !"".equals(newDesc)) {
                props.put("identity", (Object)newDesc);
            }
            newMainFile.setData(JSON.toJSONString((Object)wfdJsonObject));
            this.sysMidFileCodeService.save((Object)newMetaFile);
            this.sysMidFileCodeService.save((Object)newMainFile);
            processKeys.add(jsonObject.getString("identity"));
        }
        this.godAxeModelService.saveFileOnly(workFlowList);
        return processKeys;
    }

    @Override
    public List<String> publishWorkflowOnOrgan(List<ModelCopyDto> list) throws LcdpException, IOException {
        return null;
    }

    @Override
    public WorkFlow queryFlowMeta(String processKey, String version) throws IOException, LcdpException {
        Integer ver = null;
        if (HussarUtils.isNotEmpty((Object)version)) {
            ver = Integer.valueOf(version);
        }
        return this.godAxeModelService.getFileByProcessKeyAndVersion(processKey, ver);
    }

    @Override
    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) throws IOException, LcdpException {
        return this.godAxeModelService.queryFlowVersion(processKey);
    }

    @Override
    public ApiResponse<?> checkAndSaveWorkFlowDataAndMeta(SaveInfoDto saveInfoDto) throws IOException, LcdpException {
        WorkflowInfo workflowInfo = saveInfoDto.getWorkflowInfo();
        String saveType = saveInfoDto.getSaveType();
        WorkFlow workFlow = this.dealData(workflowInfo);
        ApiResponse apiResponse = this.godAxeModelService.saveWorkflowMetaAndData(workFlow, saveType);
        return apiResponse;
    }

    @Override
    public ApiResponse<String> setMainVersion(String processKey, String processVersion) throws IOException, LcdpException {
        return this.godAxeModelService.setMainVersion(processKey, processVersion, null);
    }

    @Override
    public ApiResponse<String> queryNextVersion(String processKey) {
        return this.godAxeModelService.queryNextVersion(processKey);
    }

    @Override
    public FormDesignResponse<Map> checkProcessKey(List<String> processKeys) {
        List workFlow = this.godAxeModelService.getFilesByProcessKeys(processKeys);
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            for (WorkFlow flow : workFlow) {
                if (!processKeys.contains(flow.getIdentity())) continue;
                map.put(flow.getIdentity(), "\u6d41\u7a0b\u6807\u8bc6\u5df2\u5b58\u5728");
            }
            return FormDesignResponse.fail(map, (String)"");
        }
        return new FormDesignResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportProcess(WorkflowDumpDto workflowDumpDto, HttpServletResponse response) throws Exception {
        File file = null;
        String fileId = workflowDumpDto.getFileId();
        String tenantCode = workflowDumpDto.getTenantCode();
        String name = workflowDumpDto.getName();
        String exportPath = this.getExportPath(fileId);
        String environmentPath = "offline";
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put("processKey", workflowDumpDto.getProcessKey());
        String zipPath = exportPath + File.separator + environmentPath + File.separator + tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ".hussar";
        ArrayList<File> files = new ArrayList<File>();
        File zip = new File(zipPath);
        File zipParent = zip.getParentFile();
        if (!zipParent.exists()) {
            zipParent.mkdirs();
        }
        try {
            byte[] meta;
            file = Files.createTempDirectory("processExport" + fileId, new FileAttribute[0]).toFile();
            String processKey = workflowDumpDto.getProcessKey();
            Integer version = workflowDumpDto.getVersion();
            File workflow = new File(file.getAbsolutePath() + File.separator + "workflow");
            try {
                FileUtils.forceMkdir((File)workflow);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List actFormAuthList = new ArrayList();
            List extendProperties = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)processKey) && HussarUtils.isNotEmpty((Object)version)) {
                BpmResponseResult extendPropertiesListResult;
                JSONArray extendPropertiesResult;
                BpmResponseResult actFormAuthListResult = this.formAuthApiService.actFormAuthExportData(processKey, version);
                JSONArray actFormAuthResult = actFormAuthListResult.getResult();
                if (!actFormAuthResult.isEmpty()) {
                    actFormAuthList = JSON.parseArray((String)actFormAuthResult.getJSONArray(0).toJSONString(), SysActFormAuth.class);
                }
                if (!(extendPropertiesResult = (extendPropertiesListResult = this.extendPropertiesApiService.actExtendPropertiesExportData(processKey, version)).getResult()).isEmpty()) {
                    extendProperties = JSON.parseArray((String)extendPropertiesResult.getJSONArray(0).toJSONString(), SysActExtendProperties.class);
                }
            } else {
                throw new Exception("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (HussarUtils.isNotEmpty(actFormAuthList)) {
                meta = SerializeUtils.serialize(actFormAuthList);
                String formAuth = workflow + File.separator + "sysActFormAuths.json";
                File formAuthFile = new File(formAuth);
                FileUtils.writeByteArrayToFile((File)formAuthFile, (byte[])meta);
                files.add(formAuthFile);
            }
            if (HussarUtils.isNotEmpty(extendProperties)) {
                meta = SerializeUtils.serialize(extendProperties);
                String actExtend = workflow + File.separator + SYS_ACT_EXTENDS;
                File actExtendFile = new File(actExtend);
                FileUtils.writeByteArrayToFile((File)actExtendFile, (byte[])meta);
                files.add(actExtendFile);
            }
            String wfd = this.sysMidFileCodeService.getMainFile(fileId).getData();
            byte[] myByte = wfd.getBytes("UTF-8");
            String wfdPath = file.getAbsolutePath() + File.separator + "god_axe" + File.separator + workflowDumpDto.getName();
            File wfdPathFile = new File(wfdPath);
            FileUtils.writeByteArrayToFile((File)wfdPathFile, (byte[])myByte);
            files.add(wfdPathFile);
            String meta2 = this.sysMidFileCodeService.getMetaFile(fileId).getData();
            byte[] metaByte = meta2.getBytes("UTF-8");
            String metaPath = file.getAbsolutePath() + File.separator + "god_axe" + File.separator + workflowDumpDto.getName() + ".meta";
            File metaPathFile = new File(metaPath);
            FileUtils.writeByteArrayToFile((File)metaPathFile, (byte[])metaByte);
            files.add(metaPathFile);
            String p = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath() + File.separator + workflowDumpDto.getModelName();
            byte[] pathByte = p.getBytes("UTF-8");
            String Filepath = workflow + File.separator + "path";
            File FilepathFile = new File(Filepath);
            FileUtils.writeByteArrayToFile((File)FilepathFile, (byte[])pathByte);
            files.add(FilepathFile);
            byte[] metaJson = SerializeUtils.serialize(metaMap);
            String metaJsonPath = workflow + File.separator + "meta.json";
            File metaJsonPathFile = new File(metaJsonPath);
            FileUtils.writeByteArrayToFile((File)metaJsonPathFile, (byte[])metaJson);
            files.add(metaJsonPathFile);
            String newFileName = URLEncoder.encode(tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ".hussar", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("UTF-8");
            FileOutputStream fous = new FileOutputStream(zip);
            ZipOutputStream zipOut = new ZipOutputStream(fous);
            WorkFlowDataBaseServiceImpl.zipFile(files, zipOut);
            zipOut.close();
            fous.close();
            try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(zipPath));
                 BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = ((InputStream)fis).read(buffer)) != -1) {
                    ((OutputStream)toClient).write(buffer, 0, bytesRead);
                }
                ((OutputStream)toClient).flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null && file.exists()) {
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)file);
                    org.apache.commons.io.FileUtils.forceDelete((File)zip);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getExportPath(String id) {
        String uploadPath = FileUtil.posixPath((String[])new String[]{this.hussarConfig.getFileUploadPath(), "processExport", id});
        File loadPath = new File(uploadPath);
        if (!loadPath.exists()) {
            loadPath.mkdirs();
        }
        return uploadPath;
    }

    public static void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            WorkFlowDataBaseServiceImpl.zipFile(file, outputStream);
        }
    }

    public static void zipFile(File inputFile, ZipOutputStream ouputStream) {
        if (inputFile.exists()) {
            if (inputFile.isFile()) {
                try (FileInputStream in = new FileInputStream(inputFile);
                     BufferedInputStream bins = new BufferedInputStream(in, 512);){
                    int nNumber;
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        WorkFlowDataBaseServiceImpl.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> importProcess(MultipartFile file, String fileId, String processKey) throws IOException, LcdpException, ClassNotFoundException {
        HashMap<String, Object> returnMap;
        block5: {
            File temp = null;
            returnMap = new HashMap<String, Object>();
            try {
                InputStream inputStream = file.getInputStream();
                temp = Files.createTempDirectory("processImport" + fileId, new FileAttribute[0]).toFile();
                File tempFile = new File(temp.getAbsolutePath() + File.separator + fileId + ".zip");
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)(temp.getAbsolutePath() + File.separator));
                this.importProcessToOffline(fileId, temp, returnMap, processKey);
            }
            catch (Exception e) {
                returnMap.put("status", false);
                returnMap.put("msg", e.toString());
                if (!ToolUtil.isNotEmpty((Object)temp) || !temp.exists()) break block5;
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)temp);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!((Boolean)returnMap.get("status")).booleanValue()) {
            return ApiResponse.fail((String)returnMap.get("msg").toString());
        }
        return ApiResponse.success(returnMap);
    }

    @Override
    public ApiResponse<?> checkForStandardWorkflow(WorkflowInfo workflowInfo) {
        WorkFlow workFlow = this.dealData(workflowInfo);
        return this.godAxeModelService.checkForStandardWorkflow(workFlow);
    }

    private void importProcessToOffline(String fileId, File temp, Map<String, Object> returnMap, String processKey) throws Exception {
        File axe = new File(temp.getAbsolutePath() + File.separator + "god_axe");
        WorkFlow workFlow = this.importWorkFlow(temp, fileId, processKey);
        returnMap.put("status", true);
        returnMap.put("workflow", workFlow);
    }

    private WorkFlow importWorkFlow(File temp, String fileId, String processKey) throws IOException, LcdpException, ClassNotFoundException {
        String exportProcessKey;
        File workflow = new File(temp.getAbsolutePath());
        File projectStore = new File(temp.getAbsolutePath());
        File projectStoreFile = org.apache.commons.io.FileUtils.getFile((File)projectStore, (String[])new String[0]);
        File[] files = projectStoreFile.listFiles();
        try {
            for (File item : files) {
                File[] oldProjectStore;
                byte[] projectStoreBytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)item);
                File pathFile = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{"path"});
                byte[] pathByte = org.apache.commons.io.FileUtils.readFileToByteArray((File)pathFile);
                String path = new String(pathByte);
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((oldProjectStore = file.listFiles()) == null || oldProjectStore.length <= 0) continue;
                for (File value : oldProjectStore) {
                    if (!value.getName().equals(item.getName())) continue;
                    boolean flag = value.delete();
                    if (flag) {
                        try (FileOutputStream fos = new FileOutputStream(value);){
                            fos.write(projectStoreBytes, 0, projectStoreBytes.length);
                            fos.flush();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("\u5220\u9664\u5931\u8d25");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File metaTempFile = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{processKey + ".meta"});
        byte[] metaTempFileByte = org.apache.commons.io.FileUtils.readFileToByteArray((File)metaTempFile);
        String metaTemp = new String(metaTempFileByte, StandardCharsets.UTF_8);
        WorkFlow workFlow = (WorkFlow)JSONObject.parseObject((String)metaTemp, WorkFlow.class);
        File formAuth = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{"sysActFormAuths.json"});
        File actExtends = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{SYS_ACT_EXTENDS});
        File metaFile = new File(temp + File.separator + "meta.json");
        if (!metaFile.exists()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5305\u9519\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
        }
        byte[] meta = new byte[]{};
        try {
            meta = org.apache.commons.io.FileUtils.readFileToByteArray((File)metaFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
        if (metaMap == null) {
            throw new IllegalArgumentException("meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        String string = exportProcessKey = metaMap.get("processKey") == null ? "" : metaMap.get("processKey").toString();
        if (!exportProcessKey.equals(processKey)) {
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u4e0d\u662f\u4e00\u4e2a\u6d41\u7a0b");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(processKey);
        try {
            if (formAuth.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)formAuth);
                List actFormAuthList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.formAuthApiService.actFormAuthBatchImport(actFormAuthList);
                org.apache.commons.io.FileUtils.forceDelete((File)formAuth);
            }
            if (actExtends.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)actExtends);
                List actExtendPropertiesList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.extendPropertiesApiService.actExtendPropertiesImport(actExtendPropertiesList);
                org.apache.commons.io.FileUtils.forceDelete((File)actExtends);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workFlow;
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        workFlow.setVersion(workflowService.getVersion());
        workFlow.setAppId(workflowService.getAppId());
        workFlow.setAppName(workflowService.getAppName());
        workFlow.setCategory(AppContextUtil.getServiceName());
        workFlow.setWorkflowStyle(workflowService.getWorkflowStyle());
        workFlow.setProcessTag(workflowService.getProcessTag());
        workFlow.setProcessTagName(workflowService.getProcessTagName());
        if (workflowService instanceof AdjustWorkflowInfo) {
            workFlow.setForcePublish(((AdjustWorkflowInfo)workflowService).getForcePublish());
        }
        if (HussarUtils.isNotEmpty((Object)workflowService.getAppId()) && this.hussarBaseAppMixBoService != null) {
            if (AppContextUtil.isExtension()) {
                workflowService.setAppId(AppContextUtil.getAppId());
                workFlow.setAppId(workflowService.getAppId());
            }
            MixAppInfoVo mixAppInfoVo = this.hussarBaseAppMixBoService.getMixAppInfo(Long.valueOf(workflowService.getAppId()));
            if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)mixAppInfoVo.getAppEnglishName()) && mixAppInfoVo.getAppEnglishName().endsWith("_extension")) {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName().substring(0, mixAppInfoVo.getAppEnglishName().lastIndexOf("_")));
            } else {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName());
            }
        }
        return workFlow;
    }
}

