/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggretionModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/moduleinfo"})
public class ModuleInfoController {
    private final ModuleInfoService moduleInfoService;
    private final FormDesignProperties formDesignProperties;
    private final IndexStorageLockService indexStorageLockService;
    @Autowired
    AggretionModuleInfoService aggretionModuleInfoService;
    private final FileTreeService fileTreeService;

    @Autowired
    public ModuleInfoController(ModuleInfoService moduleInfoService, FormDesignProperties formDesignProperties, IndexStorageLockService indexStorageLockService, FileTreeService fileTreeService) {
        this.moduleInfoService = moduleInfoService;
        this.formDesignProperties = formDesignProperties;
        this.indexStorageLockService = indexStorageLockService;
        this.fileTreeService = fileTreeService;
    }

    @PostMapping(value={"/add"})
    public FormDesignResponse<String> addDataInfo(@RequestBody ModuleInfo moduleInfo) throws IOException, LcdpException {
        return this.moduleInfoService.createDirectory(moduleInfo);
    }

    @PostMapping(value={"/addBatch"})
    public FormDesignResponse<String> addDataInfoBatch(@RequestBody List<ModuleInfo> moduleInfoList) throws IOException, LcdpException {
        return this.moduleInfoService.createDirectoryBatch(moduleInfoList);
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<ModuleInfo> updateDataInfo(@RequestBody ModuleInfo moduleInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(moduleInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.aggretionModuleInfoService.editDirectory(moduleInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/del"})
    public FormDesignResponse<ModuleInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse<ModuleInfo> formDesignResponse = new FormDesignResponse<ModuleInfo>();
        try {
            formDesignResponse = this.aggretionModuleInfoService.deleteDataInfo(id);
        }
        catch (LcdpException e) {
            formDesignResponse.setErrorCode(e.getLcdpExceptionEnum().getCode());
            formDesignResponse.setErrorMsg(e.getLcdpExceptionEnum().getMsg());
            return formDesignResponse;
        }
        return formDesignResponse;
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse<Map<String, Object>> copyDirectory(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse<Map<String, Object>> formDesignResponse = new FormDesignResponse<Map<String, Object>>();
        try {
            formDesignResponse = this.aggretionModuleInfoService.copyDirectory(operateFileVO);
        }
        catch (LcdpException e) {
            formDesignResponse.setErrorCode(e.getLcdpExceptionEnum().getCode());
            formDesignResponse.setErrorMsg(e.getLcdpExceptionEnum().getMsg());
            return formDesignResponse;
        }
        return formDesignResponse;
    }

    @PostMapping(value={"/move"})
    public FormDesignResponse<ModuleInfo> moveDirectory(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(operateFileVO.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        try {
            this.aggretionModuleInfoService.moveDirectory(operateFileVO);
        }
        catch (LcdpException e) {
            formDesignResponse.setErrorCode(e.getLcdpExceptionEnum().getCode());
            formDesignResponse.setErrorMsg(e.getLcdpExceptionEnum().getMsg());
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }
}

