/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.FileResourceOccupyInfo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/fileLock"})
public class FileLockManagerController {
    @Autowired
    private FileLockManagerService fileLockManagerService;

    @PostMapping(value={"/setResouceOccupyLock"})
    public ApiResponse<FileLockInfoVo> setFileLock(@RequestBody FileResourceOccupyInfo occupyInfo) {
        return this.fileLockManagerService.setFileLockContainCheck(occupyInfo);
    }

    @GetMapping(value={"/manuallyCloseOccupyLock"})
    public ApiResponse<Boolean> manuallyCloseLock(@RequestParam(value="id") String resourceId) {
        return this.fileLockManagerService.manuallyCloseLock(resourceId);
    }

    @GetMapping(value={"/operateResouceCheck"})
    public ApiResponse<FileLockInfoVo> operateResouceCheck(@RequestParam(value="id") String resourceId, @RequestParam(value="resourceType") String type) {
        return this.fileLockManagerService.operateResouceCheck(resourceId, type);
    }

    @GetMapping(value={"/delayOccupyLock"})
    public ApiResponse<List<String>> delayLock(@RequestParam(value="ids") String ids) {
        return this.fileLockManagerService.delayLock(Arrays.asList(ids.split(",")));
    }

    @GetMapping(value={"/getOccupyLockInfoById"})
    public ApiResponse<FileLockInfoVo> getOccupyLockInfo(@RequestParam(value="id") String resourceId) {
        return this.fileLockManagerService.getOccupyLockInfo(resourceId);
    }

    @GetMapping(value={"/closeOccupyLockForceByResourceType"})
    public ApiResponse<FileLockInfoVo> closeOccupyLockForceByResourceType(@RequestParam(value="id") String resourceId, @RequestParam(value="resourceType") String type) {
        return this.fileLockManagerService.closeOccupyLockForceByResourceType(resourceId, type);
    }

    @GetMapping(value={"/closeOccupyLockForce"})
    public ApiResponse<FileLockInfoVo> closeOccupyLockForce(@RequestParam(value="id") String resourceId) {
        return this.fileLockManagerService.closeOccupyLockForce(resourceId);
    }

    @GetMapping(value={"/getExpiryDate"})
    public ApiResponse<Long> getExpiryDate() {
        return this.fileLockManagerService.getExpiryDate();
    }
}

