/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.MobilePageInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationDataInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataInfoService;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/mobileinfo"})
public class DataInfoController {
    private final DataInfoService dataInfoService;
    private final AggregationDataInfoService aggregationDataInfoService;

    @Autowired
    public DataInfoController(DataInfoService dataInfoService, AggregationDataInfoService aggregationDataInfoService) {
        this.dataInfoService = dataInfoService;
        this.aggregationDataInfoService = aggregationDataInfoService;
    }

    @PostMapping(value={"/add"})
    @ExceptionCatcher
    public FormDesignResponse<String> addDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        String version = this.dataInfoService.create(mobilePageInfo);
        FormDesignResponse pageInfoFormDesignResponse = new FormDesignResponse();
        pageInfoFormDesignResponse.setData((Object)version);
        return pageInfoFormDesignResponse;
    }

    @PostMapping(value={"/frame"})
    @ExceptionCatcher
    public FormDesignResponse<MobilePageInfo> saveFrame(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        this.dataInfoService.saveFrame(mobilePageInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/frame/publish"})
    @ExceptionCatcher
    public FormDesignResponse<Void> publishFrame(@RequestBody Map<String, String> idMap) throws IOException, LcdpException {
        this.dataInfoService.publishFrame(idMap);
        return new FormDesignResponse();
    }

    @GetMapping(value={"/frame"})
    @ExceptionCatcher
    public FormDesignResponse<MobilePageInfo> getFrameData(@RequestParam String id) throws IOException, LcdpException, ParseException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        stringSpeedCodeResponse.setData((Object)this.dataInfoService.updateFrameJson(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/package"})
    @ExceptionCatcher
    public FormDesignResponse<Void> packageToJQX(@RequestBody Map<String, String> pubMap) throws Exception {
        FormDesignResponse<Void> response = "3".equals(pubMap.get("pubType")) ? this.dataInfoService.packageToJQX(pubMap) : this.dataInfoService.putPathToJQX(pubMap);
        return response;
    }

    @RequestMapping(value={"/home"})
    @ExceptionCatcher
    public FormDesignResponse<Void> setHomePage(@RequestParam String id) throws Exception {
        FormDesignResponse response = new FormDesignResponse();
        this.dataInfoService.setHomePage(id);
        response.setErrorCode(200);
        return response;
    }

    @PostMapping(value={"/data/meta"})
    public FormDesignResponse<MobilePageInfo> updateAllDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        return this.aggregationDataInfoService.updateAllDataInfo(mobilePageInfo);
    }

    @PostMapping(value={"/save/pages"})
    public FormDesignResponse<MobilePageInfo> saveMultiPageInfo(@RequestBody List<MobilePageInfo> mobilePageInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty(mobilePageInfo)) {
            for (MobilePageInfo pageInfo : mobilePageInfo) {
                if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
                    this.dataInfoService.updateFile(pageInfo);
                    continue;
                }
                this.dataInfoService.updateFileMeta(pageInfo);
            }
        }
        return new FormDesignResponse();
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<MobilePageInfo> updateDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        this.aggregationDataInfoService.updateFileMeta(mobilePageInfo);
        return new FormDesignResponse();
    }

    @GetMapping
    public FormDesignResponse<MobilePageInfo> getDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        stringSpeedCodeResponse.setData(this.dataInfoService.get(id));
        return stringSpeedCodeResponse;
    }
}

