/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.FileOperEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.factory.ModifierFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationPageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.model.SysQuoteRelation;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import com.jxdinfo.hussar.view.service.IHussarViewManagementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AggregationPageInfoServiceImp")
public class AggregationPageInfoServiceImpl
implements AggregationPageInfoService {
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private IndexStorageLockService indexStorageLockService;
    @Autowired
    private FileLockManagerService lockManagerService;
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    @Autowired(required=false)
    private ISysResManageService resManageService;
    @Autowired(required=false)
    private ISysPublishRecordService sysPublishRecordService;
    @Autowired(required=false)
    ISysTemplatePrintInfoService iSysTemplatePrintInfoService;
    @Autowired
    IHussarViewManagementService hussarViewManagementService;
    private static final Logger logger = LoggerFactory.getLogger(AggregationPageInfoServiceImpl.class);

    @Override
    public FormDesignResponse<PageInfo> updateAllDataInfo(PageInfo pageInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        ApiResponse<FileLockInfoVo> response = this.lockManagerService.checkLock(pageInfo.getId(), pageInfo.getReferResourceIds());
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (!response.isSuccess()) {
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData(response.getData());
            return formDesignResponse;
        }
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(pageInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        if (ToolUtil.isEmpty((Object)pageInfo) || ToolUtil.isEmpty((Object)pageInfo.getName())) {
            logger.error("\u6587\u4ef6\uff08{}\uff09\u7684name\u4f20\u9012\u4e3a\u7a7a\uff0cpageInfo\u5185\u5bb9\u4e3a\uff1a{}", (Object)pageInfo.getId(), (Object)JSONObject.toJSONString((Object)pageInfo));
        }
        if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
            if (ToolUtil.isNotEmpty((Object)JSONObject.parseObject((String)pageInfo.getData()).getJSONObject("slots"))) {
                JSONArray components = JSONObject.parseObject((String)pageInfo.getData()).getJSONObject("slots").getJSONArray("default");
                this.registerLocalComponents(components);
            }
            this.disposeQuoteRelation(pageInfo.getId(), pageInfo.getData());
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(pageInfo.getType())).cascadeEdit((BaseFile)pageInfo);
            this.pageInfoService.updateFile(pageInfo);
        } else {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(pageInfo.getType())).cascadeEdit((BaseFile)pageInfo);
            this.pageInfoService.updateFileMeta(pageInfo);
        }
        if (!FileOperEnum.UPDATE.getOperType().equals(pageInfo.getOperType())) {
            this.lockManagerService.saveLockByFile((BaseFile)pageInfo);
        }
        return formDesignResponse;
    }

    @Override
    public FormDesignResponse<JSONObject> updateAllDataInfoTemplate(PageInfo pageInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(pageInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        if (ToolUtil.isEmpty((Object)pageInfo) || ToolUtil.isEmpty((Object)pageInfo.getName())) {
            logger.error("\u6587\u4ef6\uff08{}\uff09\u7684name\u4f20\u9012\u4e3a\u7a7a\uff0cpageInfo\u5185\u5bb9\u4e3a\uff1a{}", (Object)pageInfo.getId(), (Object)JSONObject.toJSONString((Object)pageInfo));
        }
        if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
            this.disposeQuoteRelation(pageInfo.getId(), pageInfo.getData());
            JSONObject obj = this.pageInfoService.updateFileNew(pageInfo);
            formDesignResponse.setData((Object)obj);
        }
        return formDesignResponse;
    }

    @Override
    @HussarTransactional
    public FormDesignResponse<PageInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(id)).getErrorCode() != 200) {
            return sharedStorage;
        }
        ApiResponse<FileLockInfoVo> response = this.lockManagerService.checkLock(id, null);
        if (!response.isSuccess()) {
            FormDesignResponse formDesignResponse = new FormDesignResponse();
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData(response.getData());
            return formDesignResponse;
        }
        this.sysQuoteRelationService.deleteQuoteRelationByReferResid(id);
        this.resourcePublishService.deleteMenu(id);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageIds", id);
        this.iSysTemplatePrintInfoService.deleteTemplates(params);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(((PageInfo)this.pageInfoService.get(id)).getType())).cascadeDelete(id);
        Long resourceId = this.sysPublishRecordService.getResourceIdBySourceId(id);
        if (ToolUtil.isNotEmpty((Object)resourceId)) {
            this.resManageService.deleteDataByResourceId(resourceId);
            this.resManageService.deleteResource(String.valueOf(resourceId));
        }
        this.pageInfoService.delete(id);
        String appId = AppContextUtil.getNewAppId();
        this.hussarViewManagementService.deleteViewByPage(appId, id);
        return new FormDesignResponse();
    }

    @Override
    public FormDesignResponse<JSONObject> copyDataInfo(OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        ApiResponse<FileLockInfoVo> response = this.lockManagerService.checkLock(operateFileVO.getId(), null);
        if (!response.isSuccess()) {
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData((Object)((JSONObject)JSONObject.toJSON((Object)response.getData())));
            return formDesignResponse;
        }
        this.sysQuoteRelationService.copyQuoteRelation(operateFileVO.getId(), operateFileVO.getNewId());
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(((PageInfo)this.pageInfoService.get(operateFileVO.getId())).getType())).cascadeCopy(operateFileVO.getId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getParentId());
        JSONObject jsonObject = this.pageInfoService.copyNew(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        formDesignResponse.setData((Object)jsonObject);
        return formDesignResponse;
    }

    @Override
    public FormDesignResponse<PageInfo> moveDataInfo(OperateFileVO operateFileVO) throws IOException, LcdpException {
        ApiResponse<FileLockInfoVo> response = this.lockManagerService.checkLock(operateFileVO.getId(), null);
        if (!response.isSuccess()) {
            FormDesignResponse formDesignResponse = new FormDesignResponse();
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData(response.getData());
            return formDesignResponse;
        }
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(((PageInfo)this.pageInfoService.get(operateFileVO.getId())).getType())).cascadeMove(operateFileVO.getId(), operateFileVO.getNewName(), operateFileVO.getParentId());
        this.pageInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new FormDesignResponse();
    }

    @Override
    public void disposeQuoteRelation(String referResId, String data) {
        ArrayList<SysQuoteRelation> sysQuoteRelations = new ArrayList<SysQuoteRelation>();
        JSONObject parseObject = JSONObject.parseObject((String)data);
        JSONObject resObject = (JSONObject)parseObject.get((Object)"resReferencesIndex");
        HashMap resMap = new HashMap();
        for (Map.Entry entry : resObject.entrySet()) {
            resMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : resMap.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            obj.remove((Object)"id");
            SysQuoteRelation sysQuoteRelation = (SysQuoteRelation)JSONObject.toJavaObject((JSON)obj, SysQuoteRelation.class);
            sysQuoteRelation.setReferResId(referResId);
            sysQuoteRelations.add(sysQuoteRelation);
        }
        this.sysQuoteRelationService.deleteAndAddQuote(referResId, sysQuoteRelations);
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            formDesignResponse.setErrorCode(400);
            formDesignResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return formDesignResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !user.getId().equals(userId))) {
            formDesignResponse.setErrorCode(403);
            formDesignResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }

    private void registerLocalComponents(JSONArray components) {
        if (HussarUtils.isEmpty((Object)components)) {
            components = new JSONArray();
        }
        for (Object component : components) {
            JSONObject slots;
            JSONObject componentObj = (JSONObject)component;
            String componentName = componentObj.getString("name");
            if (componentName.contains("com.jxdinfo.local")) {
                ClazzFactory.register((String)componentName, (String)"com.jxdinfo.hussar.formdesign.elementui.element.Common");
                ModifierFactory.addComponentEventModifier((String)componentName, (String)"click", (String)"native");
                StyleFactory.addComponentClassName((String)componentName, (String)(".jxd_ins_" + componentName.replace("com.jxdinfo.local.JXD", "")));
            }
            if ((slots = componentObj.getJSONObject("slots")) == null) continue;
            for (Map.Entry entry : slots.entrySet()) {
                if (!(entry.getValue() instanceof JSONArray)) continue;
                this.registerLocalComponents((JSONArray)entry.getValue());
            }
        }
    }
}

